/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.psi.impl.DartClassReferenceImpl;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DartStringLiteralExpressionBase
extends DartClassReferenceImpl
implements DartStringLiteralExpression {
    private static final Logger LOG = Logger.getInstance((String)DartStringLiteralExpressionBase.class.getName());

    public DartStringLiteralExpressionBase(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.getParent() instanceof DartUriElement) {
            PsiReference[] psiReferenceArray = super.getReferences();
            if (psiReferenceArray == null) {
                DartStringLiteralExpressionBase.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.filterOutReferencesInTemplatesOrInjected(ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this));
        if (psiReferenceArray == null) {
            DartStringLiteralExpressionBase.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private PsiReference[] filterOutReferencesInTemplatesOrInjected(@NotNull PsiReference[] references) {
        if (references == null) {
            DartStringLiteralExpressionBase.$$$reportNull$$$0(2);
        }
        if (references.length == 0) {
            return references;
        }
        SmartList forbiddenRanges = new SmartList();
        InjectedLanguageUtil.enumerate((PsiElement)this, (arg_0, arg_1) -> this.lambda$filterOutReferencesInTemplatesOrInjected$0((List)forbiddenRanges, arg_0, arg_1));
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType type = child.getNode().getElementType();
            if (type == DartTokenTypes.OPEN_QUOTE || type == DartTokenTypes.REGULAR_STRING_PART || type == DartTokenTypes.CLOSING_QUOTE || type == DartTokenTypes.RAW_SINGLE_QUOTED_STRING || type == DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) continue;
            forbiddenRanges.add(child.getTextRange().shiftRight(-this.getTextRange().getStartOffset()));
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>(references.length);
        block1: for (PsiReference reference : references) {
            for (TextRange forbiddenRange : forbiddenRanges) {
                if (!reference.getRangeInElement().intersectsStrict(forbiddenRange)) continue;
                continue block1;
            }
            result.add(reference);
        }
        return result.toArray(PsiReference.EMPTY_ARRAY);
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            DartStringLiteralExpressionBase.$$$reportNull$$$0(3);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            DartStringLiteralExpressionBase.$$$reportNull$$$0(4);
        }
        return literalTextEscaper;
    }

    private /* synthetic */ void lambda$filterOutReferencesInTemplatesOrInjected$0(List forbiddenRanges, PsiFile injectedPsi, List places) {
        for (PsiLanguageInjectionHost.Shred place : places) {
            if (place.getHost() != this) continue;
            forbiddenRanges.add(place.getRangeInsideHost());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterOutReferencesInTemplatesOrInjected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartStringManipulator
    extends AbstractElementManipulator<DartStringLiteralExpression> {
        public DartStringLiteralExpression handleContentChange(@NotNull DartStringLiteralExpression oldElement, @NotNull TextRange range, @NotNull String newContent) {
            if (oldElement == null) {
                DartStringManipulator.$$$reportNull$$$0(0);
            }
            if (range == null) {
                DartStringManipulator.$$$reportNull$$$0(1);
            }
            if (newContent == null) {
                DartStringManipulator.$$$reportNull$$$0(2);
            }
            int expectedNewLength = oldElement.getTextLength() - range.getLength() + newContent.length();
            String newText = StringUtil.replaceSubstring((String)oldElement.getText(), (TextRange)range, (String)newContent);
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)oldElement.getProject()).createFileFromText(DartLanguage.INSTANCE, (CharSequence)("var a = " + newText + ";"));
            PsiElement elementAt = fileFromText.findElementAt("var a = ".length());
            if (elementAt != null && elementAt.getParent() instanceof DartStringLiteralExpression && expectedNewLength == elementAt.getParent().getTextLength()) {
                return (DartStringLiteralExpression)oldElement.replace(elementAt.getParent());
            }
            return oldElement;
        }

        @NotNull
        public TextRange getRangeInElement(@NotNull DartStringLiteralExpression element) {
            if (element == null) {
                DartStringManipulator.$$$reportNull$$$0(3);
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiElement next;
                IElementType type = child.getNode().getElementType();
                if (type == DartTokenTypes.OPEN_QUOTE && ((next = child.getNextSibling()) == null || next.getNode().getElementType() != DartTokenTypes.REGULAR_STRING_PART)) {
                    TextRange textRange = TextRange.from((int)(child.getStartOffsetInParent() + child.getTextLength()), (int)0);
                    if (textRange == null) {
                        DartStringManipulator.$$$reportNull$$$0(4);
                    }
                    return textRange;
                }
                if (type == DartTokenTypes.REGULAR_STRING_PART) {
                    TextRange textRange = child.getTextRange().shiftRight(-element.getTextRange().getStartOffset());
                    if (textRange == null) {
                        DartStringManipulator.$$$reportNull$$$0(5);
                    }
                    return textRange;
                }
                if (type != DartTokenTypes.RAW_SINGLE_QUOTED_STRING && type != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) continue;
                TextRange textRange = (TextRange)DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)child.getText()).second;
                TextRange textRange2 = textRange.shiftRight(child.getStartOffsetInParent());
                if (textRange2 == null) {
                    DartStringManipulator.$$$reportNull$$$0(6);
                }
                return textRange2;
            }
            LOG.error(element.getText());
            TextRange textRange = element.getTextRange();
            if (textRange == null) {
                DartStringManipulator.$$$reportNull$$$0(7);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleContentChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeInElement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

