/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartAwaitExpression;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartCascadeReferenceExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartSuperExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartValueExpression;
import com.jetbrains.lang.dart.psi.impl.DartExpressionImpl;
import com.jetbrains.lang.dart.resolve.DartResolver;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartReferenceImpl
extends DartExpressionImpl
implements DartReference,
PsiPolyVariantReference {
    public DartReferenceImpl(ASTNode node) {
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        DartReference[] dartReferences = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)this, DartReference.class);
        if (dartReferences != null && dartReferences.length > 0) {
            TextRange lastReferenceRange = dartReferences[dartReferences.length - 1].getTextRange();
            return new UnfairTextRange(lastReferenceRange.getStartOffset() - textRange.getStartOffset(), lastReferenceRange.getEndOffset() - textRange.getEndOffset());
        }
        return new UnfairTextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            DartReferenceImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        DartReferenceImpl element = this;
        if (this.getText().indexOf(46) != -1) {
            PsiElement lastChild = this.getLastChild();
            element = lastChild == null ? this : lastChild;
        }
        DartId identifier = (DartId)PsiTreeUtil.getChildOfType((PsiElement)element, DartId.class);
        DartId identifierNew = DartElementGenerator.createIdentifierFromText(this.getProject(), newElementName);
        if (identifier != null && identifierNew != null) {
            element.getNode().replaceChild(identifier.getNode(), identifierNew.getNode());
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DartReferenceImpl.$$$reportNull$$$0(1);
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        boolean chain;
        DartReference[] references = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)this, DartReference.class);
        boolean bl = chain = references != null && references.length == 2;
        if (chain) {
            return false;
        }
        PsiElement target = this.resolve();
        if (element.getParent() instanceof DartClass && target != null && DartComponentType.typeOf(target.getParent()) == DartComponentType.CONSTRUCTOR) {
            return true;
        }
        return target == element;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List elements = (List)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)DartResolver.INSTANCE, true, incompleteCode);
        ResolveResult[] resolveResultArray = DartResolveUtil.toCandidateInfoArray(elements);
        if (resolveResultArray == null) {
            DartReferenceImpl.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public DartClassResolveResult resolveDartClass() {
        PsiElement parent;
        DartExpression expression;
        if (this instanceof DartSuperExpression) {
            DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)this, DartClass.class);
            DartClassResolveResult dartClassResolveResult = dartClass == null ? DartClassResolveResult.EMPTY : dartClass.getSuperClassResolvedOrObjectClass();
            if (dartClassResolveResult == null) {
                DartReferenceImpl.$$$reportNull$$$0(3);
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartNewExpression) {
            DartClassResolveResult result = DartResolveUtil.resolveClassByType((DartType)PsiTreeUtil.getChildOfType((PsiElement)this, DartType.class));
            result.specialize((PsiElement)this);
            DartClassResolveResult dartClassResolveResult = result;
            if (dartClassResolveResult == null) {
                DartReferenceImpl.$$$reportNull$$$0(4);
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartCallExpression) {
            expression = ((DartCallExpression)((Object)this)).getExpression();
            DartClassResolveResult leftResult = DartReferenceImpl.tryGetLeftResolveResult(expression);
            if (expression instanceof DartReference) {
                DartClassResolveResult result = DartResolveUtil.getDartClassResolveResult(((DartReference)expression).resolve(), leftResult.getSpecialization());
                result.specialize((PsiElement)this);
                DartClassResolveResult dartClassResolveResult = result;
                if (dartClassResolveResult == null) {
                    DartReferenceImpl.$$$reportNull$$$0(5);
                }
                return dartClassResolveResult;
            }
        }
        if (this instanceof DartCascadeReferenceExpression && (parent = this.getParent()) instanceof DartValueExpression) {
            DartExpression firstExpression;
            List<DartExpression> expressionList = ((DartValueExpression)parent).getExpressionList();
            DartExpression dartExpression = firstExpression = expressionList.isEmpty() ? null : expressionList.get(0);
            if (firstExpression instanceof DartReference) {
                DartClassResolveResult dartClassResolveResult = ((DartReference)firstExpression).resolveDartClass();
                if (dartClassResolveResult == null) {
                    DartReferenceImpl.$$$reportNull$$$0(6);
                }
                return dartClassResolveResult;
            }
        }
        if (this instanceof DartAwaitExpression && (expression = ((DartAwaitExpression)((Object)this)).getExpression()) instanceof DartReference) {
            DartClassResolveResult result = ((DartReference)expression).resolveDartClass();
            DartClass resolvedClass = result.getDartClass();
            if (resolvedClass != null && "Future".equals(resolvedClass.getName())) {
                DartClassResolveResult unwrappedFuture = result.getSpecialization().get((PsiElement)resolvedClass, "T");
                DartClassResolveResult dartClassResolveResult = unwrappedFuture == null ? DartClassResolveResult.EMPTY : unwrappedFuture;
                if (dartClassResolveResult == null) {
                    DartReferenceImpl.$$$reportNull$$$0(7);
                }
                return dartClassResolveResult;
            }
            DartClassResolveResult dartClassResolveResult = result;
            if (dartClassResolveResult == null) {
                DartReferenceImpl.$$$reportNull$$$0(8);
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult(this.resolve(), DartReferenceImpl.tryGetLeftResolveResult(this).getSpecialization());
        if (dartClassResolveResult == null) {
            DartReferenceImpl.$$$reportNull$$$0(9);
        }
        return dartClassResolveResult;
    }

    @NotNull
    private static DartClassResolveResult tryGetLeftResolveResult(DartExpression expression) {
        DartReference[] childReferences = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, DartReference.class);
        DartReference leftReference = childReferences != null ? childReferences[0] : null;
        DartClassResolveResult dartClassResolveResult = leftReference != null ? leftReference.resolveDartClass() : DartClassResolveResult.create((DartClass)PsiTreeUtil.getParentOfType((PsiElement)expression, DartClass.class));
        if (dartClassResolveResult == null) {
            DartReferenceImpl.$$$reportNull$$$0(10);
        }
        return dartClassResolveResult;
    }

    @NotNull
    public Object[] getVariants() {
        if (LookupElement.EMPTY_ARRAY == null) {
            DartReferenceImpl.$$$reportNull$$$0(11);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartReferenceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartReferenceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDartClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetLeftResolveResult";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

