/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import icons.DartIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartLibraryNameElementBase
extends DartPsiCompositeElementImpl
implements PsiNameIdentifierOwner {
    public DartLibraryNameElementBase(@NotNull ASTNode node) {
        if (node == null) {
            DartLibraryNameElementBase.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String newLibraryName) throws IncorrectOperationException {
        DartLibraryNameElement libraryNameElementNew;
        if (newLibraryName == null) {
            DartLibraryNameElementBase.$$$reportNull$$$0(1);
        }
        if ((libraryNameElementNew = DartElementGenerator.createLibraryNameElementFromText(this.getProject(), newLibraryName)) != null) {
            this.getNode().replaceAllChildrenToChildrenOf(libraryNameElementNew.getNode());
        }
        return this;
    }

    @NotNull
    public String getName() {
        StringBuilder name = new StringBuilder();
        for (DartId id : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, DartId.class)) {
            if (name.length() > 0) {
                name.append('.');
            }
            name.append(id.getText());
        }
        String string = name.toString();
        if (string == null) {
            DartLibraryNameElementBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return DartLibraryNameElementBase.this.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return DartLibraryNameElementBase.this.getIcon(0);
            }
        };
    }

    public Icon getIcon(int flags) {
        return DartIcons.Dart_file;
    }

    public PsiElement getNameIdentifier() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibraryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/DartLibraryNameElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/DartLibraryNameElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

