/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartEnumDefinition;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartInterfaces;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartMixinApplication;
import com.jetbrains.lang.dart.psi.DartMixins;
import com.jetbrains.lang.dart.psi.DartSuperclass;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.psi.impl.AbstractDartComponentImpl;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDartPsiClass
extends AbstractDartComponentImpl
implements DartClass {
    private CachedValue<Map<String, List<DartComponent>>> myMembersCache;

    public AbstractDartPsiClass(@NotNull ASTNode node) {
        if (node == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public boolean isEnum() {
        return this instanceof DartEnumDefinition;
    }

    @Override
    @NotNull
    public List<DartEnumConstantDeclaration> getEnumConstantDeclarationList() {
        List<DartEnumConstantDeclaration> list = Collections.emptyList();
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public DartTypeParameters getTypeParameters() {
        return null;
    }

    @Override
    @NotNull
    public DartClassResolveResult getSuperClassResolvedOrObjectClass() {
        if ("Object".equals(this.getName())) {
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
            if (dartClassResolveResult == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(2);
            }
            return dartClassResolveResult;
        }
        DartType superClass = this.getSuperClass();
        DartClassResolveResult dartClassResolveResult = superClass != null ? DartResolveUtil.resolveClassByType(superClass) : DartResolveUtil.findCoreClass((PsiElement)this, "Object");
        if (dartClassResolveResult == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(3);
        }
        return dartClassResolveResult;
    }

    @Override
    @Nullable
    public DartType getSuperClass() {
        DartSuperclass superclass = (DartSuperclass)PsiTreeUtil.getChildOfType((PsiElement)this, DartSuperclass.class);
        if (superclass != null) {
            return superclass.getType();
        }
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        if (mixinApp != null) {
            return mixinApp.getType();
        }
        return null;
    }

    @Override
    @NotNull
    public List<DartType> getImplementsList() {
        DartInterfaces interfaces;
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        DartInterfaces dartInterfaces = interfaces = mixinApp != null ? mixinApp.getInterfaces() : (DartInterfaces)PsiTreeUtil.getChildOfType((PsiElement)this, DartInterfaces.class);
        if (interfaces != null) {
            List<DartType> list = DartResolveUtil.getTypes(interfaces.getTypeList());
            if (list == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<DartType> list = Collections.emptyList();
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartType> getMixinsList() {
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        DartMixins mixins = (DartMixins)PsiTreeUtil.getChildOfType((PsiElement)(mixinApp != null ? mixinApp : this), DartMixins.class);
        if (mixins != null) {
            List<DartType> list = DartResolveUtil.getTypes(mixins.getTypeList());
            if (list == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<DartType> list = Collections.emptyList();
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean isGeneric() {
        return this.getTypeParameters() != null;
    }

    @Override
    @NotNull
    public List<DartComponent> getMethods() {
        List<DartComponent> components = DartResolveUtil.findNamedSubComponents(this);
        List<DartComponent> list = DartResolveUtil.filterComponentsByType(components, DartComponentType.METHOD);
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartComponent> getFields() {
        List<DartComponent> components = DartResolveUtil.findNamedSubComponents(this);
        List<DartComponent> list = DartResolveUtil.filterComponentsByType(components, DartComponentType.FIELD);
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartComponent> getConstructors() {
        List<DartComponent> components = DartResolveUtil.getNamedSubComponents(this);
        String className = this.getName();
        if (className == null) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.filter(components, component -> DartComponentType.typeOf((PsiElement)component) == DartComponentType.CONSTRUCTOR);
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public List<DartMethodDeclaration> getOperators() {
        return DartResolveUtil.findOperators(this);
    }

    @Override
    @Nullable
    public DartMethodDeclaration findOperator(String operator, @Nullable DartClass rightDartClass) {
        return (DartMethodDeclaration)ContainerUtil.find(this.getOperators(), element -> {
            DartMethodDeclaration method;
            if (element instanceof DartMethodDeclaration && (method = (DartMethodDeclaration)element).isOperator() && operator.equals(method.getName())) {
                if (rightDartClass == null) {
                    return true;
                }
                DartFormalParameterList formalParameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
                return DartResolveUtil.checkParametersType(formalParameterList, rightDartClass);
            }
            return false;
        });
    }

    @Override
    public DartComponent findFieldByName(@NotNull String name) {
        if (name == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(12);
        }
        return (DartComponent)ContainerUtil.find(this.getFields(), component -> {
            if (name == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(18);
            }
            return name.equals(component.getName());
        });
    }

    @Override
    public DartComponent findMethodByName(@NotNull String name) {
        if (name == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(13);
        }
        return (DartComponent)ContainerUtil.find(this.getMethods(), component -> {
            if (name == null) {
                AbstractDartPsiClass.$$$reportNull$$$0(17);
            }
            return name.equals(component.getName());
        });
    }

    @Override
    public DartComponent findMemberByName(@NotNull String name) {
        List<DartComponent> membersByName;
        if (name == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(14);
        }
        return (membersByName = this.findMembersByName(name)).isEmpty() ? null : membersByName.iterator().next();
    }

    @Override
    @NotNull
    public List<DartComponent> findMembersByName(@NotNull String name) {
        if (name == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(15);
        }
        this.ensureMembersCacheInitialized();
        List components = (List)((Map)this.myMembersCache.getValue()).get(name);
        List list = components == null ? Collections.emptyList() : components;
        if (list == null) {
            AbstractDartPsiClass.$$$reportNull$$$0(16);
        }
        return list;
    }

    private void ensureMembersCacheInitialized() {
        if (this.myMembersCache == null) {
            this.myMembersCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                THashMap nameToMembers = new THashMap();
                for (DartComponent component : DartResolveUtil.findNamedSubComponents(false, this)) {
                    String dartClassName;
                    String componentName = component.getName();
                    DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)component, DartClass.class);
                    String string = dartClassName = dartClass != null ? dartClass.getName() : null;
                    if (dartClassName != null && dartClassName.equals(componentName)) continue;
                    List components = (List)nameToMembers.get(componentName);
                    if (components == null) {
                        components = new SmartList();
                        nameToMembers.put(componentName, components);
                    }
                    components.add(component);
                }
                return new CachedValueProvider.Result((Object)nameToMembers, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
    }

    @Override
    public DartComponent findNamedConstructor(String name) {
        return (DartComponent)ContainerUtil.find(this.getConstructors(), component -> name.equals(component.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumConstantDeclarationList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassResolvedOrObjectClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMixinsList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMembersByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFieldByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethodByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findMemberByName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMembersByName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethodByName$3";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFieldByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

