/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.psi.DartPackageAwareFileReference;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPackagePathReferenceProvider
extends PsiReferenceProvider {
    public static ElementFilter getFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object _element, PsiElement context) {
                if (!(_element instanceof PsiElement)) {
                    return false;
                }
                PsiElement element = (PsiElement)_element;
                PsiElement parentElement = element.getParent();
                PsiFile file = element.getContainingFile().getOriginalFile();
                VirtualFile vFile = file.getVirtualFile();
                return vFile != null && HtmlUtil.hasHtml((PsiFile)file) && parentElement instanceof XmlAttribute && DartPackagePathReferenceProvider.canContainDartPackageReference(((XmlAttribute)parentElement).getParent().getLocalName(), ((XmlAttribute)parentElement).getName()) && PubspecYamlUtil.findPubspecYamlFile(element.getProject(), vFile) != null;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    private static boolean canContainDartPackageReference(@Nullable String tagName, @Nullable String attrName) {
        return "link".equalsIgnoreCase(tagName) && "href".equalsIgnoreCase(attrName) || "script".equalsIgnoreCase(tagName) && "src".equalsIgnoreCase(attrName) || "img".equalsIgnoreCase(tagName) && "src".equalsIgnoreCase(attrName);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        if (psiElement == null) {
            DartPackagePathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DartPackagePathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof XmlAttributeValue) || !HtmlUtil.isHtmlFile((PsiElement)psiElement.getContainingFile())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag tag = ((XmlAttribute)parent).getParent();
        if (tag == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile file = DartResolveUtil.getRealVirtualFile(psiElement.getContainingFile());
        if (file == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!DartPackagePathReferenceProvider.canContainDartPackageReference(tag.getName(), ((XmlAttribute)parent).getName())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (PubspecYamlUtil.findPubspecYamlFile(psiElement.getProject(), file) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DartPackagePathReferenceProvider.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        FileReference[] fileReferenceArray = DartPackagePathReferenceProvider.getDartPackageReferences(psiElement, DartUrlResolver.getInstance(psiElement.getProject(), file));
        if (fileReferenceArray == null) {
            DartPackagePathReferenceProvider.$$$reportNull$$$0(8);
        }
        return fileReferenceArray;
    }

    private static FileReference[] getDartPackageReferences(@NotNull PsiElement psiElement, final @NotNull DartUrlResolver dartResolver) {
        if (psiElement == null) {
            DartPackagePathReferenceProvider.$$$reportNull$$$0(9);
        }
        if (dartResolver == null) {
            DartPackagePathReferenceProvider.$$$reportNull$$$0(10);
        }
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        String referenceText = psiElement.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
        FileReferenceSet referenceSet = new FileReferenceSet(referenceText, psiElement, textRange.getStartOffset(), null, true){

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new DartPackageAwareFileReference(this, range, index, text, dartResolver);
            }
        };
        return referenceSet.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/DartPackagePathReferenceProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/DartPackagePathReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDartPackageReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

