/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class DartPackageAwareFileReference
extends FileReference {
    @NotNull
    private final DartUrlResolver myDartResolver;

    public DartPackageAwareFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text, @NotNull DartUrlResolver dartResolver) {
        if (fileReferenceSet == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(0);
        }
        if (dartResolver == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(1);
        }
        super(fileReferenceSet, range, index, text);
        this.myDartResolver = dartResolver;
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(2);
        }
        if ("packages".equals(this.getText())) {
            PsiDirectory psiDirectory;
            VirtualFile pubspecYamlFile = this.myDartResolver.getPubspecYamlFile();
            VirtualFile packagesDir = pubspecYamlFile == null ? null : pubspecYamlFile.getParent().findChild("packages");
            PsiDirectory psiDirectory2 = psiDirectory = packagesDir == null ? null : containingFile.getManager().findDirectory(packagesDir);
            if (psiDirectory != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiDirectory)};
                if (resolveResultArray == null) {
                    DartPackageAwareFileReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
        }
        int index = this.getIndex();
        FileReference[] allReferences = this.getFileReferenceSet().getAllReferences();
        if (index > 0 && "packages".equals(allReferences[index - 1].getText())) {
            PsiDirectory psiDirectory;
            StringBuilder b = new StringBuilder();
            for (int i = index + 1; i < allReferences.length; ++i) {
                if (b.length() > 0) {
                    b.append('/');
                }
                b.append(allReferences[i].getText());
            }
            VirtualFile packageDir = this.myDartResolver.getPackageDirIfNotInOldStylePackagesFolder(this.getText(), b.toString());
            PsiDirectory psiDirectory3 = psiDirectory = packageDir == null ? null : containingFile.getManager().findDirectory(packageDir);
            if (psiDirectory != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiDirectory)};
                if (resolveResultArray == null) {
                    DartPackageAwareFileReference.$$$reportNull$$$0(4);
                }
                return resolveResultArray;
            }
        }
        ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
        if (resolveResultArray == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> result;
        Object[] superVariants = super.getVariants();
        if (this.getIndex() == 0) {
            PsiDirectory psiDirectory;
            VirtualFile pubspecYamlFile = this.myDartResolver.getPubspecYamlFile();
            VirtualFile packagesDir = pubspecYamlFile == null ? null : pubspecYamlFile.getParent().findChild("packages");
            PsiDirectory psiDirectory2 = psiDirectory = packagesDir == null ? null : this.getElement().getManager().findDirectory(packagesDir);
            if (psiDirectory != null) {
                Object[] objectArray = ArrayUtil.append((Object[])superVariants, (Object)psiDirectory);
                if (objectArray == null) {
                    DartPackageAwareFileReference.$$$reportNull$$$0(6);
                }
                return objectArray;
            }
        }
        if (this.getIndex() == 1 && "packages".equals(this.getFileReferenceSet().getReference(0).getText()) && !(result = new ArrayList<String>(this.myDartResolver.getLivePackageNames())).isEmpty()) {
            Collections.addAll(result, superVariants);
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                DartPackageAwareFileReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }
        if (superVariants == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(8);
        }
        return superVariants;
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String path;
        if (element == null) {
            DartPackageAwareFileReference.$$$reportNull$$$0(9);
        }
        if ((path = this.getFileReferenceSet().getPathString()).startsWith("packages/") || path.contains("/packages/")) {
            DartUrlResolver urlResolver;
            String newUrl;
            VirtualFile contextFile = DartResolveUtil.getRealVirtualFile(this.getElement().getContainingFile());
            VirtualFile targetFile = DartResolveUtil.getRealVirtualFile(element.getContainingFile());
            if (contextFile != null && targetFile != null && (newUrl = (urlResolver = DartUrlResolver.getInstance(element.getProject(), contextFile)).getDartUrlForFile(targetFile)).startsWith("package:")) {
                int index = path.startsWith("packages/") ? 0 : path.indexOf("/packages/") + 1;
                String newName = path.substring(0, index) + "packages" + "/" + newUrl.substring("package:".length());
                return this.rename(newName);
            }
        }
        return super.bindToElement(element, absolute);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

