/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPackageAwareFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("dart" == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return "dart";
    }

    public boolean acceptFile(@NotNull VirtualFile file) {
        if (file == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(1);
        }
        return HtmlUtil.isHtmlFile((VirtualFile)file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(2);
        }
        fileTypeSink.consume((Object)StdFileTypes.HTML);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(@NotNull FileContent content) {
        if (content == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(3);
        }
        if (PubspecYamlUtil.findPubspecYamlFile(content.getProject(), content.getFile()) == null) {
            if (FileIncludeInfo.EMPTY == null) {
                DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(4);
            }
            return FileIncludeInfo.EMPTY;
        }
        PsiFile psiFile = content.getPsiFile();
        FileIncludeInfo[] fileIncludeInfoArray = psiFile instanceof XmlFile ? DartPackageAwareFileIncludeProvider.getIncludeInfos((XmlFile)psiFile) : FileIncludeInfo.EMPTY;
        if (fileIncludeInfoArray == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(5);
        }
        return fileIncludeInfoArray;
    }

    private static FileIncludeInfo[] getIncludeInfos(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(6);
        }
        final ArrayList result = new ArrayList();
        xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String path;
                String string = "link".equalsIgnoreCase(tag.getName()) ? DartPackageAwareFileIncludeProvider.getPathRelativeToPackageRoot(tag.getAttributeValue("href")) : (path = "script".equalsIgnoreCase(tag.getName()) ? DartPackageAwareFileIncludeProvider.getPathRelativeToPackageRoot(tag.getAttributeValue("src")) : null);
                if (!StringUtil.isEmptyOrSpaces((String)path)) {
                    result.add(new FileIncludeInfo(path));
                }
                super.visitXmlTag(tag);
            }

            public void visitElement(PsiElement element) {
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }
        });
        return (FileIncludeInfo[])ContainerUtil.toArray(result, (Object[])FileIncludeInfo.EMPTY);
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        VirtualFile contextFile;
        VirtualFile pubspecYamlFile;
        if (info == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DartPackageAwareFileIncludeProvider.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = pubspecYamlFile = (contextFile = DartResolveUtil.getRealVirtualFile(context)) == null ? null : PubspecYamlUtil.findPubspecYamlFile(context.getProject(), contextFile);
        if (pubspecYamlFile == null) {
            return null;
        }
        VirtualFile targetFile = null;
        int slashIndex = info.path.indexOf(47);
        if (slashIndex > 0) {
            String packageName = info.path.substring(0, slashIndex);
            String relPath = info.path.substring(slashIndex + 1);
            DartUrlResolver urlResolver = DartUrlResolver.getInstance(context.getProject(), contextFile);
            VirtualFile packageDir = urlResolver.getPackageDirIfNotInOldStylePackagesFolder(packageName, relPath);
            if (packageDir != null) {
                targetFile = packageDir.findFileByRelativePath(relPath);
            }
        }
        if (targetFile == null) {
            targetFile = VfsUtilCore.findRelativeFile((String)("packages/" + info.path), (VirtualFile)pubspecYamlFile);
        }
        if (targetFile != null) {
            return targetFile.isDirectory() ? context.getManager().findDirectory(targetFile) : context.getManager().findFile(targetFile);
        }
        return null;
    }

    @Nullable
    private static String getPathRelativeToPackageRoot(@Nullable String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("packages/")) {
            return path.substring("packages".length() + 1);
        }
        int index = path.indexOf("/packages/");
        if (index > 0) {
            return path.substring(index + "packages".length() + 2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfos";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

