/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.resolve.DartResolver;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DartContributedReference
implements PsiPolyVariantReference {
    private static final DartContributedReferenceResolver RESOLVER = new DartContributedReferenceResolver();
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final DartServerData.DartNavigationRegion myNavigationRegion;
    @NotNull
    private final TextRange myRefRange;
    @NotNull
    private final String myRefText;

    public DartContributedReference(@NotNull PsiElement element, @NotNull DartServerData.DartNavigationRegion navigationRegion) {
        if (element == null) {
            DartContributedReference.$$$reportNull$$$0(0);
        }
        if (navigationRegion == null) {
            DartContributedReference.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myNavigationRegion = navigationRegion;
        int startOffset = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange().getStartOffset());
        this.myRefRange = TextRange.from((int)(navigationRegion.getOffset() - startOffset), (int)navigationRegion.getLength());
        this.myRefText = element.getText().substring(this.myRefRange.getStartOffset(), this.myRefRange.getEndOffset());
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            DartContributedReference.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public DartServerData.DartNavigationRegion getNavigationRegion() {
        DartServerData.DartNavigationRegion dartNavigationRegion = this.myNavigationRegion;
        if (dartNavigationRegion == null) {
            DartContributedReference.$$$reportNull$$$0(3);
        }
        return dartNavigationRegion;
    }

    public TextRange getRangeInElement() {
        return this.myRefRange;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List elements = (List)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)RESOLVER, true, incompleteCode);
        ResolveResult[] resolveResultArray = DartResolveUtil.toCandidateInfoArray(elements);
        if (resolveResultArray == null) {
            DartContributedReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRefText;
        if (string == null) {
            DartContributedReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DartContributedReference.$$$reportNull$$$0(6);
        }
        return this.getElement();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            DartContributedReference.$$$reportNull$$$0(7);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationRegion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/psi/DartContributedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/psi/DartContributedReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationRegion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartContributedReferenceResolver
    implements ResolveCache.AbstractResolver<DartContributedReference, List<? extends PsiElement>> {
        private DartContributedReferenceResolver() {
        }

        public List<? extends PsiElement> resolve(@NotNull DartContributedReference reference, boolean incompleteCode) {
            if (reference == null) {
                DartContributedReferenceResolver.$$$reportNull$$$0(0);
            }
            return DartResolver.getTargetElements(reference.getElement().getProject(), reference.getNavigationRegion());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/psi/DartContributedReference$DartContributedReferenceResolver", "resolve"));
        }
    }
}

