/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.projectWizard.DartProjectTemplate;
import com.jetbrains.lang.dart.projectWizard.Stagehand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class StagehandTemplate
extends DartProjectTemplate {
    @NotNull
    private final Stagehand myStagehand;
    @NotNull
    private final Stagehand.StagehandDescriptor myTemplate;

    public StagehandTemplate(@NotNull Stagehand stagehand, @NotNull Stagehand.StagehandDescriptor template) {
        if (stagehand == null) {
            StagehandTemplate.$$$reportNull$$$0(0);
        }
        if (template == null) {
            StagehandTemplate.$$$reportNull$$$0(1);
        }
        super(StagehandTemplate.getLabel(template), template.myDescription);
        this.myStagehand = stagehand;
        this.myTemplate = template;
    }

    private static String getLabel(Stagehand.StagehandDescriptor descriptor) {
        return !StringUtil.isEmptyOrSpaces((String)descriptor.myLabel) ? descriptor.myLabel : descriptor.myId;
    }

    @Override
    public Collection<VirtualFile> generateProject(@NotNull String sdkRoot, @NotNull Module module, @NotNull VirtualFile baseDir) throws IOException {
        VirtualFile mainFile;
        if (sdkRoot == null) {
            StagehandTemplate.$$$reportNull$$$0(2);
        }
        if (module == null) {
            StagehandTemplate.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            StagehandTemplate.$$$reportNull$$$0(4);
        }
        try {
            this.myStagehand.generateInto(sdkRoot, baseDir, this.myTemplate.myId);
        }
        catch (Stagehand.StagehandException e) {
            throw new IOException(e);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        VirtualFile pubspec = LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDir.getPath() + "/" + "pubspec.yaml");
        ContainerUtil.addIfNotNull(files, (Object)pubspec);
        VirtualFile virtualFile = mainFile = this.myTemplate.myEntrypoint.isEmpty() ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDir.getPath() + "/" + this.myTemplate.myEntrypoint);
        if (mainFile != null && mainFile.getName().equals("index.html")) {
            ContainerUtil.addIfNotNull(files, (Object)mainFile.getParent().findChild("main.dart"));
        }
        ContainerUtil.addIfNotNull(files, mainFile);
        if (!this.myTemplate.myEntrypoint.isEmpty() && mainFile != null) {
            if (this.myTemplate.myEntrypoint.startsWith("bin/") && mainFile.getFileType() == DartFileType.INSTANCE) {
                StagehandTemplate.createCmdLineRunConfiguration(module, mainFile);
            }
            if (this.myTemplate.myEntrypoint.startsWith("web/") && mainFile.getFileType() == HtmlFileType.INSTANCE) {
                StagehandTemplate.createWebRunConfiguration(module, mainFile);
            }
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stagehand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/projectWizard/StagehandTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

