/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Stagehand {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.lang.dart.projectWizard.Stagehand");
    private static final List<StagehandDescriptor> EMPTY = new ArrayList<StagehandDescriptor>();

    public void generateInto(@NotNull String sdkRoot, @NotNull VirtualFile projectDirectory, @NotNull String templateId) throws StagehandException {
        ProcessOutput output;
        if (sdkRoot == null) {
            Stagehand.$$$reportNull$$$0(0);
        }
        if (projectDirectory == null) {
            Stagehand.$$$reportNull$$$0(1);
        }
        if (templateId == null) {
            Stagehand.$$$reportNull$$$0(2);
        }
        if ((output = new PubRunner(projectDirectory).runSync(sdkRoot, 30, "global", "run", "stagehand", "--author", SystemProperties.getUserName(), templateId)).getExitCode() != 0) {
            throw new StagehandException(output.getStderr());
        }
    }

    public List<StagehandDescriptor> getAvailableTemplates(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            Stagehand.$$$reportNull$$$0(3);
        }
        try {
            ProcessOutput output = new PubRunner().runSync(sdkRoot, 10, "global", "run", "stagehand", "--machine");
            int exitCode = output.getExitCode();
            if (exitCode != 0) {
                return EMPTY;
            }
            JSONArray arr = new JSONArray(output.getStdout());
            ArrayList<StagehandDescriptor> result = new ArrayList<StagehandDescriptor>();
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                result.add(new StagehandDescriptor(obj.getString("name"), obj.optString("label"), obj.getString("description"), obj.optString("entrypoint")));
            }
            result.sort((one, two) -> one.myLabel.compareToIgnoreCase(two.myLabel));
            return result;
        }
        catch (StagehandException | JSONException e) {
            LOG.info(e);
            return EMPTY;
        }
    }

    public void install(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            Stagehand.$$$reportNull$$$0(4);
        }
        try {
            new PubRunner().runSync(sdkRoot, 60, "global", "activate", "stagehand");
        }
        catch (StagehandException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/projectWizard/Stagehand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateInto";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAvailableTemplates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PubRunner {
        private final String myWorkingDirectory;

        PubRunner() {
            this.myWorkingDirectory = null;
        }

        PubRunner(VirtualFile workingDirectory) {
            this.myWorkingDirectory = workingDirectory.getCanonicalPath();
        }

        ProcessOutput runSync(@NotNull String sdkRoot, int timeoutInSeconds, String ... pubParameters) throws StagehandException {
            if (sdkRoot == null) {
                PubRunner.$$$reportNull$$$0(0);
            }
            GeneralCommandLine command = new GeneralCommandLine().withWorkDirectory(this.myWorkingDirectory);
            File pubFile = new File(DartSdkUtil.getPubPath(sdkRoot));
            command.setExePath(pubFile.getPath());
            command.addParameters(pubParameters);
            try {
                return new CapturingProcessHandler(command).runProcess(timeoutInSeconds * 1000, false);
            }
            catch (ExecutionException e) {
                throw new StagehandException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/Stagehand$PubRunner", "runSync"));
        }
    }

    public static class StagehandException
    extends Exception {
        public StagehandException(String message) {
            super(message);
        }

        public StagehandException(Throwable t) {
            super(t);
        }
    }

    public static class StagehandDescriptor {
        public final String myId;
        public final String myLabel;
        public final String myDescription;
        public final String myEntrypoint;

        public StagehandDescriptor(String id, String label, String description, String entrypoint) {
            this.myId = id;
            this.myLabel = label;
            this.myDescription = description;
            this.myEntrypoint = entrypoint;
        }

        public String toString() {
            return StringUtil.join((String[])new String[]{"[", this.myId, ",", this.myLabel, ",", this.myDescription, ",", this.myEntrypoint, "]"});
        }
    }
}

