/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.projectWizard.CmdLineAppTemplate;
import com.jetbrains.lang.dart.projectWizard.DartModuleBuilder;
import com.jetbrains.lang.dart.projectWizard.Stagehand;
import com.jetbrains.lang.dart.projectWizard.StagehandTemplate;
import com.jetbrains.lang.dart.projectWizard.WebAppTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DartProjectTemplate {
    private static final Stagehand STAGEHAND = new Stagehand();
    private static List<DartProjectTemplate> ourTemplateCache;
    private static final Logger LOG;
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;

    public DartProjectTemplate(@NotNull String name, @NotNull String description) {
        if (name == null) {
            DartProjectTemplate.$$$reportNull$$$0(0);
        }
        if (description == null) {
            DartProjectTemplate.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DartProjectTemplate.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            DartProjectTemplate.$$$reportNull$$$0(3);
        }
        return string;
    }

    public abstract Collection<VirtualFile> generateProject(@NotNull String var1, @NotNull Module var2, @NotNull VirtualFile var3) throws IOException;

    public static void loadTemplatesAsync(String sdkRoot, @NotNull Consumer<List<DartProjectTemplate>> templatesConsumer) {
        if (templatesConsumer == null) {
            DartProjectTemplate.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("DartProjectTemplate.loadTemplatesAsync() must be called in pooled thread without read action");
        }
        ArrayList<DartProjectTemplate> templates = new ArrayList<DartProjectTemplate>();
        try {
            templates.addAll(DartProjectTemplate.getStagehandTemplates(sdkRoot));
        }
        finally {
            if (templates.isEmpty()) {
                templates.add(new WebAppTemplate());
                templates.add(new CmdLineAppTemplate());
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (templatesConsumer == null) {
                    DartProjectTemplate.$$$reportNull$$$0(16);
                }
                templatesConsumer.consume((Object)templates);
            }, ModalityState.any());
        }
    }

    @NotNull
    private static List<DartProjectTemplate> getStagehandTemplates(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            DartProjectTemplate.$$$reportNull$$$0(5);
        }
        if (ourTemplateCache != null) {
            List<DartProjectTemplate> list = ourTemplateCache;
            if (list == null) {
                DartProjectTemplate.$$$reportNull$$$0(6);
            }
            return list;
        }
        STAGEHAND.install(sdkRoot);
        List<Stagehand.StagehandDescriptor> templates = STAGEHAND.getAvailableTemplates(sdkRoot);
        ourTemplateCache = new ArrayList<DartProjectTemplate>();
        for (Stagehand.StagehandDescriptor template : templates) {
            ourTemplateCache.add(new StagehandTemplate(STAGEHAND, template));
        }
        List<DartProjectTemplate> list = ourTemplateCache;
        if (list == null) {
            DartProjectTemplate.$$$reportNull$$$0(7);
        }
        return list;
    }

    static void createWebRunConfiguration(@NotNull Module module, @NotNull VirtualFile htmlFile) {
        if (module == null) {
            DartProjectTemplate.$$$reportNull$$$0(8);
        }
        if (htmlFile == null) {
            DartProjectTemplate.$$$reportNull$$$0(9);
        }
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            Url url;
            if (module == null) {
                DartProjectTemplate.$$$reportNull$$$0(14);
            }
            if (htmlFile == null) {
                DartProjectTemplate.$$$reportNull$$$0(15);
            }
            if ((url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)PsiManager.getInstance((Project)module.getProject()).findFile(htmlFile))) == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            try {
                RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("", JavascriptDebugConfigurationType.getTypeInstance().getFactory());
                ((JavaScriptDebugConfiguration)settings.getConfiguration()).setUri(url.toDecodedForm());
                settings.setName(((JavaScriptDebugConfiguration)settings.getConfiguration()).suggestedName());
                runManager.addConfiguration(settings, false);
                runManager.setSelectedConfiguration(settings);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, module);
    }

    static void createCmdLineRunConfiguration(@NotNull Module module, @NotNull VirtualFile mainDartFile) {
        if (module == null) {
            DartProjectTemplate.$$$reportNull$$$0(10);
        }
        if (mainDartFile == null) {
            DartProjectTemplate.$$$reportNull$$$0(11);
        }
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            if (module == null) {
                DartProjectTemplate.$$$reportNull$$$0(12);
            }
            if (mainDartFile == null) {
                DartProjectTemplate.$$$reportNull$$$0(13);
            }
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("", DartCommandLineRunConfigurationType.getInstance().getConfigurationFactories()[0]);
            DartCommandLineRunConfiguration runConfiguration = (DartCommandLineRunConfiguration)settings.getConfiguration();
            runConfiguration.getRunnerParameters().setFilePath(mainDartFile.getPath());
            runConfiguration.getRunnerParameters().setWorkingDirectory(DartCommandLineRunnerParameters.suggestDartWorkingDir(module.getProject(), mainDartFile));
            settings.setName(runConfiguration.suggestedName());
            runManager.addConfiguration(settings, false);
            runManager.setSelectedConfiguration(settings);
        }, module);
    }

    static {
        LOG = Logger.getInstance((String)DartProjectTemplate.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoot";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlFile";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDartFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStagehandTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadTemplatesAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStagehandTemplates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWebRunConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCmdLineRunConfiguration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createCmdLineRunConfiguration$2";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createWebRunConfiguration$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadTemplatesAsync$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

