/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.actions.DartPubGetAction;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.projectWizard.DartModuleWizardStep;
import com.jetbrains.lang.dart.projectWizard.DartProjectWizardData;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import icons.DartIcons;
import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartModuleBuilder
extends ModuleBuilder {
    private static final Key<Boolean> PUB_GET_SCHEDULED_KEY = Key.create((String)"PUB_GET_SCHEDULED_KEY");
    private DartProjectWizardData myWizardData;

    public String getName() {
        return DartBundle.message("dart.title", new Object[0]);
    }

    public String getPresentableName() {
        return DartBundle.message("dart.title", new Object[0]);
    }

    public String getDescription() {
        return DartBundle.message("dart.project.description", new Object[0]);
    }

    public Icon getNodeIcon() {
        return DartIcons.Dart_16;
    }

    public ModuleType getModuleType() {
        return WebModuleType.getInstance();
    }

    public String getParentGroup() {
        return "Static Web";
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        DartModuleWizardStep step = new DartModuleWizardStep(context);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    void setWizardData(DartProjectWizardData wizardData) {
        this.myWizardData = wizardData;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        VirtualFile baseDir;
        ContentEntry contentEntry = this.doAddContentEntry(modifiableRootModel);
        VirtualFile virtualFile = baseDir = contentEntry == null ? null : contentEntry.getFile();
        if (baseDir != null) {
            DartModuleBuilder.setupProject(modifiableRootModel, baseDir, this.myWizardData);
        }
    }

    static void setupProject(@NotNull ModifiableRootModel modifiableRootModel, @NotNull VirtualFile baseDir, @NotNull DartProjectWizardData wizardData) {
        if (modifiableRootModel == null) {
            DartModuleBuilder.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            DartModuleBuilder.$$$reportNull$$$0(1);
        }
        if (wizardData == null) {
            DartModuleBuilder.$$$reportNull$$$0(2);
        }
        String templateName = wizardData.myTemplate == null ? "Empty project" : wizardData.myTemplate.getName();
        UsageTrigger.trigger((String)("DartProjectWizard." + templateName));
        DartModuleBuilder.setupSdkAndDartium(modifiableRootModel, wizardData);
        if (wizardData.myTemplate != null) {
            try {
                Collection<VirtualFile> filesToOpen = wizardData.myTemplate.generateProject(wizardData.dartSdkPath, modifiableRootModel.getModule(), baseDir);
                if (!filesToOpen.isEmpty()) {
                    DartModuleBuilder.scheduleFilesOpeningAndPubGet(modifiableRootModel.getModule(), filesToOpen);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void setupSdkAndDartium(@NotNull ModifiableRootModel modifiableRootModel, @NotNull DartProjectWizardData wizardData) {
        if (modifiableRootModel == null) {
            DartModuleBuilder.$$$reportNull$$$0(3);
        }
        if (wizardData == null) {
            DartModuleBuilder.$$$reportNull$$$0(4);
        }
        if (DartSdkUtil.isDartSdkHome(wizardData.dartSdkPath)) {
            Project project = modifiableRootModel.getProject();
            DartSdkUtil.updateKnownSdkPaths(project, wizardData.dartSdkPath);
            LibraryTable.ModifiableModel libraryTableModifiableModel = ModifiableModelsProvider.SERVICE.getInstance().getLibraryTableModifiableModel(project);
            DartSdkLibUtil.ensureDartSdkConfigured(project, libraryTableModifiableModel, wizardData.dartSdkPath);
            if (libraryTableModifiableModel.isChanged()) {
                libraryTableModifiableModel.commit();
            } else {
                ModifiableModelsProvider.SERVICE.getInstance().disposeLibraryTableModifiableModel(libraryTableModifiableModel);
            }
            modifiableRootModel.addInvalidLibrary("Dart SDK", "project");
        }
        DartiumUtil.applyDartiumSettings(FileUtilRt.toSystemIndependentName((String)wizardData.dartiumPath), wizardData.dartiumSettings);
    }

    public static boolean isPubGetScheduledForNewlyCreatedProject(@NotNull Project project) {
        if (project == null) {
            DartModuleBuilder.$$$reportNull$$$0(5);
        }
        return project.getUserData(PUB_GET_SCHEDULED_KEY) == Boolean.TRUE;
    }

    private static void scheduleFilesOpeningAndPubGet(@NotNull Module module, @NotNull Collection<VirtualFile> files) {
        if (module == null) {
            DartModuleBuilder.$$$reportNull$$$0(6);
        }
        if (files == null) {
            DartModuleBuilder.$$$reportNull$$$0(7);
        }
        module.getProject().putUserData(PUB_GET_SCHEDULED_KEY, (Object)Boolean.TRUE);
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            if (module == null) {
                DartModuleBuilder.$$$reportNull$$$0(13);
            }
            if (files == null) {
                DartModuleBuilder.$$$reportNull$$$0(14);
            }
            module.getProject().putUserData(PUB_GET_SCHEDULED_KEY, null);
            FileEditorManager manager = FileEditorManager.getInstance((Project)module.getProject());
            for (VirtualFile file : files) {
                AnAction pubGetAction;
                manager.openFile(file, true);
                if (!"pubspec.yaml".equals(file.getName()) || !((pubGetAction = ActionManager.getInstance().getAction("Dart.pub.get")) instanceof DartPubGetAction)) continue;
                ((DartPubGetAction)pubGetAction).performPubAction(module, file, false);
            }
        }, module);
    }

    static void runWhenNonModalIfModuleNotDisposed(@NotNull Runnable runnable, @NotNull Module module) {
        if (runnable == null) {
            DartModuleBuilder.$$$reportNull$$$0(8);
        }
        if (module == null) {
            DartModuleBuilder.$$$reportNull$$$0(9);
        }
        if (module.getProject().isInitialized()) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, module.getDisposed());
            return;
        }
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> {
            if (runnable == null) {
                DartModuleBuilder.$$$reportNull$$$0(10);
            }
            if (module == null) {
                DartModuleBuilder.$$$reportNull$$$0(11);
            }
            if (ApplicationManager.getApplication().getCurrentModalityState() == ModalityState.NON_MODAL) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, o -> {
                    if (module == null) {
                        DartModuleBuilder.$$$reportNull$$$0(12);
                    }
                    return module.isDisposed();
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setupSdkAndDartium";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPubGetScheduledForNewlyCreatedProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleFilesOpeningAndPubGet";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenNonModalIfModuleNotDisposed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runWhenNonModalIfModuleNotDisposed$2";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scheduleFilesOpeningAndPubGet$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

