/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.projectWizard.DartProjectTemplate;
import com.jetbrains.lang.dart.projectWizard.DartProjectWizardData;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartGeneratorPeer
implements WebProjectGenerator.GeneratorPeer<DartProjectWizardData> {
    private static final String DART_PROJECT_TEMPLATE = "DART_PROJECT_TEMPLATE";
    private static final String CREATE_SAMPLE_UNCHECKED = "CREATE_SAMPLE_UNCHECKED";
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton mySdkPathComboWithBrowse;
    private JBLabel myVersionLabel;
    private JPanel myDartiumSettingsPanel;
    private ComboboxWithBrowseButton myDartiumPathComboWithBrowse;
    private JButton myDartiumSettingsButton;
    private JBCheckBox myCheckedModeCheckBox;
    private JPanel myTemplatesPanel;
    private JPanel myLoadingTemplatesPanel;
    private JPanel myLoadedTemplatesPanel;
    private JBCheckBox myCreateSampleProjectCheckBox;
    private JBList myTemplatesList;
    private JBLabel myErrorLabel;
    private ChromeSettings myDartiumSettingsCurrent;
    private boolean myIntellijLiveValidationEnabled = false;

    public DartGeneratorPeer() {
        BrowserSpecificSettings browserSpecificSettings;
        this.$$$setupUI$$$();
        this.mySdkPathComboWithBrowse.getComboBox().setEditable(true);
        WebBrowser dartiumInitial = DartiumUtil.getDartiumBrowser();
        this.myDartiumSettingsCurrent = new ChromeSettings();
        if (dartiumInitial != null && (browserSpecificSettings = dartiumInitial.getSpecificSettings()) instanceof ChromeSettings) {
            this.myDartiumSettingsCurrent = (ChromeSettings)browserSpecificSettings.clone();
        }
        String dartiumPath = dartiumInitial == null ? "" : FileUtilRt.toSystemDependentName((String)StringUtil.notNullize((String)dartiumInitial.getPath()));
        this.myDartiumPathComboWithBrowse.getComboBox().setEditable(true);
        this.myDartiumPathComboWithBrowse.getComboBox().getEditor().setItem(dartiumPath);
        DartSdkUtil.initDartSdkAndDartiumControls(null, this.mySdkPathComboWithBrowse, this.myVersionLabel, this.myDartiumPathComboWithBrowse, (Computable<ChromeSettings>)new Computable.PredefinedValueComputable((Object)this.myDartiumSettingsCurrent), this.myDartiumSettingsButton, (Computable<Boolean>)new Computable.PredefinedValueComputable((Object)false));
        DartiumUtil.setCheckedMode(this.myDartiumSettingsCurrent.getEnvironmentVariables(), true);
        this.myCheckedModeCheckBox.setVisible(false);
        this.myCreateSampleProjectCheckBox.addActionListener(e -> this.myTemplatesList.setEnabled(this.myCreateSampleProjectCheckBox.isSelected()));
        this.myTemplatesList.setEmptyText(DartBundle.message("set.sdk.to.see.sample.content.options", new Object[0]));
        this.myErrorLabel.setIcon(AllIcons.Actions.Lightning);
        this.myErrorLabel.setVisible(false);
        String sdkPath = this.mySdkPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim();
        String message = DartSdkUtil.getErrorMessageIfWrongSdkRootPath(sdkPath);
        if (message == null) {
            this.startLoadingTemplates();
        } else {
            this.myLoadingTemplatesPanel.setVisible(false);
            this.myCreateSampleProjectCheckBox.setEnabled(false);
            this.myTemplatesList.setEnabled(false);
            final JTextComponent editorComponent = (JTextComponent)this.mySdkPathComboWithBrowse.getComboBox().getEditor().getEditorComponent();
            editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    String sdkPath = DartGeneratorPeer.this.mySdkPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim();
                    String message = DartSdkUtil.getErrorMessageIfWrongSdkRootPath(sdkPath);
                    if (message == null) {
                        editorComponent.getDocument().removeDocumentListener((DocumentListener)((Object)this));
                        DartGeneratorPeer.this.startLoadingTemplates();
                    }
                }
            });
        }
    }

    private void startLoadingTemplates() {
        this.myLoadingTemplatesPanel.setVisible(true);
        this.myLoadingTemplatesPanel.setPreferredSize(this.myLoadedTemplatesPanel.getPreferredSize());
        this.myLoadedTemplatesPanel.setVisible(false);
        this.myCreateSampleProjectCheckBox.setSelected(false);
        AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon("Dart project templates loading");
        this.myLoadingTemplatesPanel.add((Component)asyncProcessIcon, new GridConstraints());
        asyncProcessIcon.resume();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String sdkPath = this.mySdkPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim();
            DartProjectTemplate.loadTemplatesAsync(sdkPath, (Consumer<List<DartProjectTemplate>>)((Consumer)templates -> {
                asyncProcessIcon.suspend();
                Disposer.dispose((Disposable)asyncProcessIcon);
                this.onTemplatesLoaded((List<DartProjectTemplate>)templates);
            }));
        });
    }

    private void onTemplatesLoaded(List<DartProjectTemplate> templates) {
        this.myLoadingTemplatesPanel.setVisible(false);
        this.myLoadedTemplatesPanel.setVisible(true);
        this.myCreateSampleProjectCheckBox.setEnabled(true);
        String selectedTemplateName = PropertiesComponent.getInstance().getValue(DART_PROJECT_TEMPLATE);
        this.myCreateSampleProjectCheckBox.setSelected(!CREATE_SAMPLE_UNCHECKED.equals(selectedTemplateName));
        this.myTemplatesList.setVisibleRowCount(Math.min(8, templates.size()));
        this.myTemplatesList.setEnabled(this.myCreateSampleProjectCheckBox.isSelected());
        DartProjectTemplate selectedTemplate = null;
        DefaultListModel<DartProjectTemplate> model = new DefaultListModel<DartProjectTemplate>();
        for (DartProjectTemplate template : templates) {
            model.addElement(template);
            if (!template.getName().equals(selectedTemplateName)) continue;
            selectedTemplate = template;
        }
        this.myTemplatesList.setModel(model);
        if (selectedTemplate != null) {
            this.myTemplatesList.setSelectedValue(selectedTemplate, true);
        } else if (templates.size() > 0) {
            this.myTemplatesList.setSelectedIndex(0);
        }
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DartProjectTemplate template = (DartProjectTemplate)value;
                String text = template.getDescription().isEmpty() ? template.getName() : template.getName() + " - " + StringUtil.decapitalize((String)template.getDescription());
                component.setText(text);
                return component;
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DartGeneratorPeer.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            DartGeneratorPeer.$$$reportNull$$$0(1);
        }
        settingsStep.addSettingsField(DartBundle.message("dart.sdk.path.label", new Object[0]), (JComponent)this.mySdkPathComboWithBrowse);
        settingsStep.addSettingsField(DartBundle.message("version.label", new Object[0]), (JComponent)this.myVersionLabel);
        settingsStep.addSettingsField(DartBundle.message("dartium.path.label", new Object[0]), (JComponent)this.myDartiumSettingsPanel);
        settingsStep.addSettingsComponent((JComponent)this.myTemplatesPanel);
    }

    @NotNull
    public DartProjectWizardData getSettings() {
        String sdkPath = FileUtil.toSystemIndependentName((String)this.mySdkPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim());
        String dartiumPath = FileUtil.toSystemIndependentName((String)this.myDartiumPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim());
        DartProjectTemplate template = this.myCreateSampleProjectCheckBox.isSelected() ? (DartProjectTemplate)this.myTemplatesList.getSelectedValue() : null;
        PropertiesComponent.getInstance().setValue(DART_PROJECT_TEMPLATE, template == null ? CREATE_SAMPLE_UNCHECKED : template.getName());
        DartProjectWizardData dartProjectWizardData = new DartProjectWizardData(sdkPath, dartiumPath, this.myDartiumSettingsCurrent, template);
        if (dartProjectWizardData == null) {
            DartGeneratorPeer.$$$reportNull$$$0(2);
        }
        return dartProjectWizardData;
    }

    @Nullable
    public ValidationInfo validate() {
        String sdkPath = this.mySdkPathComboWithBrowse.getComboBox().getEditor().getItem().toString().trim();
        String message = DartSdkUtil.getErrorMessageIfWrongSdkRootPath(sdkPath);
        if (message != null) {
            return new ValidationInfo(message, (JComponent)this.mySdkPathComboWithBrowse);
        }
        if (this.myCreateSampleProjectCheckBox.isSelected() && this.myTemplatesList.getSelectedValue() == null) {
            return new ValidationInfo(DartBundle.message("project.template.not.selected", new Object[0]), (JComponent)this.myCreateSampleProjectCheckBox);
        }
        return null;
    }

    public boolean validateInIntelliJ() {
        ValidationInfo info = this.validate();
        if (info == null) {
            this.myErrorLabel.setVisible(false);
            return true;
        }
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'><left>" + info.message + "</left></font>")));
        if (!this.myIntellijLiveValidationEnabled) {
            this.myIntellijLiveValidationEnabled = true;
            this.enableIntellijLiveValidation();
        }
        return false;
    }

    private void enableIntellijLiveValidation() {
        JTextComponent editorComponent = (JTextComponent)this.mySdkPathComboWithBrowse.getComboBox().getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DartGeneratorPeer.this.validateInIntelliJ();
            }
        });
        this.myCreateSampleProjectCheckBox.addActionListener(e -> this.validateInIntelliJ());
        this.myTemplatesList.addListSelectionListener(e -> this.validateInIntelliJ());
    }

    public boolean isBackgroundJobRunning() {
        return false;
    }

    public void addSettingsStateListener(final @NotNull WebProjectGenerator.SettingsStateListener stateListener) {
        if (stateListener == null) {
            DartGeneratorPeer.$$$reportNull$$$0(3);
        }
        JTextComponent editorComponent = (JTextComponent)this.mySdkPathComboWithBrowse.getComboBox().getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                stateListener.stateChanged(DartGeneratorPeer.this.validate() == null);
            }
        });
        this.myCreateSampleProjectCheckBox.addActionListener(e -> {
            if (stateListener == null) {
                DartGeneratorPeer.$$$reportNull$$$0(5);
            }
            stateListener.stateChanged(this.validate() == null);
        });
        this.myTemplatesList.addListSelectionListener(e -> {
            if (stateListener == null) {
                DartGeneratorPeer.$$$reportNull$$$0(4);
            }
            stateListener.stateChanged(this.validate() == null);
        });
    }

    private void createUIComponents() {
        this.mySdkPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
        this.myDartiumPathComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/projectWizard/DartGeneratorPeer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/projectWizard/DartGeneratorPeer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSettingsStateListener$6";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSettingsStateListener$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBList jBList;
        JPanel jPanel2;
        JPanel jPanel3;
        JButton jButton;
        JPanel jPanel4;
        JBLabel jBLabel2;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("version.label"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dart.sdk.path.label"));
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkPathComboWithBrowse;
        jPanel5.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myVersionLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("1.0");
        jPanel5.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDartiumSettingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myDartiumPathComboWithBrowse;
        jPanel4.add((Component)comboboxWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myDartiumSettingsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dartium.settings.button"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dartium.path.label"));
        jPanel5.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTemplatesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), null, (int)0, (int)0, null, null));
        this.myLoadedTemplatesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTemplatesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myCreateSampleProjectCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dart.project.generate.sample.content.label"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoadingTemplatesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dart.project.templates.loading.message"));
        jPanel.add((Component)jBLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCheckedModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("dartium.checked.mode.label"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("Error: Path to the Dart SDK is not specified.");
        jPanel5.add((Component)jBLabel, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel4.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel5.setLabelFor((Component)comboboxWithBrowseButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

