/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.projectView.DartIconProvider;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parentNode, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        VirtualFile pubspecYamlFile;
        if (parentNode == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (parentNode instanceof ExternalLibrariesNode) {
            List list = ContainerUtil.map(children, node -> {
                if (node instanceof NamedLibraryElementNode && ("Dart Packages".equals(node.getName()) || "Dart SDK".equals(node.getName()))) {
                    final boolean isSdkRoot = "Dart SDK".equals(node.getName());
                    return new NamedLibraryElementNode(node.getProject(), (NamedLibraryElement)((NamedLibraryElementNode)node).getValue(), settings){

                        public boolean canNavigate() {
                            return isSdkRoot;
                        }

                        public void navigate(boolean requestFocus) {
                            Project project = this.getProject();
                            if (project != null) {
                                DartConfigurable.openDartSettings(project);
                            }
                        }
                    };
                }
                return node;
            });
            if (list == null) {
                DartTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (parentNode instanceof NamedLibraryElementNode && ("Dart Packages".equals(parentNode.getName()) || "Dart SDK".equals(parentNode.getName()))) {
            boolean isSdkRoot = "Dart SDK".equals(parentNode.getName());
            List list = ContainerUtil.map(children, node -> {
                VirtualFile dir;
                VirtualFile virtualFile = dir = node instanceof PsiDirectoryNode ? ((PsiDirectoryNode)node).getVirtualFile() : null;
                if (dir != null && dir.isInLocalFileSystem() && dir.isDirectory() && (isSdkRoot || "lib".equals(dir.getName()))) {
                    return new DartSdkOrLibraryRootNode(node.getProject(), (PsiDirectory)((PsiDirectoryNode)node).getValue(), settings);
                }
                return node;
            });
            if (list == null) {
                DartTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Project project = parentNode.getProject();
        VirtualFile packagesDir = parentNode instanceof PsiDirectoryNode && project != null ? ((PsiDirectoryNode)parentNode).getVirtualFile() : null;
        VirtualFile parentFolder = packagesDir != null && packagesDir.isDirectory() && "packages".equals(packagesDir.getName()) ? packagesDir.getParent() : null;
        VirtualFile virtualFile = pubspecYamlFile = parentFolder != null ? parentFolder.findChild("pubspec.yaml") : null;
        if (pubspecYamlFile != null && !pubspecYamlFile.isDirectory()) {
            ArrayList<AbstractTreeNode> modifiedChildren = new ArrayList<AbstractTreeNode>(children);
            DartUrlResolver resolver = DartUrlResolver.getInstance(project, pubspecYamlFile);
            resolver.processLivePackages((PairConsumer<String, VirtualFile>)((PairConsumer)(packageName, packageDir) -> {
                VirtualFile folder;
                if (children == null) {
                    DartTreeStructureProvider.$$$reportNull$$$0(9);
                }
                if ((folder = packagesDir.findChild(packageName)) != null) {
                    AbstractTreeNode node = DartTreeStructureProvider.getFolderNode(children, folder);
                    if (node == null) {
                        modifiedChildren.add(new SymlinkToLivePackageNode(project, (String)packageName, (VirtualFile)packageDir));
                    } else {
                        node.getPresentation().setLocationString(DartTreeStructureProvider.getPackageLocationString(packageDir));
                    }
                }
            }));
            ArrayList<AbstractTreeNode> arrayList = modifiedChildren;
            if (arrayList == null) {
                DartTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    private static AbstractTreeNode getFolderNode(@NotNull Collection<AbstractTreeNode> nodes, @NotNull VirtualFile folder) {
        if (nodes == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (folder == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(7);
        }
        for (AbstractTreeNode node : nodes) {
            if (!(node instanceof PsiDirectoryNode) || !folder.equals(((PsiDirectoryNode)node).getVirtualFile())) continue;
            return node;
        }
        return null;
    }

    private static String getPackageLocationString(@NotNull VirtualFile packageDir) {
        String path;
        int lastSlashIndex;
        if (packageDir == null) {
            DartTreeStructureProvider.$$$reportNull$$$0(8);
        }
        int prevSlashIndex = (lastSlashIndex = (path = packageDir.getPath()).lastIndexOf("/")) == -1 ? -1 : path.substring(0, lastSlashIndex).lastIndexOf("/");
        return FileUtil.toSystemDependentName((String)(prevSlashIndex < 0 ? path : path.substring(prevSlashIndex + 1)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFolderNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modify$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartSdkOrLibraryRootNode
    extends PsiDirectoryNode {
        public DartSdkOrLibraryRootNode(Project project, PsiDirectory value, ViewSettings settings) {
            super(project, value, settings);
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        protected void updateImpl(PresentationData data) {
            VirtualFile parentDir;
            super.updateImpl(data);
            VirtualFile dir = this.getVirtualFile();
            VirtualFile virtualFile = parentDir = dir == null ? null : dir.getParent();
            if (parentDir != null && parentDir.isInLocalFileSystem() && dir.isDirectory() && "lib".equals(dir.getName())) {
                data.setPresentableText(parentDir.getName());
            }
            data.setLocationString("");
        }
    }

    private static class SymlinkToLivePackageNode
    extends AbstractTreeNode<String> {
        @NotNull
        private final String mySymlinkPath;

        public SymlinkToLivePackageNode(@NotNull Project project, @NotNull String packageName, @NotNull VirtualFile packageDir) {
            if (project == null) {
                SymlinkToLivePackageNode.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                SymlinkToLivePackageNode.$$$reportNull$$$0(1);
            }
            if (packageDir == null) {
                SymlinkToLivePackageNode.$$$reportNull$$$0(2);
            }
            super(project, (Object)packageName);
            this.myName = packageName;
            this.mySymlinkPath = DartTreeStructureProvider.getPackageLocationString(packageDir);
            this.setIcon(DartIconProvider.EXCLUDED_FOLDER_SYMLINK_ICON);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                SymlinkToLivePackageNode.$$$reportNull$$$0(3);
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(this.getIcon());
            presentation.setPresentableText(this.myName);
            presentation.setLocationString(this.mySymlinkPath);
        }

        public int getWeight() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDir";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

