/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.injection;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMultiHostInjector
implements MultiHostInjector {
    public static final String STRING_TEMPLATE_PLACEHOLDER = "Dart_string_template_placeholder ";
    @Nullable
    private static final Language JS_REGEXP_LANG = Language.findLanguageByID((String)"JSRegexp");

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<DartStringLiteralExpression>> list = Collections.singletonList(DartStringLiteralExpression.class);
        if (list == null) {
            DartMultiHostInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        if (registrar == null) {
            DartMultiHostInjector.$$$reportNull$$$0(1);
        }
        if (element == null) {
            DartMultiHostInjector.$$$reportNull$$$0(2);
        }
        if (element instanceof DartStringLiteralExpression) {
            if (DartMultiHostInjector.isRegExp((DartStringLiteralExpression)element)) {
                DartMultiHostInjector.injectRegExp(registrar, (DartStringLiteralExpression)element);
            } else {
                DartMultiHostInjector.injectHtmlIfNeeded(registrar, (DartStringLiteralExpression)element);
            }
        }
    }

    private static boolean isRegExp(@NotNull DartStringLiteralExpression element) {
        PsiElement parent3;
        PsiElement parent1;
        if (element == null) {
            DartMultiHostInjector.$$$reportNull$$$0(3);
        }
        PsiElement parentParent2 = (parent1 = element.getParent()) instanceof DartArgumentList && parent1.getFirstChild() == element ? parent1.getParent() : null;
        PsiElement psiElement = parent3 = parentParent2 instanceof DartArguments ? parentParent2.getParent() : null;
        if (parent3 instanceof DartNewExpression) {
            DartType type = ((DartNewExpression)parent3).getType();
            return type != null && "RegExp".equals(type.getText());
        }
        return false;
    }

    private static void injectRegExp(@NotNull MultiHostRegistrar registrar, @NotNull DartStringLiteralExpression element) {
        if (registrar == null) {
            DartMultiHostInjector.$$$reportNull$$$0(4);
        }
        if (element == null) {
            DartMultiHostInjector.$$$reportNull$$$0(5);
        }
        if (JS_REGEXP_LANG == null) {
            return;
        }
        PsiElement child = element.getFirstChild();
        IElementType elementType = child.getNode().getElementType();
        if (elementType != DartTokenTypes.RAW_SINGLE_QUOTED_STRING || child.getNextSibling() != null) {
            return;
        }
        Pair<String, TextRange> textAndRange = DartPsiImplUtil.getUnquotedDartStringAndItsRange(child.getText());
        if (((String)textAndRange.first).isEmpty()) {
            return;
        }
        registrar.startInjecting(JS_REGEXP_LANG);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, (TextRange)textAndRange.second);
        registrar.doneInjecting();
    }

    private static void injectHtmlIfNeeded(@NotNull MultiHostRegistrar registrar, @NotNull DartStringLiteralExpression element) {
        if (registrar == null) {
            DartMultiHostInjector.$$$reportNull$$$0(6);
        }
        if (element == null) {
            DartMultiHostInjector.$$$reportNull$$$0(7);
        }
        SmartList infos = new SmartList();
        StringBuilder textBuf = new StringBuilder();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType type = child.getNode().getElementType();
            if (type == DartTokenTypes.REGULAR_STRING_PART) {
                textBuf.append(child.getText());
                String suffix = null;
                PsiElement nextSibling = child.getNextSibling();
                if (nextSibling != null && nextSibling.getNode().getElementType() != DartTokenTypes.CLOSING_QUOTE) {
                    suffix = STRING_TEMPLATE_PLACEHOLDER;
                    textBuf.append(suffix);
                }
                infos.add(new HtmlPlaceInfo(TextRange.from((int)child.getStartOffsetInParent(), (int)child.getTextLength()), suffix));
                continue;
            }
            if (type != DartTokenTypes.RAW_SINGLE_QUOTED_STRING && type != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) continue;
            Pair<String, TextRange> stringAndRange = DartPsiImplUtil.getUnquotedDartStringAndItsRange(child.getText());
            String string = (String)stringAndRange.first;
            TextRange stringRange = (TextRange)stringAndRange.second;
            infos.add(new HtmlPlaceInfo(stringRange.shiftRight(child.getStartOffsetInParent()), null));
            textBuf.append(string);
        }
        if (textBuf.length() > 0 && DartMultiHostInjector.looksLikeHtml(textBuf.toString())) {
            registrar.startInjecting((Language)HTMLLanguage.INSTANCE);
            for (HtmlPlaceInfo info : infos) {
                registrar.addPlace(null, info.suffix, (PsiLanguageInjectionHost)element, info.range);
            }
            registrar.doneInjecting();
        }
    }

    private static boolean looksLikeHtml(@NotNull String text) {
        boolean hasTag;
        if (text == null) {
            DartMultiHostInjector.$$$reportNull$$$0(8);
        }
        if (!text.trim().startsWith("<")) {
            return false;
        }
        int tagStart = text.indexOf(60);
        int length = text.length();
        boolean bl = hasTag = tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-') && text.indexOf(62, tagStart) > 0;
        if (hasTag && Character.isLetter(text.charAt(tagStart + 1)) && !text.contains("/>") && !text.contains("</")) {
            return false;
        }
        return hasTag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/injection/DartMultiHostInjector";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/injection/DartMultiHostInjector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRegExp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "injectRegExp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "injectHtmlIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HtmlPlaceInfo {
        @NotNull
        private final TextRange range;
        @Nullable
        private final String suffix;

        public HtmlPlaceInfo(@NotNull TextRange range, @Nullable String suffix) {
            if (range == null) {
                HtmlPlaceInfo.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.suffix = suffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/injection/DartMultiHostInjector$HtmlPlaceInfo", "<init>"));
        }
    }
}

