/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template.postfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.ide.template.postfix.DartPostfixTemplateProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.dartlang.analysis.server.protocol.Position;
import org.dartlang.analysis.server.protocol.PostfixCompletionTemplate;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;

public class DartRemotePostfixTemplate
extends PostfixTemplate {
    protected DartRemotePostfixTemplate(PostfixCompletionTemplate template) {
        this(template.getName(), template.getKey(), template.getExample());
    }

    protected DartRemotePostfixTemplate(@NotNull String name, @NotNull String key, @NotNull String example) {
        if (name == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(0);
        }
        if (key == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(1);
        }
        if (example == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(2);
        }
        super(name, key, example);
    }

    public static DartRemotePostfixTemplate createTemplate(PostfixCompletionTemplate template) {
        try {
            String prefix = StringUtil.capitalize((String)template.getName());
            if (prefix.equals("!")) {
                prefix = "Bang";
            }
            Class<?> templateClass = Class.forName("com.jetbrains.lang.dart.ide.template.postfix." + prefix + "PostfixTemplate");
            Constructor<?> constructor = templateClass.getDeclaredConstructor(PostfixCompletionTemplate.class);
            return (DartRemotePostfixTemplate)((Object)constructor.newInstance(template));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            return new DartRemotePostfixTemplate(template);
        }
    }

    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(3);
        }
        if (copyDocument == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(4);
        }
        Project project = context.getProject();
        PsiFile psiFile = context.getContainingFile();
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        String version = service.getSdkVersion();
        Set<PostfixTemplate> templates = DartPostfixTemplateProvider.getTemplates(version);
        if (templates == null) {
            return false;
        }
        boolean found = false;
        for (PostfixTemplate temp : templates) {
            if (!temp.getKey().equals(this.getKey())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        service.updateFilesContent();
        return service.edit_isPostfixCompletionApplicable(psiFile.getOriginalFile().getVirtualFile(), newOffset, this.getKey());
    }

    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DartRemotePostfixTemplate.$$$reportNull$$$0(6);
        }
        Project project = context.getProject();
        PsiFile psiFile = context.getContainingFile();
        int offset = editor.getCaretModel().getOffset();
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        service.updateFilesContent();
        SourceChange sourceChange = service.edit_getPostfixCompletion(psiFile.getVirtualFile(), offset, this.getKey());
        if (sourceChange != null) {
            try {
                AssistUtils.applySourceChange(project, sourceChange, false);
                Position position = sourceChange.getSelection();
                if (position != null) {
                    editor.getCaretModel().moveToOffset(service.getConvertedOffset(psiFile.getVirtualFile(), position.getOffset()));
                }
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "example";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDocument";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/template/postfix/DartRemotePostfixTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "expand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

