/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.template.macro.DartMacroBase;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDefaultFormalNamedParameter;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMethodParametersMacro
extends DartMacroBase {
    public String getName() {
        return "dartMethodParameters";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        List<String> parameterNames;
        if (params == null) {
            DartMethodParametersMacro.$$$reportNull$$$0(0);
        }
        if ((parameterNames = this.getContainingMethodParameterNames(context.getPsiElementAtStartOffset())) == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (String name : parameterNames) {
            result.add(new TextResult(name));
        }
        return new ListResult((List)result);
    }

    @Nullable
    @VisibleForTesting
    public List<String> getContainingMethodParameterNames(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DartComponent parent = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{DartSetterDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartFactoryConstructorDeclaration.class, DartNamedConstructorDeclaration.class, DartMethodDeclaration.class, DartFunctionDeclarationWithBody.class});
        if (parent == null) {
            return null;
        }
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)parent, DartFormalParameterList.class);
        if (parameterList == null) {
            return null;
        }
        ArrayList results = Lists.newArrayList();
        for (DartNormalFormalParameter parameter : parameterList.getNormalFormalParameterList()) {
            DartMethodParametersMacro.findAndAddName(results, parameter);
        }
        DartOptionalFormalParameters optionalFormalParameters = parameterList.getOptionalFormalParameters();
        if (optionalFormalParameters != null) {
            for (DartDefaultFormalNamedParameter parameter : optionalFormalParameters.getDefaultFormalNamedParameterList()) {
                DartMethodParametersMacro.findAndAddName(results, parameter.getNormalFormalParameter());
            }
        }
        return results;
    }

    private static void findAndAddName(@NotNull List<String> results, @NotNull DartNormalFormalParameter parameter) {
        String name;
        DartComponentName componentName;
        if (results == null) {
            DartMethodParametersMacro.$$$reportNull$$$0(1);
        }
        if (parameter == null) {
            DartMethodParametersMacro.$$$reportNull$$$0(2);
        }
        if ((componentName = parameter.findComponentName()) != null && (name = componentName.getName()) != null) {
            results.add(name);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/template/macro/DartMethodParametersMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndAddName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

