/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.structure;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.structure.DartStructureViewElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dartlang.analysis.server.protocol.Outline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    @NotNull
    private final StructureViewTreeElement myRootElement;
    private final DartServerData.OutlineListener myListener;

    public DartStructureViewModel(@Nullable Editor editor, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DartStructureViewModel.$$$reportNull$$$0(0);
        }
        super(editor, psiFile);
        this.myListener = filePath -> {
            if (filePath.equals(this.getPsiFile().getVirtualFile().getPath())) {
                this.fireModelUpdate();
            }
        };
        this.myRootElement = new DartStructureViewRootElement(psiFile);
        DartAnalysisServerService.getInstance(this.getPsiFile().getProject()).addOutlineListener(this.myListener);
    }

    public void dispose() {
        DartAnalysisServerService.getInstance(this.getPsiFile().getProject()).removeOutlineListener(this.myListener);
        super.dispose();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewTreeElement structureViewTreeElement = this.myRootElement;
        if (structureViewTreeElement == null) {
            DartStructureViewModel.$$$reportNull$$$0(1);
        }
        return structureViewTreeElement;
    }

    @Nullable
    public Object getCurrentEditorElement() {
        if (this.getEditor() == null) {
            return null;
        }
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(this.getPsiFile().getProject());
        Outline outline = service.getOutline(this.getPsiFile().getVirtualFile());
        if (outline == null) {
            return null;
        }
        Outline result = this.findDeepestOutlineForOffset(this.getEditor().getCaretModel().getOffset(), outline);
        return DartStructureViewElement.getValue(result);
    }

    @NotNull
    private Outline findDeepestOutlineForOffset(int offset, @NotNull Outline outline) {
        if (outline == null) {
            DartStructureViewModel.$$$reportNull$$$0(2);
        }
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(this.getPsiFile().getProject());
        VirtualFile file = this.getPsiFile().getVirtualFile();
        List<Outline> children = outline.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Outline next;
                Outline child = children.get(i);
                int startOffset = service.getConvertedOffset(file, child.getOffset());
                int endOffset = service.getConvertedOffset(file, child.getOffset() + child.getLength());
                if (offset >= startOffset && offset <= endOffset) {
                    Outline outline2 = this.findDeepestOutlineForOffset(offset, child);
                    if (outline2 == null) {
                        DartStructureViewModel.$$$reportNull$$$0(3);
                    }
                    return outline2;
                }
                if (offset <= endOffset || i == children.size() - 1 || offset >= service.getConvertedOffset(file, (next = children.get(i + 1)).getOffset())) continue;
                Outline outline3 = next;
                if (outline3 == null) {
                    DartStructureViewModel.$$$reportNull$$$0(4);
                }
                return outline3;
            }
        }
        Outline outline4 = outline;
        if (outline4 == null) {
            DartStructureViewModel.$$$reportNull$$$0(5);
        }
        return outline4;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            DartStructureViewModel.$$$reportNull$$$0(6);
        }
        return sorterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestOutlineForOffset";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestOutlineForOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartStructureViewRootElement
    extends PsiTreeElementBase<PsiFile> {
        public DartStructureViewRootElement(PsiFile file) {
            super((PsiElement)file);
        }

        @Nullable
        public String getPresentableText() {
            return null;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            DartAnalysisServerService service = DartAnalysisServerService.getInstance(((PsiFile)this.getValue()).getProject());
            Outline outline = service.getOutline(((PsiFile)this.getValue()).getVirtualFile());
            List<StructureViewTreeElement> list = outline != null ? Arrays.asList(new DartStructureViewElement((PsiFile)this.getValue(), outline).getChildren()) : Collections.emptyList();
            if (list == null) {
                DartStructureViewRootElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel$DartStructureViewRootElement", "getChildrenBase"));
        }
    }
}

