/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import icons.DartIcons;
import javax.swing.Icon;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Outline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartStructureViewElement
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private static final LayeredIcon STATIC_FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark, AllIcons.Nodes.FinalMark});
    private static final LayeredIcon FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.FinalMark});
    private static final LayeredIcon STATIC_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon STATIC_METHOD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Method, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon TOP_LEVEL_FUNCTION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Function, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon TOP_LEVEL_VAR_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Variable, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon CONSTRUCTOR_INVOCATION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Class, AllIcons.Nodes.TabPin});
    private static final LayeredIcon FUNCTION_INVOCATION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Method, AllIcons.Nodes.TabPin});
    private static final LayeredIcon TOP_LEVEL_CONST_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Variable, AllIcons.Nodes.StaticMark, AllIcons.Nodes.FinalMark});
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final Outline myOutline;
    @NotNull
    private final String myValue;
    @NotNull
    private final String myPresentableText;

    public DartStructureViewElement(@NotNull PsiFile psiFile, @NotNull Outline outline) {
        if (psiFile == null) {
            DartStructureViewElement.$$$reportNull$$$0(0);
        }
        if (outline == null) {
            DartStructureViewElement.$$$reportNull$$$0(1);
        }
        this.myPsiFile = psiFile;
        this.myOutline = outline;
        this.myValue = DartStructureViewElement.getValue(outline);
        this.myPresentableText = DartStructureViewElement.getPresentableText(outline);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        DartStructureViewElement dartStructureViewElement = this;
        if (dartStructureViewElement == null) {
            DartStructureViewElement.$$$reportNull$$$0(2);
        }
        return dartStructureViewElement;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (this.myOutline.getChildren().isEmpty()) {
            if (EMPTY_ARRAY == null) {
                DartStructureViewElement.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        StructureViewTreeElement[] structureViewTreeElementArray = (StructureViewTreeElement[])ContainerUtil.map2Array(this.myOutline.getChildren(), DartStructureViewElement.class, outline -> new DartStructureViewElement(this.myPsiFile, (Outline)outline));
        if (structureViewTreeElementArray == null) {
            DartStructureViewElement.$$$reportNull$$$0(4);
        }
        return structureViewTreeElementArray;
    }

    public void navigate(boolean requestFocus) {
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(this.myPsiFile.getProject());
        int offset = service.getConvertedOffset(this.myPsiFile.getVirtualFile(), this.myOutline.getElement().getLocation().getOffset());
        new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), offset).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            DartStructureViewElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@NotNull Outline outline) {
        if (outline == null) {
            DartStructureViewElement.$$$reportNull$$$0(6);
        }
        Element element = outline.getElement();
        StringBuilder b = new StringBuilder(element.getName());
        if (!StringUtil.isEmpty((String)element.getTypeParameters())) {
            b.append(element.getTypeParameters());
        }
        if (!StringUtil.isEmpty((String)element.getParameters())) {
            b.append(element.getParameters());
        }
        if (!StringUtil.isEmpty((String)element.getReturnType())) {
            b.append(" ").append(DartPresentableUtil.RIGHT_ARROW).append(" ").append(element.getReturnType());
        }
        String string = b.toString();
        if (string == null) {
            DartStructureViewElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        Element element = this.myOutline.getElement();
        boolean finalOrConst = element.isConst() || element.isFinal();
        switch (element.getKind()) {
            case "CLASS": {
                return element.isAbstract() ? AllIcons.Nodes.AbstractClass : AllIcons.Nodes.Class;
            }
            case "CONSTRUCTOR": {
                return AllIcons.Nodes.Method;
            }
            case "CONSTRUCTOR_INVOCATION": {
                return CONSTRUCTOR_INVOCATION_ICON;
            }
            case "ENUM": {
                return AllIcons.Nodes.Enum;
            }
            case "ENUM_CONSTANT": {
                return STATIC_FINAL_FIELD_ICON;
            }
            case "FIELD": {
                if (finalOrConst && element.isTopLevelOrStatic()) {
                    return STATIC_FINAL_FIELD_ICON;
                }
                if (finalOrConst) {
                    return FINAL_FIELD_ICON;
                }
                if (element.isTopLevelOrStatic()) {
                    return STATIC_FIELD_ICON;
                }
                return AllIcons.Nodes.Field;
            }
            case "FUNCTION": {
                return element.isTopLevelOrStatic() ? TOP_LEVEL_FUNCTION_ICON : AllIcons.Nodes.Function;
            }
            case "FUNCTION_INVOCATION": {
                return FUNCTION_INVOCATION_ICON;
            }
            case "FUNCTION_TYPE_ALIAS": {
                return DartComponentType.TYPEDEF.getIcon();
            }
            case "GETTER": {
                return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
            }
            case "METHOD": {
                if (element.isAbstract()) {
                    return AllIcons.Nodes.AbstractMethod;
                }
                return element.isTopLevelOrStatic() ? STATIC_METHOD_ICON : AllIcons.Nodes.Method;
            }
            case "SETTER": {
                return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
            }
            case "TOP_LEVEL_VARIABLE": {
                return finalOrConst ? TOP_LEVEL_CONST_ICON : TOP_LEVEL_VAR_ICON;
            }
            case "UNIT_TEST_GROUP": {
                return AllIcons.RunConfigurations.Junit;
            }
            case "UNIT_TEST_TEST": {
                return DartIcons.TestNode;
            }
        }
        return null;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            DartStructureViewElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getValue(@NotNull Outline outline) {
        if (outline == null) {
            DartStructureViewElement.$$$reportNull$$$0(9);
        }
        Outline parent = outline.getParent();
        String string = (parent != null ? DartStructureViewElement.getValue(parent) + parent.getChildren().indexOf(outline) : "") + DartStructureViewElement.getPresentableText(outline);
        if (string == null) {
            DartStructureViewElement.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Object getKey() {
        String string = this.getPresentableText();
        if (string == null) {
            DartStructureViewElement.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean equals(Object obj) {
        return obj instanceof DartStructureViewElement && ((DartStructureViewElement)obj).getValue().equals(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/structure/DartStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/structure/DartStructureViewElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

