/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtil {
    @Nullable
    public static String findGroupOrTestName(@Nullable DartCallExpression expression) {
        DartArgumentList dartArgumentList;
        DartArguments arguments = expression == null ? null : expression.getArguments();
        DartArgumentList dartArgumentList2 = dartArgumentList = arguments == null ? null : arguments.getArgumentList();
        if (dartArgumentList == null || dartArgumentList.getExpressionList().isEmpty()) {
            return null;
        }
        DartExpression dartExpression = dartArgumentList.getExpressionList().get(0);
        String testName = dartExpression == null ? "" : StringUtil.unquoteString((String)dartExpression.getText());
        return testName;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        DartCallExpression callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, DartCallExpression.class, (boolean)false);
        while (callExpression != null) {
            if (TestUtil.isGroup(callExpression) || TestUtil.isTest(callExpression)) {
                return callExpression;
            }
            callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, DartCallExpression.class, (boolean)true);
        }
        return element != null ? element.getContainingFile() : null;
    }

    public static boolean isTest(@NotNull DartCallExpression expression) {
        if (expression == null) {
            TestUtil.$$$reportNull$$$0(0);
        }
        return TestUtil.checkCalledFunctionName(expression, "test");
    }

    public static boolean isGroup(@NotNull DartCallExpression expression) {
        if (expression == null) {
            TestUtil.$$$reportNull$$$0(1);
        }
        return TestUtil.checkCalledFunctionName(expression, "group");
    }

    private static boolean checkCalledFunctionName(@NotNull DartCallExpression callExpression, @NotNull String expectedName) {
        if (callExpression == null) {
            TestUtil.$$$reportNull$$$0(2);
        }
        if (expectedName == null) {
            TestUtil.$$$reportNull$$$0(3);
        }
        return expectedName.equals(callExpression.getExpression().getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/util/TestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isGroup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCalledFunctionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

