/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.runner.util.TestUtil;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestLocationProvider
implements SMTestLocator,
DumbAware {
    private static final List<Location> NONE = Collections.emptyList();
    private static final Gson GSON = new Gson();
    public static final DartTestLocationProvider INSTANCE = new DartTestLocationProvider();
    public static final Type STRING_LIST_TYPE = new TypeToken<List<String>>(){}.getType();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Location<PsiElement> location;
        PsiFile psiFile;
        int commaIdx1;
        int commaIdx2;
        int commaIdx3;
        if (protocol == null) {
            DartTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            DartTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DartTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DartTestLocationProvider.$$$reportNull$$$0(3);
        }
        if ((commaIdx3 = path.indexOf(44, (commaIdx2 = path.indexOf(44, (commaIdx1 = path.indexOf(44)) + 1)) + 1)) < 0) {
            List<Location> list = NONE;
            if (list == null) {
                DartTestLocationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        String filePath = path.substring(0, commaIdx1);
        int line = Integer.parseInt(path.substring(commaIdx1 + 1, commaIdx2));
        int column = Integer.parseInt(path.substring(commaIdx2 + 1, commaIdx3));
        String names = path.substring(commaIdx3 + 1);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        PsiFile psiFile2 = psiFile = file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof DartFile)) {
            List<Location> list = NONE;
            if (list == null) {
                DartTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (line >= 0 && column >= 0 && (location = DartTestLocationProvider.getLocationByLineAndColumn(psiFile, line, column)) != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                DartTestLocationProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> nodes = DartTestLocationProvider.pathToNodes(names);
        if (nodes.isEmpty()) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation((PsiElement)psiFile));
            if (list == null) {
                DartTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Location> list = this.getLocationByGroupAndTestNames(psiFile, nodes);
        if (list == null) {
            DartTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static Location<PsiElement> getLocationByLineAndColumn(@NotNull PsiFile file, int line, int column) {
        PsiElement parent3;
        Document document;
        if (file == null) {
            DartTestLocationProvider.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            return null;
        }
        int offset = document.getLineStartOffset(line) + column;
        PsiElement element = file.findElementAt(offset);
        PsiElement parent1 = element == null ? null : element.getParent();
        PsiElement parent2 = parent1 instanceof DartId ? parent1.getParent() : null;
        PsiElement psiElement = parent3 = parent2 instanceof DartReferenceExpression ? parent2.getParent() : null;
        if (parent3 instanceof DartCallExpression && (TestUtil.isTest((DartCallExpression)parent3) || TestUtil.isGroup((DartCallExpression)parent3))) {
            return new PsiLocation(parent3);
        }
        return null;
    }

    private static List<String> pathToNodes(String element) {
        return (List)GSON.fromJson(element, STRING_LIST_TYPE);
    }

    @VisibleForTesting
    public List<Location> getLocationForTest(@NotNull PsiFile psiFile, @NotNull String testPath) {
        if (psiFile == null) {
            DartTestLocationProvider.$$$reportNull$$$0(10);
        }
        if (testPath == null) {
            DartTestLocationProvider.$$$reportNull$$$0(11);
        }
        return this.getLocationByGroupAndTestNames(psiFile, DartTestLocationProvider.pathToNodes(testPath));
    }

    protected List<Location> getLocationByGroupAndTestNames(PsiFile psiFile, final List<String> nodes) {
        final ArrayList<Location> locations = new ArrayList<Location>();
        if (psiFile instanceof DartFile && !nodes.isEmpty()) {
            PsiElementProcessor<PsiElement> collector = new PsiElementProcessor<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    DartCallExpression expression;
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof DartCallExpression && (TestUtil.isTest(expression = (DartCallExpression)element) || TestUtil.isGroup(expression)) && ((String)nodes.get(nodes.size() - 1)).equals(DartTestLocationProvider.getTestLabel(expression))) {
                        boolean matches = true;
                        for (int i = nodes.size() - 2; i >= 0 && matches; --i) {
                            if ((expression = this.getGroup(expression)) != null && ((String)nodes.get(i)).equals(DartTestLocationProvider.getTestLabel(expression))) continue;
                            matches = false;
                        }
                        if (matches) {
                            locations.add(new PsiLocation(element));
                            return false;
                        }
                    }
                    return true;
                }

                @Nullable
                private DartCallExpression getGroup(DartCallExpression expression) {
                    return (DartCallExpression)PsiTreeUtil.findFirstParent((PsiElement)expression, (boolean)true, element -> element instanceof DartCallExpression && TestUtil.isGroup((DartCallExpression)element));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider$2", "execute"));
                }
            };
            PsiTreeUtil.processElements((PsiElement)psiFile, (PsiElementProcessor)collector);
        }
        return locations;
    }

    @Nullable
    public static String getTestLabel(@NotNull DartCallExpression testCallExpression) {
        DartArguments arguments;
        if (testCallExpression == null) {
            DartTestLocationProvider.$$$reportNull$$$0(12);
        }
        DartArgumentList argumentList = (arguments = testCallExpression.getArguments()) == null ? null : arguments.getArgumentList();
        List<DartExpression> argExpressions = argumentList == null ? null : argumentList.getExpressionList();
        return argExpressions != null && !argExpressions.isEmpty() && argExpressions.get(0) instanceof DartStringLiteralExpression ? StringUtil.unquoteString((String)argExpressions.get(0).getText()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocationByLineAndColumn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocationForTest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

