/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.ide.runner.test.DartTestEventsConverter;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRerunnerAction;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.util.DartTestLocationProvider;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRunningState
extends DartCommandLineRunningState {
    public static final String DART_FRAMEWORK_NAME = "DartTestRunner";
    private static final String RUN_COMMAND = "run";
    private static final String TEST_PACKAGE_SPEC = "test";
    private static final String EXPANDED_REPORTER_OPTION = "-r json";

    public DartTestRunningState(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            DartTestRunningState.$$$reportNull$$$0(0);
        }
        super(environment);
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            DartTestRunningState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            DartTestRunningState.$$$reportNull$$$0(2);
        }
        ProcessHandler processHandler = this.startProcess();
        ConsoleView consoleView = DartTestRunningState.createConsole(this.getEnvironment());
        consoleView.attachToProcess(processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler, this.createActions(consoleView, processHandler, executor));
        if (ActionManager.getInstance().getAction("RerunFailedTests") != null) {
            DartConsoleProperties properties = (DartConsoleProperties)((SMTRunnerConsoleView)consoleView).getProperties();
            AbstractRerunFailedTestsAction rerunFailedTestsAction = properties.createRerunFailedTestsAction(consoleView);
            assert (rerunFailedTestsAction != null);
            rerunFailedTestsAction.setModelProvider(() -> ((SMTRunnerConsoleView)((SMTRunnerConsoleView)consoleView)).getResultsViewer());
            executionResult.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
        } else {
            executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        }
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            DartTestRunningState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    private static ConsoleView createConsole(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            DartTestRunningState.$$$reportNull$$$0(4);
        }
        Project project = env.getProject();
        DartRunConfiguration runConfiguration = (DartRunConfiguration)env.getRunProfile();
        DartTestRunnerParameters runnerParameters = (DartTestRunnerParameters)runConfiguration.getRunnerParameters();
        DartConsoleProperties testConsoleProperties = new DartConsoleProperties(runConfiguration, env);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)DART_FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        try {
            VirtualFile dartFile = runnerParameters.getDartFileOrDirectory();
            consoleView.addMessageFilter((Filter)new DartConsoleFilter(project, dartFile));
            consoleView.addMessageFilter((Filter)new DartRelativePathsConsoleFilter(project, runnerParameters.computeProcessWorkingDirectory(project)));
            consoleView.addMessageFilter((Filter)new UrlFilter());
        }
        catch (RuntimeConfigurationError runtimeConfigurationError) {
            // empty catch block
        }
        Disposer.register((Disposable)project, (Disposable)consoleView);
        return consoleView;
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        Project project = this.getEnvironment().getProject();
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null) {
            throw new ExecutionException("Dart SDK cannot be found");
        }
        DartTestRunnerParameters params = this.getParameters();
        StringBuilder builder = new StringBuilder();
        builder.append(RUN_COMMAND);
        boolean projectWithoutPubspec = Registry.is((String)"dart.projects.without.pubspec", (boolean)false);
        String targetName = params.getTargetName();
        String testRunnerOptions = params.getTestRunnerOptions();
        if (projectWithoutPubspec && params.getScope() == DartTestRunnerParameters.Scope.FOLDER && targetName != null && !targetName.isEmpty()) {
            builder.append(" ").append(":").append(targetName).append(" ").append(EXPANDED_REPORTER_OPTION);
            if (testRunnerOptions != null && !testRunnerOptions.isEmpty()) {
                builder.append(" ").append(testRunnerOptions);
            }
        } else {
            builder.append(' ').append(TEST_PACKAGE_SPEC);
            builder.append(' ').append(EXPANDED_REPORTER_OPTION);
            if (testRunnerOptions != null && !testRunnerOptions.isEmpty()) {
                builder.append(" ").append(testRunnerOptions);
            }
            builder.append(' ').append(params.getFilePath());
            if (params.getScope() == DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME) {
                builder.append(" -N \"").append(StringUtil.notNullize((String)params.getTestName())).append("\"");
            }
            if (params.getScope() == DartTestRunnerParameters.Scope.MULTIPLE_NAMES) {
                String regex = StringUtil.notNullize((String)params.getTestName());
                if (regex.isEmpty()) {
                    throw new ExecutionException("No tests to run");
                }
                builder.append(" -n \"").append(regex).append("\"");
            }
        }
        params.setArguments(builder.toString());
        params.setCheckedMode(false);
        params.setWorkingDirectory(params.computeProcessWorkingDirectory(project));
        ProcessHandler processHandler = this.doStartProcess(DartSdkUtil.getPubSnapshotPath(sdk));
        if (processHandler == null) {
            DartTestRunningState.$$$reportNull$$$0(5);
        }
        return processHandler;
    }

    DartTestRunnerParameters getParameters() {
        return (DartTestRunnerParameters)this.myRunnerParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunningState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunningState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DartConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        public DartConsoleProperties(DartRunConfiguration runConfiguration, ExecutionEnvironment env) {
            super((RunConfiguration)runConfiguration, DartTestRunningState.DART_FRAMEWORK_NAME, env.getExecutor());
            this.setUsePredefinedMessageFilter(false);
            this.setIdBasedTestTree(true);
        }

        @Nullable
        public SMTestLocator getTestLocator() {
            return DartTestLocationProvider.INSTANCE;
        }

        public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                DartConsoleProperties.$$$reportNull$$$0(0);
            }
            if (consoleProperties == null) {
                DartConsoleProperties.$$$reportNull$$$0(1);
            }
            DartRunConfiguration runConfiguration = (DartRunConfiguration)this.getConfiguration();
            try {
                VirtualFile file = runConfiguration.getRunnerParameters().getDartFileOrDirectory();
                return new DartTestEventsConverter(testFrameworkName, consoleProperties, DartUrlResolver.getInstance(this.getProject(), file));
            }
            catch (RuntimeConfigurationError error) {
                throw new RuntimeException(error);
            }
        }

        @Nullable
        public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
            if (ActionManager.getInstance().getAction("RerunFailedTests") == null) {
                return null;
            }
            DartTestRerunnerAction action = new DartTestRerunnerAction((ComponentContainer)consoleView);
            action.init((TestConsoleProperties)this);
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testFrameworkName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleProperties";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunningState$DartConsoleProperties";
            objectArray[2] = "createTestEventsConverter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

