/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRunnerParameters
extends DartCommandLineRunnerParameters
implements Cloneable {
    @NotNull
    private Scope myScope = Scope.FILE;
    @Nullable
    private String myTestName = null;
    @Nullable
    private String myTargetName = null;
    @Nullable
    private String myTestRunnerOptions = null;

    @NotNull
    public Scope getScope() {
        Scope scope = this.myScope;
        if (scope == null) {
            DartTestRunnerParameters.$$$reportNull$$$0(0);
        }
        return scope;
    }

    public void setScope(Scope scope) {
        if (scope != null) {
            this.myScope = scope == Scope.GROUP || scope == Scope.METHOD ? Scope.GROUP_OR_TEST_BY_NAME : scope;
        }
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String name) {
        this.myTestName = name;
    }

    @Nullable
    public String getTargetName() {
        return this.myTargetName;
    }

    public void setTargetName(@Nullable String name) {
        this.myTargetName = name;
    }

    @Nullable
    public String getTestRunnerOptions() {
        return this.myTestRunnerOptions;
    }

    public void setTestRunnerOptions(@Nullable String testRunnerOptions) {
        this.myTestRunnerOptions = testRunnerOptions;
    }

    @Override
    public void check(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            DartTestRunnerParameters.$$$reportNull$$$0(1);
        }
        super.check(project);
        if (this.myScope == Scope.GROUP_OR_TEST_BY_NAME && StringUtil.isEmpty((String)this.myTestName)) {
            throw new RuntimeConfigurationError("Group or test name is not specified");
        }
    }

    @Override
    protected final DartTestRunnerParameters clone() {
        return (DartTestRunnerParameters)super.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunnerParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunnerParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Scope {
        FOLDER("All in folder"),
        FILE("All in file"),
        GROUP("Test group"),
        METHOD("Test name"),
        GROUP_OR_TEST_BY_NAME("Group or test by name"),
        MULTIPLE_NAMES("Multiple names");

        private final String myPresentableName;

        private Scope(String name) {
            this.myPresentableName = name;
        }

        public String getPresentableName() {
            return this.myPresentableName;
        }
    }
}

