/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRuntimeConfigurationProducer;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.util.TestUtil;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartTestRunConfigurationProducer
extends RunConfigurationProducer<DartTestRunConfiguration> {
    public DartTestRunConfigurationProducer() {
        super((ConfigurationType)DartTestRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(@NotNull DartTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement location;
        boolean ok;
        if (configuration == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (ok = (location = context.getPsiLocation()) instanceof PsiDirectory ? DartTestRunConfigurationProducer.setupRunnerParametersForFolderIfApplicable(configuration.getProject(), configuration.getRunnerParameters(), ((PsiDirectory)location).getVirtualFile()) : DartTestRunConfigurationProducer.setupRunnerParametersForFileIfApplicable(configuration.getRunnerParameters(), context, sourceElement)) {
            configuration.setGeneratedName();
        }
        return ok;
    }

    public boolean isConfigurationFromContext(@NotNull DartTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement testElement;
        if (configuration == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        DartTestRunnerParameters existingParams = configuration.getRunnerParameters();
        DartTestRunnerParameters paramsFromContext = new DartTestRunnerParameters();
        PsiElement location = context.getPsiLocation();
        if (location instanceof PsiDirectory ? !DartTestRunConfigurationProducer.setupRunnerParametersForFolder(paramsFromContext, ((PsiDirectory)location).getVirtualFile()) : (testElement = TestUtil.findTestElement(location)) == null || !DartTestRunConfigurationProducer.setupRunnerParametersForFile(paramsFromContext, testElement)) {
            return false;
        }
        return Comparing.equal((String)existingParams.getFilePath(), (String)paramsFromContext.getFilePath()) && Comparing.equal((Object)((Object)existingParams.getScope()), (Object)((Object)paramsFromContext.getScope())) && (existingParams.getScope() != DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME || Comparing.equal((String)existingParams.getTestName(), (String)paramsFromContext.getTestName()));
    }

    private static boolean setupRunnerParametersForFolderIfApplicable(@NotNull Project project, @NotNull DartTestRunnerParameters params, @NotNull VirtualFile dir) {
        VirtualFile testDir;
        DartUrlResolver urlResolver;
        VirtualFile dartTestLib;
        if (project == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (params == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((dartTestLib = (urlResolver = DartUrlResolver.getInstance(project, dir)).findFileByDartUrl("package:test/test.dart")) == null) {
            return false;
        }
        VirtualFile pubspec = urlResolver.getPubspecYamlFile();
        VirtualFile rootDir = pubspec == null ? null : pubspec.getParent();
        VirtualFile virtualFile = testDir = rootDir == null ? null : rootDir.findChild("test");
        if (testDir == null || !testDir.isDirectory()) {
            return false;
        }
        if (!rootDir.equals(dir) && !VfsUtilCore.isAncestor((VirtualFile)testDir, (VirtualFile)dir, (boolean)false)) {
            return false;
        }
        return DartTestRunConfigurationProducer.setupRunnerParametersForFolder(params, dir);
    }

    private static boolean setupRunnerParametersForFolder(@NotNull DartTestRunnerParameters params, @NotNull VirtualFile dir) {
        if (params == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ("test".equals(dir.getName()) && dir.findChild("pubspec.yaml") == null && dir.getParent().findChild("pubspec.yaml") != null) {
            dir = dir.getParent();
        }
        params.setScope(DartTestRunnerParameters.Scope.FOLDER);
        params.setFilePath(dir.getPath());
        return true;
    }

    private static boolean setupRunnerParametersForFileIfApplicable(@NotNull DartTestRunnerParameters params, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile dartFile;
        if (params == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (context == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (sourceElement == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if ((dartFile = DartCommandLineRuntimeConfigurationProducer.getRunnableDartFileFromContext(context, false)) == null || !DartTestRunConfigurationProducer.isFileInTestDirAndTestPackageExists(context.getProject(), dartFile)) {
            return false;
        }
        PsiElement testElement = TestUtil.findTestElement(context.getPsiLocation());
        if (testElement == null || !DartTestRunConfigurationProducer.setupRunnerParametersForFile(params, testElement)) {
            return false;
        }
        sourceElement.set((Object)testElement);
        return true;
    }

    public static boolean isFileInTestDirAndTestPackageExists(@NotNull Project project, @NotNull VirtualFile file) {
        DartUrlResolver urlResolver;
        VirtualFile dartTestLib;
        if (project == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (file == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if ((dartTestLib = (urlResolver = DartUrlResolver.getInstance(project, file)).findFileByDartUrl("package:test/test.dart")) == null) {
            return false;
        }
        VirtualFile pubspec = urlResolver.getPubspecYamlFile();
        VirtualFile rootDir = pubspec == null ? null : pubspec.getParent();
        VirtualFile testDir = rootDir == null ? null : rootDir.findChild("test");
        return testDir != null && testDir.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)testDir, (VirtualFile)file, (boolean)true);
    }

    private static boolean setupRunnerParametersForFile(@NotNull DartTestRunnerParameters runnerParams, @NotNull PsiElement psiElement) {
        if (runnerParams == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (psiElement == null) {
            DartTestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (psiElement instanceof DartCallExpression) {
            String testName = TestUtil.findGroupOrTestName((DartCallExpression)psiElement);
            List<VirtualFile> virtualFiles = DartResolveUtil.findLibrary(psiElement.getContainingFile());
            if (testName == null || virtualFiles.isEmpty()) {
                return false;
            }
            runnerParams.setTestName(testName);
            runnerParams.setScope(DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME);
            VirtualFile dartFile = virtualFiles.iterator().next();
            String dartFilePath = dartFile.getPath();
            runnerParams.setFilePath(dartFilePath);
            return true;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile instanceof DartFile) {
            VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile((PsiFile)((DartFile)psiElement));
            if (virtualFile == null || !DartResolveUtil.isLibraryRoot((PsiFile)((DartFile)psiElement))) {
                return false;
            }
            runnerParams.setTestName(DartResolveUtil.getLibraryName((PsiFile)((DartFile)psiElement)));
            runnerParams.setScope(DartTestRunnerParameters.Scope.FILE);
            String dartFilePath = FileUtil.toSystemIndependentName((String)virtualFile.getPath());
            runnerParams.setFilePath(dartFilePath);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParams";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRunnerParametersForFolderIfApplicable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRunnerParametersForFolder";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRunnerParametersForFileIfApplicable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInTestDirAndTestPackageExists";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRunnerParametersForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

