/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunningState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRerunner
implements RunProfileState {
    private final ExecutionEnvironment environment;
    private final List<AbstractTestProxy> failedTests;

    DartTestRerunner(@NotNull ExecutionEnvironment env, @NotNull List<AbstractTestProxy> tests) {
        if (env == null) {
            DartTestRerunner.$$$reportNull$$$0(0);
        }
        if (tests == null) {
            DartTestRerunner.$$$reportNull$$$0(1);
        }
        this.environment = env;
        this.failedTests = tests;
    }

    ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            DartTestRerunner.$$$reportNull$$$0(2);
        }
        DartTestRunningState state = new DartTestRunningState(this.environment);
        DartTestRunnerParameters params = state.getParameters();
        params.setScope(DartTestRunnerParameters.Scope.MULTIPLE_NAMES);
        params.setTestName(this.computeTestNameRegexp());
        return state.execute(executor, runner);
    }

    @NotNull
    Module[] getModulesToCompile() {
        if (Module.EMPTY_ARRAY == null) {
            DartTestRerunner.$$$reportNull$$$0(3);
        }
        return Module.EMPTY_ARRAY;
    }

    private String computeTestNameRegexp() {
        StringBuilder buf = new StringBuilder();
        for (AbstractTestProxy test : this.failedTests) {
            assert (test instanceof SMTestProxy) : test.getClass().getName();
            TestStateInfo.Magnitude magnitude = ((SMTestProxy)test).getMagnitudeInfo();
            if (test.getParent() == null || ((SMTestProxy)test).isSuite() || !test.isLeaf() || magnitude != TestStateInfo.Magnitude.FAILED_INDEX && magnitude != TestStateInfo.Magnitude.ERROR_INDEX && magnitude != TestStateInfo.Magnitude.TERMINATED_INDEX) continue;
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(DartTestRerunner.buildFullTestName(test));
        }
        return buf.toString();
    }

    private static String buildFullTestName(@NotNull AbstractTestProxy test) {
        if (test == null) {
            DartTestRerunner.$$$reportNull$$$0(4);
        }
        StringBuffer fullName = new StringBuffer();
        DartTestRerunner.buildFullTestName(test.getParent(), fullName);
        fullName.append(test.getName());
        return StringUtil.escapeToRegexp((String)fullName.toString());
    }

    private static void buildFullTestName(AbstractTestProxy test, StringBuffer fullName) {
        if (test == null) {
            return;
        }
        DartTestRerunner.buildFullTestName(test.getParent(), fullName);
        String url = test.getLocationUrl();
        if (url == null || url.endsWith(",[]")) {
            return;
        }
        String name = test.getName();
        if (name == null || name.equals("[root]")) {
            return;
        }
        fullName.append(name);
        fullName.append(' ');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToCompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFullTestName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

