/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.ide.runner.util.DartTestLocationProvider;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.TIntLongHashMap;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    private static final Logger LOG = Logger.getInstance((String)DartTestEventsConverter.class.getName());
    private static final String TYPE_START = "start";
    private static final String TYPE_SUITE = "suite";
    private static final String TYPE_ERROR = "error";
    private static final String TYPE_GROUP = "group";
    private static final String TYPE_PRINT = "print";
    private static final String TYPE_DONE = "done";
    private static final String TYPE_ALL_SUITES = "allSuites";
    private static final String TYPE_TEST_START = "testStart";
    private static final String TYPE_TEST_DONE = "testDone";
    private static final String DEF_GROUP = "group";
    private static final String DEF_SUITE = "suite";
    private static final String DEF_TEST = "test";
    private static final String DEF_METADATA = "metadata";
    private static final String JSON_TYPE = "type";
    private static final String JSON_NAME = "name";
    private static final String JSON_ID = "id";
    private static final String JSON_TEST_ID = "testID";
    private static final String JSON_SUITE_ID = "suiteID";
    private static final String JSON_PARENT_ID = "parentID";
    private static final String JSON_GROUP_IDS = "groupIDs";
    private static final String JSON_RESULT = "result";
    private static final String JSON_MILLIS = "time";
    private static final String JSON_COUNT = "count";
    private static final String JSON_TEST_COUNT = "testCount";
    private static final String JSON_MESSAGE = "message";
    private static final String JSON_ERROR_MESSAGE = "error";
    private static final String JSON_STACK_TRACE = "stackTrace";
    private static final String JSON_IS_FAILURE = "isFailure";
    private static final String JSON_PATH = "path";
    private static final String JSON_PLATFORM = "platform";
    private static final String JSON_LINE = "line";
    private static final String JSON_COLUMN = "column";
    private static final String JSON_URL = "url";
    private static final String RESULT_SUCCESS = "success";
    private static final String RESULT_FAILURE = "failure";
    private static final String RESULT_ERROR = "error";
    private static final String EXPECTED = "Expected: ";
    private static final Pattern EXPECTED_ACTUAL_RESULT = Pattern.compile("\\nExpected: (.*)\\n  Actual: (.*)\\n *\\^\\n Differ.*\\n");
    private static final String FILE_URL_PREFIX = "dart_location://";
    private static final String LOADING_PREFIX = "loading ";
    private static final String COMPILING_PREFIX = "compiling ";
    private static final String SET_UP_ALL_VIRTUAL_TEST_NAME = "(setUpAll)";
    private static final String TEAR_DOWN_ALL_VIRTUAL_TEST_NAME = "(tearDownAll)";
    private static final Gson GSON = new Gson();
    @NotNull
    private final DartUrlResolver myUrlResolver;
    private String myLocation;
    private Key myCurrentOutputType;
    private ServiceMessageVisitor myCurrentVisitor;
    private TIntLongHashMap myTestIdToTimestamp;
    private Map<Integer, Test> myTestData;
    private Map<Integer, Group> myGroupData;
    private Map<Integer, Suite> mySuiteData;
    private int mySuitCount;

    public DartTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull DartUrlResolver urlResolver) {
        if (testFrameworkName == null) {
            DartTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            DartTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (urlResolver == null) {
            DartTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myUrlResolver = urlResolver;
        this.myTestIdToTimestamp = new TIntLongHashMap();
        this.myTestData = new HashMap<Integer, Test>();
        this.myGroupData = new HashMap<Integer, Group>();
        this.mySuiteData = new HashMap<Integer, Suite>();
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        LOG.debug("<<< " + text.trim());
        this.myCurrentOutputType = outputType;
        this.myCurrentVisitor = visitor;
        return this.processEventText(text);
    }

    private boolean processEventText(String text) throws JsonSyntaxException, ParseException {
        JsonElement elem;
        JsonParser jp = new JsonParser();
        try {
            elem = jp.parse(text);
        }
        catch (JsonSyntaxException ex) {
            if (text.contains("\"json\" is not an allowed value for option \"reporter\"")) {
                ServiceMessageBuilder testStarted = ServiceMessageBuilder.testStarted((String)"Failed to start");
                ServiceMessageBuilder testFailed = ServiceMessageBuilder.testFailed((String)"Failed to start");
                testFailed.addAttribute(JSON_MESSAGE, "Please update your pubspec.yaml dependency on package:test to version 0.12.9 or later.");
                ServiceMessageBuilder testFinished = ServiceMessageBuilder.testFinished((String)"Failed to start");
                return this.finishMessage(testStarted, 1, 0) & this.finishMessage(testFailed, 1, 0) & this.finishMessage(testFinished, 1, 0);
            }
            return this.doProcessServiceMessages(text);
        }
        if (elem == null || !elem.isJsonObject()) {
            return false;
        }
        return this.process(elem.getAsJsonObject());
    }

    private boolean doProcessServiceMessages(@NotNull String text) throws ParseException {
        if (text == null) {
            DartTestEventsConverter.$$$reportNull$$$0(3);
        }
        LOG.debug(">>> " + text);
        return super.processServiceMessages(text, this.myCurrentOutputType, this.myCurrentVisitor);
    }

    private boolean process(JsonObject obj) throws JsonSyntaxException, ParseException {
        String type = obj.get(JSON_TYPE).getAsString();
        if (TYPE_TEST_START.equals(type)) {
            return this.handleTestStart(obj);
        }
        if (TYPE_TEST_DONE.equals(type)) {
            return this.handleTestDone(obj);
        }
        if ("error".equals(type)) {
            return this.handleError(obj);
        }
        if (TYPE_PRINT.equals(type)) {
            return this.handlePrint(obj);
        }
        if ("group".equals(type)) {
            return this.handleGroup(obj);
        }
        if ("suite".equals(type)) {
            return this.handleSuite(obj);
        }
        if (TYPE_ALL_SUITES.equals(type)) {
            return this.handleAllSuites(obj);
        }
        if (TYPE_START.equals(type)) {
            return this.handleStart(obj);
        }
        if (TYPE_DONE.equals(type)) {
            return this.handleDone(obj);
        }
        return true;
    }

    private boolean handleTestStart(JsonObject obj) throws ParseException {
        JsonObject testObj = obj.getAsJsonObject(DEF_TEST);
        Test test = this.getTest(obj);
        this.myTestIdToTimestamp.put(test.getId(), DartTestEventsConverter.getTimestamp(obj));
        if (DartTestEventsConverter.shouldTestBeHiddenIfPassed(test)) {
            String path = "";
            if (test.getName().startsWith(LOADING_PREFIX)) {
                path = test.getName().substring(LOADING_PREFIX.length());
            } else if (test.getName().startsWith(COMPILING_PREFIX)) {
                path = test.getName().substring(COMPILING_PREFIX.length());
            }
            if (path.length() > 0) {
                this.myLocation = FILE_URL_PREFIX + path;
            }
            test.myTestStartReported = false;
            return true;
        }
        ServiceMessageBuilder testStarted = ServiceMessageBuilder.testStarted((String)test.getBaseName());
        test.myTestStartReported = true;
        this.addLocationHint(testStarted, test);
        boolean result = this.finishMessage(testStarted, test.getId(), test.getValidParentId());
        Metadata metadata = Metadata.from((JsonElement)testObj.getAsJsonObject(DEF_METADATA));
        if (metadata.skip) {
            ServiceMessageBuilder message = ServiceMessageBuilder.testIgnored((String)test.getBaseName());
            if (metadata.skipReason != null) {
                message.addAttribute(JSON_MESSAGE, metadata.skipReason);
            }
            result &= this.finishMessage(message, test.getId(), test.getValidParentId());
        }
        return result;
    }

    private static boolean shouldTestBeHiddenIfPassed(@NotNull Test test) {
        Group group;
        if (test == null) {
            DartTestEventsConverter.$$$reportNull$$$0(4);
        }
        return (group = test.getParent()) == null && (test.getName().startsWith(LOADING_PREFIX) || test.getName().startsWith(COMPILING_PREFIX)) || group != null && group.getDoneTestsCount() == 0 && test.getBaseName().equals(SET_UP_ALL_VIRTUAL_TEST_NAME) || group != null && group.getDoneTestsCount() > 0 && test.getBaseName().equals(TEAR_DOWN_ALL_VIRTUAL_TEST_NAME);
    }

    private boolean handleTestDone(JsonObject obj) throws ParseException {
        Test test = this.getTest(obj);
        if (!test.myTestStartReported) {
            return true;
        }
        String result = DartTestEventsConverter.getResult(obj);
        if (!(result.equals(RESULT_SUCCESS) || result.equals(RESULT_FAILURE) || result.equals("error"))) {
            throw new ParseException("Unknown result: " + obj, 0);
        }
        test.testDone();
        ServiceMessageBuilder testFinished = ServiceMessageBuilder.testFinished((String)test.getBaseName());
        long duration = DartTestEventsConverter.getTimestamp(obj) - this.myTestIdToTimestamp.get(test.getId());
        testFinished.addAttribute("duration", Long.toString(duration));
        return this.finishMessage(testFinished, test.getId(), test.getValidParentId()) && this.checkGroupDone(test.getParent());
    }

    private boolean checkGroupDone(@Nullable Group group) throws ParseException {
        if (group != null && group.getTestCount() > 0 && group.getDoneTestsCount() == group.getTestCount()) {
            return this.processGroupDone(group) && this.checkGroupDone(group.getParent());
        }
        return true;
    }

    private boolean handleGroup(JsonObject obj) throws ParseException {
        Group group = this.getGroup(obj.getAsJsonObject("group"));
        if (group.getParent() == null && group.getTestCount() > 0) {
            ServiceMessageBuilder testCount = new ServiceMessageBuilder(JSON_TEST_COUNT).addAttribute(JSON_COUNT, String.valueOf(group.getTestCount()));
            this.doProcessServiceMessages(testCount.toString());
        }
        if (group.isArtificial()) {
            return true;
        }
        ServiceMessageBuilder groupMsg = ServiceMessageBuilder.testSuiteStarted((String)group.getBaseName());
        this.addLocationHint(groupMsg, group);
        return this.finishMessage(groupMsg, group.getId(), group.getValidParentId());
    }

    private boolean handleSuite(JsonObject obj) throws ParseException {
        Suite suite = this.getSuite(obj.getAsJsonObject("suite"));
        if (!suite.hasPath()) {
            this.mySuiteData.remove(suite.getId());
        }
        return true;
    }

    private boolean handleError(JsonObject obj) throws ParseException {
        Test test = this.getTest(obj);
        String message = DartTestEventsConverter.getErrorMessage(obj);
        boolean result = true;
        if (!test.myTestStartReported) {
            ServiceMessageBuilder testStarted = ServiceMessageBuilder.testStarted((String)test.getBaseName());
            test.myTestStartReported = true;
            result = this.finishMessage(testStarted, test.getId(), test.getValidParentId());
        }
        if (test.myTestErrorReported) {
            ServiceMessageBuilder testErrorMessage = ServiceMessageBuilder.testStdErr((String)test.getBaseName());
            testErrorMessage.addAttribute("out", DartTestEventsConverter.appendLineBreakIfNeeded(message));
            result &= this.finishMessage(testErrorMessage, test.getId(), test.getValidParentId());
        } else {
            Matcher matcher;
            ServiceMessageBuilder testError = ServiceMessageBuilder.testFailed((String)test.getBaseName());
            test.myTestErrorReported = true;
            String failureMessage = message;
            int firstExpectedIndex = message.indexOf(EXPECTED);
            if (firstExpectedIndex >= 0 && (matcher = EXPECTED_ACTUAL_RESULT.matcher(message)).find(firstExpectedIndex + EXPECTED.length())) {
                String expectedText = matcher.group(1);
                String actualText = matcher.group(2);
                testError.addAttribute("expected", expectedText);
                testError.addAttribute("actual", actualText);
                failureMessage = firstExpectedIndex == 0 ? "Comparison failed" : message.substring(0, firstExpectedIndex);
            }
            if (!DartTestEventsConverter.getBoolean(obj, JSON_IS_FAILURE)) {
                testError.addAttribute("error", "true");
            }
            testError.addAttribute(JSON_MESSAGE, DartTestEventsConverter.appendLineBreakIfNeeded(failureMessage));
            result &= this.finishMessage(testError, test.getId(), test.getValidParentId());
        }
        String stackTrace = DartTestEventsConverter.getStackTrace(obj);
        if (!StringUtil.isEmptyOrSpaces((String)stackTrace)) {
            ServiceMessageBuilder stackTraceMessage = ServiceMessageBuilder.testStdErr((String)test.getBaseName());
            stackTraceMessage.addAttribute("out", DartTestEventsConverter.appendLineBreakIfNeeded(stackTrace));
            result &= this.finishMessage(stackTraceMessage, test.getId(), test.getValidParentId());
        }
        return result;
    }

    @NotNull
    private static String appendLineBreakIfNeeded(@NotNull String message) {
        if (message == null) {
            DartTestEventsConverter.$$$reportNull$$$0(5);
        }
        String string = message.endsWith("\n") ? message : message + "\n";
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(6);
        }
        return string;
    }

    private boolean handleAllSuites(JsonObject obj) {
        JsonElement elem = obj.get(JSON_COUNT);
        if (elem == null || !elem.isJsonPrimitive()) {
            return true;
        }
        this.mySuitCount = elem.getAsInt();
        return true;
    }

    private boolean handlePrint(JsonObject obj) throws ParseException {
        Test test = this.getTest(obj);
        boolean result = true;
        if (!test.myTestStartReported) {
            if (test.getBaseName().equals(SET_UP_ALL_VIRTUAL_TEST_NAME) || test.getBaseName().equals(TEAR_DOWN_ALL_VIRTUAL_TEST_NAME)) {
                return true;
            }
            ServiceMessageBuilder testStarted = ServiceMessageBuilder.testStarted((String)test.getBaseName());
            test.myTestStartReported = true;
            result = this.finishMessage(testStarted, test.getId(), test.getValidParentId());
        }
        ServiceMessageBuilder message = ServiceMessageBuilder.testStdOut((String)test.getBaseName());
        message.addAttribute("out", DartTestEventsConverter.appendLineBreakIfNeeded(DartTestEventsConverter.getMessage(obj)));
        return result & this.finishMessage(message, test.getId(), test.getValidParentId());
    }

    private boolean handleStart(JsonObject obj) throws ParseException {
        this.myTestIdToTimestamp.clear();
        this.myTestData.clear();
        this.myGroupData.clear();
        this.mySuiteData.clear();
        this.mySuitCount = 0;
        return this.doProcessServiceMessages(new ServiceMessageBuilder("enteredTheMatrix").toString());
    }

    private boolean handleDone(JsonObject obj) throws ParseException {
        this.processAllTestsDone();
        return true;
    }

    private void processAllTestsDone() {
        for (Group group : this.myGroupData.values()) {
            if (group.getTestCount() != 0 && group.getDoneTestsCount() == group.getTestCount()) continue;
            try {
                this.processGroupDone(group);
            }
            catch (ParseException parseException) {}
        }
        this.myTestIdToTimestamp.clear();
        this.myTestData.clear();
        this.myGroupData.clear();
        this.mySuiteData.clear();
        this.mySuitCount = 0;
    }

    private boolean processGroupDone(@NotNull Group group) throws ParseException {
        if (group == null) {
            DartTestEventsConverter.$$$reportNull$$$0(7);
        }
        if (group.isArtificial()) {
            return true;
        }
        ServiceMessageBuilder groupMsg = ServiceMessageBuilder.testSuiteFinished((String)group.getBaseName());
        return this.finishMessage(groupMsg, group.getId(), group.getValidParentId());
    }

    private boolean finishMessage(@NotNull ServiceMessageBuilder msg, int testId, int parentId) throws ParseException {
        if (msg == null) {
            DartTestEventsConverter.$$$reportNull$$$0(8);
        }
        msg.addAttribute("nodeId", String.valueOf(testId));
        msg.addAttribute("parentNodeId", String.valueOf(parentId));
        return this.doProcessServiceMessages(msg.toString());
    }

    private void addLocationHint(ServiceMessageBuilder messageBuilder, Item item) {
        VirtualFile file;
        String location = "unknown";
        VirtualFile virtualFile = file = item.getUrl() == null ? null : this.myUrlResolver.findFileByDartUrl(item.getUrl());
        String loc = file != null ? FILE_URL_PREFIX + file.getPath() : (item.hasSuite() ? FILE_URL_PREFIX + item.getSuite().getPath() : this.myLocation);
        if (loc != null) {
            String nameList = GSON.toJson(item.nameList(), DartTestLocationProvider.STRING_LIST_TYPE);
            location = loc + "," + item.getLine() + "," + item.getColumn() + "," + nameList;
        }
        messageBuilder.addAttribute("locationHint", location);
    }

    private static long getTimestamp(JsonObject obj) throws ParseException {
        return DartTestEventsConverter.getLong(obj, JSON_MILLIS);
    }

    private static long getLong(JsonObject obj, String name) throws ParseException {
        JsonElement val;
        JsonElement jsonElement = val = obj == null ? null : obj.get(name);
        if (val == null || !val.isJsonPrimitive()) {
            throw new ParseException("Value is not type long: " + val, 0);
        }
        return val.getAsLong();
    }

    private static boolean getBoolean(JsonObject obj, String name) throws ParseException {
        JsonElement val;
        JsonElement jsonElement = val = obj == null ? null : obj.get(name);
        if (val == null || !val.isJsonPrimitive()) {
            throw new ParseException("Value is not type boolean: " + val, 0);
        }
        return val.getAsBoolean();
    }

    @NotNull
    private Test getTest(JsonObject obj) throws ParseException {
        Test test = this.getItem(obj, this.myTestData);
        if (test == null) {
            DartTestEventsConverter.$$$reportNull$$$0(9);
        }
        return test;
    }

    @NotNull
    private Group getGroup(JsonObject obj) throws ParseException {
        Group group = this.getItem(obj, this.myGroupData);
        if (group == null) {
            DartTestEventsConverter.$$$reportNull$$$0(10);
        }
        return group;
    }

    @NotNull
    private Suite getSuite(JsonObject obj) throws ParseException {
        Suite suite = this.getItem(obj, this.mySuiteData);
        if (suite == null) {
            DartTestEventsConverter.$$$reportNull$$$0(11);
        }
        return suite;
    }

    @NotNull
    private <T extends Item> T getItem(JsonObject obj, Map<Integer, T> items) throws ParseException {
        Item item;
        if (obj == null) {
            throw new ParseException("Unexpected null json object", 0);
        }
        JsonElement id = obj.get(JSON_ID);
        if (id != null) {
            if (items == this.myTestData) {
                Test type;
                item = type = Test.from(obj, this.myGroupData, this.mySuiteData);
            } else if (items == this.myGroupData) {
                Group group = Group.from(obj, this.myGroupData, this.mySuiteData);
                item = group;
            } else {
                Suite suite = Suite.from(obj);
                item = suite;
            }
            items.put(id.getAsInt(), item);
        } else {
            JsonElement testId = obj.get(JSON_TEST_ID);
            if (testId != null) {
                int baseId = testId.getAsInt();
                item = (Item)items.get(baseId);
            } else {
                JsonElement testObj = obj.get(DEF_TEST);
                if (testObj != null) {
                    T t = this.getItem(testObj.getAsJsonObject(), items);
                    if (t == null) {
                        DartTestEventsConverter.$$$reportNull$$$0(12);
                    }
                    return t;
                }
                throw new ParseException("No testId in json object", 0);
            }
        }
        Item item2 = item;
        if (item2 == null) {
            DartTestEventsConverter.$$$reportNull$$$0(13);
        }
        return (T)item2;
    }

    @NotNull
    private static String getErrorMessage(JsonObject obj) {
        String string = DartTestEventsConverter.nonNullJsonValue(obj, "error", "<no error message>");
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getMessage(JsonObject obj) {
        String string = DartTestEventsConverter.nonNullJsonValue(obj, JSON_MESSAGE, "<no message>");
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getStackTrace(JsonObject obj) {
        String string = DartTestEventsConverter.nonNullJsonValue(obj, JSON_STACK_TRACE, "<no stack trace>");
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getResult(JsonObject obj) {
        String string = DartTestEventsConverter.nonNullJsonValue(obj, JSON_RESULT, "<no result>");
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String nonNullJsonValue(JsonObject obj, @NotNull String id, @NotNull String def) {
        JsonElement val;
        if (id == null) {
            DartTestEventsConverter.$$$reportNull$$$0(18);
        }
        if (def == null) {
            DartTestEventsConverter.$$$reportNull$$$0(19);
        }
        JsonElement jsonElement = val = obj == null ? null : obj.get(id);
        if (val == null || !val.isJsonPrimitive()) {
            String string = def;
            if (string == null) {
                DartTestEventsConverter.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = val.getAsString();
        if (string == null) {
            DartTestEventsConverter.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = DEF_TEST;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = JSON_MESSAGE;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/test/DartTestEventsConverter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = JSON_ID;
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/test/DartTestEventsConverter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLineBreakIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTest";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuite";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "nonNullJsonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doProcessServiceMessages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldTestBeHiddenIfPassed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendLineBreakIfNeeded";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processGroupDone";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "finishMessage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "nonNullJsonValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Metadata {
        private boolean skip;
        private String skipReason;

        private Metadata() {
        }

        static Metadata from(JsonElement elem) {
            if (elem == null) {
                return new Metadata();
            }
            return (Metadata)GSON.fromJson(elem, Metadata.class);
        }
    }

    private static class Suite
    extends Item {
        static Metadata NoMetadata = new Metadata();
        static String NONE = "<none>";
        private final String myPlatform;

        static Suite from(JsonObject obj) {
            return new Suite(Suite.extractInt(obj, DartTestEventsConverter.JSON_ID), Suite.extractString(obj, DartTestEventsConverter.JSON_PATH, NONE), Suite.extractString(obj, DartTestEventsConverter.JSON_PLATFORM, NONE));
        }

        Suite(int id, String path, String platform) {
            super(id, path, null, null, NoMetadata, -1, -1, "file://" + path);
            this.myPlatform = platform;
        }

        String getPath() {
            return this.getName();
        }

        String getPlatform() {
            return this.myPlatform;
        }

        boolean hasPath() {
            return this.getPath() != NONE;
        }
    }

    private static class Group
    extends Item {
        private int myTestCount = 0;
        private int myDoneTestsCount = 0;

        static Group from(JsonObject obj, Map<Integer, Group> groups, Map<Integer, Suite> suites) {
            JsonElement parentObj = obj.get(DartTestEventsConverter.JSON_PARENT_ID);
            Group parent = null;
            if (parentObj != null && parentObj.isJsonPrimitive()) {
                int parentId = parentObj.getAsInt();
                parent = groups.get(parentId);
            }
            Suite suite = Group.lookupSuite(obj, suites);
            int line = Group.extractInt(obj, DartTestEventsConverter.JSON_LINE);
            int column = Group.extractInt(obj, DartTestEventsConverter.JSON_COLUMN);
            return new Group(Group.extractInt(obj, DartTestEventsConverter.JSON_ID), Group.extractString(obj, DartTestEventsConverter.JSON_NAME, "<no name>"), parent, suite, Group.extractMetadata(obj), Group.extractInt(obj, DartTestEventsConverter.JSON_TEST_COUNT), line < 0 ? -1 : line - 1, column < 0 ? -1 : column - 1, Group.extractString(obj, DartTestEventsConverter.JSON_URL, null));
        }

        Group(int id, String name, Group parent, Suite suite, Metadata metadata, int count, int line, int column, String url) {
            super(id, name, parent, suite, metadata, line, column, url);
            this.myTestCount = count;
        }

        int getTestCount() {
            return this.myTestCount;
        }

        public int getDoneTestsCount() {
            return this.myDoneTestsCount;
        }

        public void incDoneTestsCount() {
            ++this.myDoneTestsCount;
            if (this.getParent() != null) {
                this.getParent().incDoneTestsCount();
            }
        }
    }

    private static class Test
    extends Item {
        private boolean myTestStartReported = false;
        private boolean myTestErrorReported = false;

        static Test from(JsonObject obj, Map<Integer, Group> groups, Map<Integer, Suite> suites) {
            int[] groupIds = (int[])GSON.fromJson(obj.get(DartTestEventsConverter.JSON_GROUP_IDS), int[].class);
            Group parent = null;
            if (groupIds != null && groupIds.length > 0) {
                parent = groups.get(groupIds[groupIds.length - 1]);
            }
            Suite suite = Test.lookupSuite(obj, suites);
            int line = Test.extractInt(obj, DartTestEventsConverter.JSON_LINE);
            int column = Test.extractInt(obj, DartTestEventsConverter.JSON_COLUMN);
            return new Test(Test.extractInt(obj, DartTestEventsConverter.JSON_ID), Test.extractString(obj, DartTestEventsConverter.JSON_NAME, "<no name>"), parent, suite, Test.extractMetadata(obj), line < 0 ? -1 : line - 1, column < 0 ? -1 : column - 1, Test.extractString(obj, DartTestEventsConverter.JSON_URL, null));
        }

        Test(int id, String name, Group parent, Suite suite, Metadata metadata, int line, int column, String url) {
            super(id, name, parent, suite, metadata, line, column, url);
        }

        public void testDone() {
            if (this.getParent() != null) {
                this.getParent().incDoneTestsCount();
            }
        }
    }

    private static class Item {
        protected static final String NO_NAME = "<no name>";
        private final int myId;
        private final String myName;
        private final Group myParent;
        private final Suite mySuite;
        private final Metadata myMetadata;
        private final int myLine;
        private final int myColumn;
        private final String myUrl;

        static int extractInt(JsonObject obj, String memberName) {
            JsonElement elem = obj.get(memberName);
            if (elem == null || !elem.isJsonPrimitive()) {
                return -1;
            }
            return elem.getAsInt();
        }

        static String extractString(JsonObject obj, String memberName, String defaultResult) {
            JsonElement elem = obj.get(memberName);
            if (elem == null || elem.isJsonNull()) {
                return defaultResult;
            }
            return elem.getAsString();
        }

        static Metadata extractMetadata(JsonObject obj) {
            return Metadata.from(obj.get(DartTestEventsConverter.DEF_METADATA));
        }

        static Suite lookupSuite(JsonObject obj, Map<Integer, Suite> suites) {
            JsonElement suiteObj = obj.get(DartTestEventsConverter.JSON_SUITE_ID);
            Suite suite = null;
            if (suiteObj != null && suiteObj.isJsonPrimitive()) {
                int parentId = suiteObj.getAsInt();
                suite = suites.get(parentId);
            }
            return suite;
        }

        Item(int id, String name, Group parent, Suite suite, Metadata metadata, int line, int column, String url) {
            this.myId = id;
            this.myName = name;
            this.myParent = parent;
            this.mySuite = suite;
            this.myMetadata = metadata;
            this.myLine = line;
            this.myColumn = column;
            this.myUrl = url;
        }

        int getId() {
            return this.myId;
        }

        String getName() {
            return this.myName;
        }

        String getBaseName() {
            String parentName;
            if (this instanceof Test && this.getParent() == null) {
                if (this.myName.startsWith(DartTestEventsConverter.LOADING_PREFIX)) {
                    return DartTestEventsConverter.LOADING_PREFIX + PathUtil.getFileName((String)this.myName.substring(DartTestEventsConverter.LOADING_PREFIX.length()));
                }
                if (this.myName.startsWith(DartTestEventsConverter.COMPILING_PREFIX)) {
                    return DartTestEventsConverter.COMPILING_PREFIX + PathUtil.getFileName((String)this.myName.substring(DartTestEventsConverter.COMPILING_PREFIX.length()));
                }
                return this.myName;
            }
            if (this instanceof Group && NO_NAME.equals(this.myName) && this.myParent == null && this.hasSuite()) {
                return PathUtil.getFileName((String)this.getSuite().getPath());
            }
            if (this instanceof Group && this.myParent != null && this.myParent.getParent() == null && NO_NAME.equals(this.myParent.getName())) {
                return this.myName;
            }
            if (this.hasValidParent() && this.myName.startsWith((parentName = this.getParent().getName()) + " ")) {
                return this.myName.substring(parentName.length() + 1);
            }
            return this.myName;
        }

        boolean hasSuite() {
            return this.mySuite != null && this.mySuite.hasPath();
        }

        Suite getSuite() {
            return this.mySuite;
        }

        Group getParent() {
            return this.myParent;
        }

        Metadata getMetadata() {
            return this.myMetadata;
        }

        boolean isArtificial() {
            return NO_NAME.equals(this.myName) && this.myParent == null && !this.hasSuite();
        }

        boolean hasValidParent() {
            return this.myParent != null && !this.myParent.isArtificial();
        }

        int getValidParentId() {
            if (this.hasValidParent()) {
                return this.getParent().getId();
            }
            return 0;
        }

        List<String> nameList() {
            ArrayList<String> names = new ArrayList<String>();
            this.addNames(names);
            return names;
        }

        void addNames(List<String> names) {
            if (this instanceof Group && NO_NAME.equals(this.myName) && this.myParent == null) {
                return;
            }
            if (this.myParent != null) {
                this.myParent.addNames(names);
            }
            names.add(StringUtil.escapeStringCharacters((String)this.getBaseName()));
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }

        public String getUrl() {
            return this.myUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + String.valueOf(this.myId) + "," + String.valueOf(this.myName) + ")";
        }
    }
}

