/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLongTemplateEntry;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.IDartBlock;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dartlang.vm.service.element.Frame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceEvaluator
extends XDebuggerEvaluator {
    private static final Pattern ERROR_PATTERN = Pattern.compile("Error:.* line \\d+ pos \\d+: (.+)");
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final Frame myFrame;

    public DartVmServiceEvaluator(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull Frame vmFrame) {
        if (debugProcess == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(0);
        }
        if (isolateId == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(1);
        }
        if (vmFrame == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(2);
        }
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myFrame = vmFrame;
    }

    @NotNull
    public static String getPresentableError(@NotNull String rawError) {
        List lines;
        if (rawError == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(3);
        }
        if (!(lines = StringUtil.split((String)StringUtil.convertLineSeparators((String)rawError), (String)"\n")).isEmpty()) {
            if ((((String)lines.get(0)).equals("Error: Unhandled exception:") || ((String)lines.get(0)).equals("Unhandled exception:")) && lines.size() > 1) {
                String string = (String)lines.get(1);
                if (string == null) {
                    DartVmServiceEvaluator.$$$reportNull$$$0(4);
                }
                return string;
            }
            Matcher matcher = ERROR_PATTERN.matcher((CharSequence)lines.get(0));
            if (matcher.find()) {
                String string = matcher.group(1);
                if (string == null) {
                    DartVmServiceEvaluator.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ("Cannot evaluate" == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(6);
        }
        return "Cannot evaluate";
    }

    @Nullable
    public static ExpressionInfo getExpressionInfo(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(7);
        }
        DartReference reference = null;
        PsiElement element = contextElement;
        do {
            if (!(element instanceof DartReference)) continue;
            reference = (DartReference)element;
        } while ((element = element.getParent()) != null && !(element instanceof DartArgumentList) && !(element instanceof DartLongTemplateEntry) && !(element instanceof DartCallExpression) && !(element instanceof DartFunctionBody) && !(element instanceof IDartBlock));
        if (reference != null) {
            TextRange textRange = reference.getTextRange();
            int endOffset = contextElement.getTextRange().getEndOffset();
            if (textRange.getEndOffset() != endOffset) {
                textRange = new TextRange(textRange.getStartOffset(), endOffset);
            }
            return new ExpressionInfo(textRange);
        }
        PsiElement parent = contextElement.getParent();
        return parent instanceof DartId ? new ExpressionInfo(parent.getTextRange()) : null;
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(9);
        }
        this.myDebugProcess.getVmServiceWrapper().evaluateInFrame(this.myIsolateId, this.myFrame, expression, callback);
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        PsiFile psiFile;
        if (project == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(10);
        }
        if (document == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(11);
        }
        PsiElement contextElement = (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null ? null : psiFile.findElementAt(offset);
        return contextElement == null ? null : DartVmServiceEvaluator.getExpressionInfo(contextElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmFrame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawError";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableError";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

