/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.vm.service.element.Breakpoint;
import org.jetbrains.annotations.NotNull;

class IsolateBreakpointInfo {
    private final String myIsolateId;
    private final DartVmServiceDebugProcess myDebugProcess;
    private final List<String> myTemporaryVmBreakpointIds;
    private final Map<XLineBreakpoint<XBreakpointProperties>, Set<String>> myXBreakpointToVmBreakpointIdsMap;

    IsolateBreakpointInfo(@NotNull String isolateId, @NotNull DartVmServiceDebugProcess debugProcess) {
        if (isolateId == null) {
            IsolateBreakpointInfo.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            IsolateBreakpointInfo.$$$reportNull$$$0(1);
        }
        this.myTemporaryVmBreakpointIds = new ArrayList<String>();
        this.myXBreakpointToVmBreakpointIdsMap = new THashMap();
        this.myIsolateId = isolateId;
        this.myDebugProcess = debugProcess;
    }

    public void removeTemporaryBreakpoints() {
        for (String breakpointId : this.myTemporaryVmBreakpointIds) {
            this.myDebugProcess.getVmServiceWrapper().removeBreakpoint(this.myIsolateId, breakpointId);
        }
        this.myTemporaryVmBreakpointIds.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> removeAllVmBreakpoints() {
        if (!this.myDebugProcess.isIsolateAlive(this.myIsolateId)) {
            return new HashSet<String>();
        }
        HashSet<String> allVmBreakpoints = new HashSet<String>();
        Map<XLineBreakpoint<XBreakpointProperties>, Set<String>> map = this.myXBreakpointToVmBreakpointIdsMap;
        synchronized (map) {
            for (Set<String> bps : this.myXBreakpointToVmBreakpointIdsMap.values()) {
                allVmBreakpoints.addAll(bps);
            }
            this.myXBreakpointToVmBreakpointIdsMap.clear();
        }
        for (String vmBreakpointId : allVmBreakpoints) {
            this.myDebugProcess.getVmServiceWrapper().removeBreakpoint(this.myIsolateId, vmBreakpointId);
        }
        return allVmBreakpoints;
    }

    public void temporaryVmBreakpointAdded(String vmBreakpointId) {
        this.myTemporaryVmBreakpointIds.add(vmBreakpointId);
    }

    public void vmBreakpointAdded(XLineBreakpoint<XBreakpointProperties> xBreakpoint, Breakpoint vmBreakpoint) {
        this.getVmBreakpoints(xBreakpoint).add(vmBreakpoint.getId());
    }

    public void unregisterBreakpoint(XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        if (this.myDebugProcess.isIsolateAlive(this.myIsolateId)) {
            for (String vmBreakpointId : this.getVmBreakpoints(xBreakpoint)) {
                this.myDebugProcess.getVmServiceWrapper().removeBreakpoint(this.myIsolateId, vmBreakpointId);
            }
        }
        this.myXBreakpointToVmBreakpointIdsMap.remove(xBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getVmBreakpoints(XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        Map<XLineBreakpoint<XBreakpointProperties>, Set<String>> map = this.myXBreakpointToVmBreakpointIdsMap;
        synchronized (map) {
            Set<String> vmBreakpoints = this.myXBreakpointToVmBreakpointIdsMap.get(xBreakpoint);
            if (vmBreakpoints == null) {
                vmBreakpoints = new HashSet<String>();
                this.myXBreakpointToVmBreakpointIdsMap.put(xBreakpoint, vmBreakpoints);
            }
            return vmBreakpoints;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "isolateId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolateBreakpointInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

