/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.runner.actions.DartPopFrameAction;
import com.jetbrains.lang.dart.ide.runner.base.DartDebuggerEditorsProvider;
import com.jetbrains.lang.dart.ide.runner.server.OpenDartObservatoryUrlAction;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartExceptionBreakpointHandler;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceBreakpointHandler;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceListener;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolatesInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceWrapper;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceStackFrame;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceSuspendContext;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceDebugProcess
extends XDebugProcess {
    private static final Logger LOG = Logger.getInstance((String)DartVmServiceDebugProcess.class.getName());
    @Nullable
    private final ExecutionResult myExecutionResult;
    @NotNull
    private final DartUrlResolver myDartUrlResolver;
    @NotNull
    private final String myDebuggingHost;
    private final int myObservatoryPort;
    private boolean myVmConnected;
    @NotNull
    private final XBreakpointHandler[] myBreakpointHandlers;
    private final IsolatesInfo myIsolatesInfo;
    private VmServiceWrapper myVmServiceWrapper;
    @NotNull
    private final Set<String> mySuspendedIsolateIds;
    private String myLatestCurrentIsolateId;
    private final Map<String, LightVirtualFile> myScriptIdToContentMap;
    private final Map<String, TIntObjectHashMap<Pair<Integer, Integer>>> myScriptIdToLinesAndColumnsMap;
    @Nullable
    private final String myDASExecutionContextId;
    private final boolean myRemoteDebug;
    private final int myTimeout;
    @Nullable
    private final VirtualFile myCurrentWorkingDirectory;
    @Nullable
    protected String myRemoteProjectRootUri;
    @NotNull
    private final OpenDartObservatoryUrlAction myOpenObservatoryAction;

    public DartVmServiceDebugProcess(@NotNull XDebugSession session, @NotNull String debuggingHost, int observatoryPort, @Nullable ExecutionResult executionResult, @NotNull DartUrlResolver dartUrlResolver, @Nullable String dasExecutionContextId, boolean remoteDebug, int timeout, @Nullable VirtualFile currentWorkingDirectory) {
        if (session == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(0);
        }
        if (debuggingHost == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(1);
        }
        if (dartUrlResolver == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(2);
        }
        super(session);
        this.myVmConnected = false;
        this.mySuspendedIsolateIds = Collections.synchronizedSet(new THashSet());
        this.myScriptIdToContentMap = new THashMap();
        this.myScriptIdToLinesAndColumnsMap = new THashMap();
        this.myOpenObservatoryAction = new OpenDartObservatoryUrlAction(null, (Computable<Boolean>)((Computable)() -> this.myVmConnected && !this.getSession().isStopped()));
        this.myDebuggingHost = debuggingHost;
        this.myObservatoryPort = observatoryPort;
        this.myExecutionResult = executionResult;
        this.myDartUrlResolver = dartUrlResolver;
        this.myRemoteDebug = remoteDebug;
        this.myTimeout = timeout;
        this.myCurrentWorkingDirectory = currentWorkingDirectory;
        this.myIsolatesInfo = new IsolatesInfo();
        this.myBreakpointHandlers = new XBreakpointHandler[]{new DartVmServiceBreakpointHandler(this), new DartExceptionBreakpointHandler(this)};
        this.setLogger();
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.stackFrameChanged();
            }

            public void stackFrameChanged() {
                XStackFrame stackFrame = DartVmServiceDebugProcess.this.getSession().getCurrentStackFrame();
                DartVmServiceDebugProcess.this.myLatestCurrentIsolateId = stackFrame instanceof DartVmServiceStackFrame ? ((DartVmServiceStackFrame)stackFrame).getIsolateId() : null;
            }
        });
        this.myDASExecutionContextId = dasExecutionContextId;
        if (remoteDebug) {
            this.scheduleConnect(this.getObservatoryUrl("ws", "/ws"));
        } else {
            this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    String prefix = "Observatory listening on http://";
                    if (event.getText().startsWith("Observatory listening on http://")) {
                        DartVmServiceDebugProcess.this.getProcessHandler().removeProcessListener((ProcessListener)this);
                        String urlBase = event.getText().substring("Observatory listening on http://".length());
                        DartVmServiceDebugProcess.this.scheduleConnect("ws://" + StringUtil.trimTrailing((String)urlBase.trim(), (char)'/') + "/ws");
                        DartVmServiceDebugProcess.this.myOpenObservatoryAction.setUrl("http://" + urlBase);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess$2";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (remoteDebug) {
            LOG.assertTrue(this.myExecutionResult == null && this.myDASExecutionContextId == null, (Object)(this.myDASExecutionContextId + this.myExecutionResult));
        } else {
            LOG.assertTrue(this.myExecutionResult != null && this.myDASExecutionContextId != null, (Object)(this.myDASExecutionContextId + this.myExecutionResult));
        }
    }

    public VmServiceWrapper getVmServiceWrapper() {
        return this.myVmServiceWrapper;
    }

    public Collection<IsolatesInfo.IsolateInfo> getIsolateInfos() {
        return this.myIsolatesInfo.getIsolateInfos();
    }

    private void setLogger() {
        Logging.setLogger(new org.dartlang.vm.service.logging.Logger(){

            @Override
            public void logError(String message) {
                if (message.contains("\"code\":102,")) {
                    return;
                }
                if (message.contains("\"method\":\"removeBreakpoint\"")) {
                    return;
                }
                DartVmServiceDebugProcess.this.getSession().getConsoleView().print("Error: " + message + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                LOG.error(message);
            }

            @Override
            public void logError(String message, Throwable exception) {
                DartVmServiceDebugProcess.this.getSession().getConsoleView().print("Error: " + message + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                LOG.error(message, exception);
            }

            @Override
            public void logInformation(String message) {
                if (message.length() > 500) {
                    message = message.substring(0, 300) + "..." + message.substring(message.length() - 200);
                }
                LOG.debug(message);
            }

            @Override
            public void logInformation(String message, Throwable exception) {
                LOG.debug(message, exception);
            }
        });
    }

    protected void scheduleConnect(@NotNull String url) {
        if (url == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (url == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(36);
            }
            long timeout = this.myTimeout;
            long startTime = System.currentTimeMillis();
            try {
                while (true) {
                    try {
                        this.connect(url);
                    }
                    catch (IOException e) {
                        if (System.currentTimeMillis() > startTime + timeout) {
                            throw e;
                        }
                        TimeoutUtil.sleep((long)50L);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                String message = "Failed to connect to the VM observatory service: " + e.toString() + "\n";
                Throwable cause = e.getCause();
                while (cause != null) {
                    message = message + "Caused by: " + cause.toString() + "\n";
                    Throwable cause1 = cause.getCause();
                    if (cause1 == cause) continue;
                    cause = cause1;
                }
                this.getSession().getConsoleView().print(message, ConsoleViewContentType.ERROR_OUTPUT);
                this.getSession().stop();
            }
        });
    }

    private void connect(@NotNull String url) throws IOException {
        if (url == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(4);
        }
        VmService vmService = VmService.connect(url);
        DartVmServiceListener vmServiceListener = new DartVmServiceListener(this, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        vmService.addVmServiceListener(vmServiceListener);
        this.myVmServiceWrapper = new VmServiceWrapper(this, vmService, vmServiceListener, this.myIsolatesInfo, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        this.myVmServiceWrapper.handleDebuggerConnected();
        this.myVmConnected = true;
    }

    @Deprecated
    @NotNull
    private String getObservatoryUrl(@NotNull String scheme, @Nullable String path) {
        if (scheme == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(5);
        }
        String string = scheme + "://" + this.myDebuggingHost + ":" + this.myObservatoryPort + StringUtil.notNullize((String)path);
        if (string == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myExecutionResult == null ? super.doGetProcessHandler() : this.myExecutionResult.getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionResult == null ? super.createConsole() : this.myExecutionResult.getExecutionConsole();
        if (executionConsole == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(7);
        }
        return executionConsole;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        DartDebuggerEditorsProvider dartDebuggerEditorsProvider = new DartDebuggerEditorsProvider();
        if (dartDebuggerEditorsProvider == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(8);
        }
        return dartDebuggerEditorsProvider;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(9);
        }
        return this.myBreakpointHandlers;
    }

    public boolean isRemoteDebug() {
        return this.myRemoteDebug;
    }

    public void guessRemoteProjectRoot(@NotNull ElementList<LibraryRef> libraries) {
        VirtualFile pubspec;
        VirtualFile projectRoot;
        if (libraries == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(10);
        }
        VirtualFile virtualFile = projectRoot = (pubspec = this.myDartUrlResolver.getPubspecYamlFile()) != null ? pubspec.getParent() : this.myCurrentWorkingDirectory;
        if (projectRoot == null) {
            return;
        }
        for (LibraryRef library : libraries) {
            String remoteUri = library.getUri();
            if (remoteUri.startsWith("dart:") || remoteUri.startsWith("package:")) continue;
            PsiFile[] localFilesWithSameName = (PsiFile[])ReadAction.compute(() -> {
                String remoteFileName = PathUtil.getFileName((String)remoteUri);
                GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)this.getSession().getProject(), (VirtualFile)projectRoot, (boolean)true);
                return FilenameIndex.getFilesByName((Project)this.getSession().getProject(), (String)remoteFileName, (GlobalSearchScope)scope);
            });
            int howManyFilesMatch = 0;
            for (PsiFile psiFile : localFilesWithSameName) {
                VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
                if (file == null) continue;
                LOG.assertTrue(file.getPath().startsWith(projectRoot.getPath() + "/"), (Object)(file.getPath() + "," + projectRoot.getPath()));
                String relPath = file.getPath().substring(projectRoot.getPath().length());
                if (!remoteUri.endsWith(relPath)) continue;
                ++howManyFilesMatch;
                this.myRemoteProjectRootUri = remoteUri.substring(0, remoteUri.length() - relPath.length());
            }
            if (howManyFilesMatch != true) continue;
            break;
        }
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            DartVmServiceSuspendContext suspendContext = (DartVmServiceSuspendContext)context;
            StepOption stepOption = suspendContext != null && suspendContext.getAtAsyncSuspension() ? StepOption.OverAsyncSuspension : StepOption.Over;
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, stepOption);
        }
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Into);
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Out);
        }
    }

    public void dropFrame(DartVmServiceStackFrame frame) {
        this.myVmServiceWrapper.dropFrame(frame.getIsolateId(), frame.getFrameIndex() + 1);
    }

    public void stop() {
        this.myVmConnected = false;
        if (this.myVmServiceWrapper != null) {
            if (this.myDASExecutionContextId != null) {
                DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_deleteContext(this.myDASExecutionContextId);
            }
            Disposer.dispose((Disposable)this.myVmServiceWrapper);
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        for (String isolateId : new ArrayList<String>(this.mySuspendedIsolateIds)) {
            this.myVmServiceWrapper.resumeIsolate(isolateId, null);
        }
    }

    public void startPausing() {
        for (IsolatesInfo.IsolateInfo info : this.getIsolateInfos()) {
            if (this.mySuspendedIsolateIds.contains(info.getIsolateId())) continue;
            this.myVmServiceWrapper.pauseIsolate(info.getIsolateId());
        }
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(11);
        }
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.addTemporaryBreakpoint(position, this.myLatestCurrentIsolateId);
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, null);
        }
    }

    public void isolateSuspended(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(12);
        }
        this.mySuspendedIsolateIds.add(isolateRef.getId());
    }

    public boolean isIsolateSuspended(@NotNull String isolateId) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(13);
        }
        return this.mySuspendedIsolateIds.contains(isolateId);
    }

    public boolean isIsolateAlive(@NotNull String isolateId) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(14);
        }
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            if (!isolateId.equals(isolateInfo.getIsolateId())) continue;
            return true;
        }
        return false;
    }

    public void isolateResumed(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(15);
        }
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
    }

    public void isolateExit(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(16);
        }
        this.myIsolatesInfo.deleteIsolate(isolateRef);
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
        if (isolateRef.getId().equals(this.myLatestCurrentIsolateId)) {
            this.resume(this.getSession().getSuspendContext());
        }
    }

    public void handleWriteEvent(String base64Data) {
        String message = new String(Base64.getDecoder().decode(base64Data), Charsets.UTF_8);
        this.getSession().getConsoleView().print(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public String getCurrentStateMessage() {
        return this.getSession().isStopped() ? XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]) : (this.myVmConnected ? XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]) : DartBundle.message("debugger.trying.to.connect.vm.at.0", this.getObservatoryUrl("ws", "/ws")));
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(17);
        }
        if (topToolbar == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(19);
        }
        topToolbar.addSeparator();
        topToolbar.addAction((AnAction)this.myOpenObservatoryAction);
        topToolbar.addAction((AnAction)new DartPopFrameAction());
    }

    @NotNull
    public Collection<String> getUrisForFile(@NotNull VirtualFile file) {
        String uriByServer;
        if (file == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(20);
        }
        HashSet result = new HashSet();
        String uriByIde = this.myDartUrlResolver.getDartUrlForFile(file);
        if (uriByIde.startsWith("dart:")) {
            result.add(uriByIde);
            HashSet hashSet = result;
            if (hashSet == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(21);
            }
            return hashSet;
        }
        if (uriByIde.startsWith("file:")) {
            result.add(DartVmServiceDebugProcess.threeSlashize(uriByIde));
        } else {
            result.add(uriByIde);
            result.add(DartVmServiceDebugProcess.threeSlashize(new File(file.getPath()).toURI().toString()));
        }
        result.add(file.getPath());
        if (this.myDASExecutionContextId != null && (uriByServer = DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_mapUri(this.myDASExecutionContextId, file.getPath(), null)) != null) {
            result.add(uriByServer);
        }
        if (this.myRemoteProjectRootUri != null) {
            VirtualFile pubspec = this.myDartUrlResolver.getPubspecYamlFile();
            if (pubspec != null) {
                String projectPath = pubspec.getParent().getPath();
                String filePath = file.getPath();
                if (filePath.startsWith(projectPath)) {
                    result.add(this.myRemoteProjectRootUri + filePath.substring(projectPath.length()));
                }
            } else if (this.myCurrentWorkingDirectory != null) {
                String projectPath = this.myCurrentWorkingDirectory.getPath();
                String filePath = file.getPath();
                if (filePath.startsWith(projectPath)) {
                    result.add(this.myRemoteProjectRootUri + filePath.substring(projectPath.length()));
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull ScriptRef scriptRef, int tokenPos) {
        Pair lineAndColumn;
        VirtualFile file;
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(23);
        }
        if (scriptRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(24);
        }
        if ((file = (VirtualFile)ReadAction.compute(() -> {
            String path;
            if (scriptRef == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(35);
            }
            String uri = scriptRef.getUri();
            if (this.myDASExecutionContextId != null && !DartVmServiceDebugProcess.isDartPatchUri(uri) && (path = DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_mapUri(this.myDASExecutionContextId, null, uri)) != null) {
                return LocalFileSystem.getInstance().findFileByPath(path);
            }
            VirtualFile pubspec = this.myDartUrlResolver.getPubspecYamlFile();
            if (this.myRemoteProjectRootUri != null && uri.startsWith(this.myRemoteProjectRootUri) && pubspec != null) {
                String localRootUri = StringUtil.trimEnd((String)this.myDartUrlResolver.getDartUrlForFile(pubspec.getParent()), (char)'/');
                LOG.assertTrue(localRootUri.startsWith("file:"), (Object)localRootUri);
                uri = localRootUri + uri.substring(this.myRemoteProjectRootUri.length());
            }
            return this.myDartUrlResolver.findFileByDartUrl(uri);
        })) == null) {
            file = (VirtualFile)this.myScriptIdToContentMap.get(scriptRef.getId());
        }
        TIntObjectHashMap<Pair<Integer, Integer>> tokenPosToLineAndColumn = this.myScriptIdToLinesAndColumnsMap.get(scriptRef.getId());
        if (file != null && tokenPosToLineAndColumn != null) {
            Pair lineAndColumn2 = (Pair)tokenPosToLineAndColumn.get(tokenPos);
            if (lineAndColumn2 == null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(file, 0);
            }
            return XDebuggerUtil.getInstance().createPosition(file, ((Integer)lineAndColumn2.first).intValue(), ((Integer)lineAndColumn2.second).intValue());
        }
        Script script = this.myVmServiceWrapper.getScriptSync(isolateId, scriptRef.getId());
        if (script == null) {
            return null;
        }
        if (file == null) {
            file = new LightVirtualFile(PathUtil.getFileName((String)script.getUri()), (FileType)DartFileType.INSTANCE, (CharSequence)script.getSource());
            ((LightVirtualFile)file).setWritable(false);
            this.myScriptIdToContentMap.put(scriptRef.getId(), (LightVirtualFile)file);
        }
        if (tokenPosToLineAndColumn == null) {
            tokenPosToLineAndColumn = DartVmServiceDebugProcess.createTokenPosToLineAndColumnMap(script.getTokenPosTable());
            this.myScriptIdToLinesAndColumnsMap.put(scriptRef.getId(), tokenPosToLineAndColumn);
        }
        if ((lineAndColumn = (Pair)tokenPosToLineAndColumn.get(tokenPos)) == null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(file, 0);
        }
        return XDebuggerUtil.getInstance().createPosition(file, ((Integer)lineAndColumn.first).intValue(), ((Integer)lineAndColumn.second).intValue());
    }

    private static boolean isDartPatchUri(@NotNull String uri) {
        if (uri == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(25);
        }
        return uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/");
    }

    @NotNull
    private static TIntObjectHashMap<Pair<Integer, Integer>> createTokenPosToLineAndColumnMap(@NotNull List<List<Integer>> tokenPosTable) {
        if (tokenPosTable == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(26);
        }
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (List<Integer> lineAndPairs : tokenPosTable) {
            Iterator<Integer> iterator = lineAndPairs.iterator();
            int line = Math.max(0, iterator.next() - 1);
            while (iterator.hasNext()) {
                int tokenPos = iterator.next();
                int column = Math.max(0, iterator.next() - 1);
                result.put(tokenPos, (Object)Pair.create((Object)line, (Object)column));
            }
        }
        TIntObjectHashMap tIntObjectHashMap = result;
        if (tIntObjectHashMap == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(27);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static String threeSlashize(@NotNull String uri) {
        if (uri == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(28);
        }
        if (!uri.startsWith("file:")) {
            String string = uri;
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(29);
            }
            return string;
        }
        if (uri.startsWith("file:///")) {
            String string = uri;
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(30);
            }
            return string;
        }
        if (uri.startsWith("file://")) {
            String string = "file:///" + uri.substring("file://".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(31);
            }
            return string;
        }
        if (uri.startsWith("file:/")) {
            String string = "file:///" + uri.substring("file:/".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (uri.startsWith("file:")) {
            String string = "file:///" + uri.substring("file:".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = uri;
        if (string == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggingHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartUrlResolver";
                break;
            }
            case 3: 
            case 4: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
            case 13: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRef";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenPosTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservatoryUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrisForFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenPosToLineAndColumnMap";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "threeSlashize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleConnect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getObservatoryUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessRemoteProjectRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isolateSuspended";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIsolateSuspended";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isIsolateAlive";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isolateResumed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isolateExit";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUrisForFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDartPatchUri";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createTokenPosToLineAndColumnMap";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "threeSlashize";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSourcePosition$3";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleConnect$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

