/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.lang.dart.ide.runner.DartLineBreakpointType;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolateBreakpointInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceWrapper;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.dartlang.vm.service.element.Breakpoint;
import org.jetbrains.annotations.NotNull;

public class DartVmServiceBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    private final DartVmServiceDebugProcess myDebugProcess;
    private final Set<XLineBreakpoint<XBreakpointProperties>> myXBreakpoints;
    private final Map<String, IsolateBreakpointInfo> myIsolateInfo;
    private final Map<String, XLineBreakpoint<XBreakpointProperties>> myVmBreakpointIdToXBreakpointMap;

    public DartVmServiceBreakpointHandler(@NotNull DartVmServiceDebugProcess debugProcess) {
        if (debugProcess == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(DartLineBreakpointType.class);
        this.myXBreakpoints = new THashSet();
        this.myIsolateInfo = new THashMap();
        this.myVmBreakpointIdToXBreakpointMap = new THashMap();
        this.myDebugProcess = debugProcess;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        if (xBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(1);
        }
        this.myXBreakpoints.add(xBreakpoint);
        VmServiceWrapper vmServiceWrapper = this.myDebugProcess.getVmServiceWrapper();
        if (vmServiceWrapper != null) {
            vmServiceWrapper.addBreakpointForIsolates(xBreakpoint, this.myDebugProcess.getIsolateInfos());
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, boolean temporary) {
        if (xBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(2);
        }
        this.myXBreakpoints.remove(xBreakpoint);
        for (IsolateBreakpointInfo info : this.myIsolateInfo.values()) {
            info.unregisterBreakpoint(xBreakpoint);
        }
    }

    public Set<XLineBreakpoint<XBreakpointProperties>> getXBreakpoints() {
        return this.myXBreakpoints;
    }

    public void vmBreakpointAdded(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, @NotNull String isolateId, @NotNull Breakpoint vmBreakpoint) {
        if (xBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(3);
        }
        if (isolateId == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(4);
        }
        if (vmBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(5);
        }
        this.myVmBreakpointIdToXBreakpointMap.put(vmBreakpoint.getId(), xBreakpoint);
        IsolateBreakpointInfo info = this.getIsolateInfo(isolateId);
        info.vmBreakpointAdded(xBreakpoint, vmBreakpoint);
        if (vmBreakpoint.getResolved()) {
            this.breakpointResolved(vmBreakpoint);
        }
    }

    public void temporaryBreakpointAdded(String isolateId, Breakpoint vmBreakpoint) {
        this.getIsolateInfo(isolateId).temporaryVmBreakpointAdded(vmBreakpoint.getId());
    }

    public void removeTemporaryBreakpoints(String isolateId) {
        this.getIsolateInfo(isolateId).removeTemporaryBreakpoints();
    }

    public void removeAllVmBreakpoints(@NotNull String isolateId) {
        if (isolateId == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(6);
        }
        Set<String> vmBreakpoints = this.getIsolateInfo(isolateId).removeAllVmBreakpoints();
        for (String vmBreakpointId : vmBreakpoints) {
            this.myVmBreakpointIdToXBreakpointMap.remove(vmBreakpointId);
        }
    }

    private IsolateBreakpointInfo getIsolateInfo(String isolateId) {
        IsolateBreakpointInfo info = this.myIsolateInfo.get(isolateId);
        if (info == null) {
            info = new IsolateBreakpointInfo(isolateId, this.myDebugProcess);
            this.myIsolateInfo.put(isolateId, info);
        }
        return info;
    }

    public void breakpointResolved(@NotNull Breakpoint vmBreakpoint) {
        XLineBreakpoint<XBreakpointProperties> xBreakpoint;
        if (vmBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(7);
        }
        if ((xBreakpoint = this.myVmBreakpointIdToXBreakpointMap.get(vmBreakpoint.getId())) != null) {
            this.myDebugProcess.getSession().updateBreakpointPresentation(xBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    public void breakpointFailed(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        if (xBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(8);
        }
        this.myDebugProcess.getSession().updateBreakpointPresentation(xBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, null);
    }

    public XLineBreakpoint<XBreakpointProperties> getXBreakpoint(@NotNull Breakpoint vmBreakpoint) {
        if (vmBreakpoint == null) {
            DartVmServiceBreakpointHandler.$$$reportNull$$$0(9);
        }
        return this.myVmBreakpointIdToXBreakpointMap.get(vmBreakpoint.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmBreakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "vmBreakpointAdded";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllVmBreakpoints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "breakpointResolved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "breakpointFailed";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getXBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

