/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugParameters;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRemoteDebugConfigurationEditor
extends SettingsEditor<DartRemoteDebugConfiguration> {
    private JPanel myMainPanel;
    private JTextArea myVMArgsArea;
    private FixedSizeButton myCopyButton;
    private JTextField myHostField;
    private PortField myPortField;
    private ComboboxWithBrowseButton myDartProjectCombo;
    @Nullable
    private final DartSdk mySdk;
    private SortedSet<NameAndPath> myComboItems;

    public DartRemoteDebugConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myComboItems = new TreeSet<NameAndPath>();
        this.mySdk = DartSdk.getDartSdk(project);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DartRemoteDebugConfigurationEditor.this.updateVmArgs();
            }
        });
        this.myPortField.addChangeListener(e -> this.updateVmArgs());
        this.initCopyToClipboardActions();
        this.initDartProjectsCombo(project);
    }

    public void initCopyToClipboardActions() {
        final DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction("Copy"){
            {
                this.copyFrom(ActionManager.getInstance().getAction("$Copy"));
            }

            public void actionPerformed(AnActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(DartRemoteDebugConfigurationEditor.this.myVMArgsArea.getText().trim()));
            }
        });
        this.myVMArgsArea.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(comp, x, y);
            }
        });
        this.myCopyButton.setSize(22);
        this.myCopyButton.setIcon(PlatformIcons.COPY_ICON);
        this.myCopyButton.addActionListener(e -> CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.myVMArgsArea.getText().trim())));
    }

    private void initDartProjectsCombo(@NotNull Project project) {
        if (project == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.myDartProjectCombo.getComboBox().setRenderer(new ListCellRendererWrapper<NameAndPath>(){

            public void customize(JList list, NameAndPath value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getPresentableText());
                }
            }
        });
        for (VirtualFile pubspecFile : FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            this.myComboItems.add(new NameAndPath(PubspecYamlUtil.getDartProjectName(pubspecFile), pubspecFile.getParent().getPath()));
        }
        if (this.myComboItems.isEmpty()) {
            for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                if (!FileTypeIndex.containsFileOfType((FileType)DartFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)contentRoot, (boolean)true))) continue;
                this.myComboItems.add(new NameAndPath(null, contentRoot.getPath()));
            }
        }
        this.myDartProjectCombo.getComboBox().setModel(new DefaultComboBoxModel<Object>(this.myComboItems.toArray()));
        this.myDartProjectCombo.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox combo) {
                Object item = combo.getSelectedItem();
                return item instanceof NameAndPath ? ((NameAndPath)item).myPath : "";
            }

            public void setText(JComboBox combo, @NotNull String path) {
                if (path == null) {
                    5.$$$reportNull$$$0(0);
                }
                DartRemoteDebugConfigurationEditor.this.setSelectedProjectPath(FileUtil.toSystemIndependentName((String)path));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/ide/runner/server/ui/DartRemoteDebugConfigurationEditor$5", "setText"));
            }
        });
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void updateVmArgs() {
        String host = this.myHostField.getText().trim();
        boolean localhost = "localhost".equals(host) || "127.0.0.1".equals(host);
        this.myVMArgsArea.setText("--enable-vm-service:" + this.myPortField.getNumber() + (localhost ? "" : "/0.0.0.0") + " --pause_isolates_on_start");
    }

    protected void resetEditorFrom(@NotNull DartRemoteDebugConfiguration config) {
        if (config == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(3);
        }
        DartRemoteDebugParameters params = config.getParameters();
        this.myHostField.setText(params.getHost());
        this.myPortField.setNumber(params.getPort());
        this.setSelectedProjectPath(params.getDartProjectPath());
        this.updateVmArgs();
    }

    private void setSelectedProjectPath(@NotNull String projectPath) {
        if (projectPath == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (projectPath.isEmpty()) {
            return;
        }
        VirtualFile pubspecFile = LocalFileSystem.getInstance().findFileByPath(projectPath + "/" + "pubspec.yaml");
        String projectName = pubspecFile == null ? null : PubspecYamlUtil.getDartProjectName(pubspecFile);
        NameAndPath item = new NameAndPath(projectName, projectPath);
        if (!this.myComboItems.contains(item)) {
            this.myComboItems.add(item);
            this.myDartProjectCombo.getComboBox().setModel(new DefaultComboBoxModel<Object>(this.myComboItems.toArray()));
        }
        this.myDartProjectCombo.getComboBox().setSelectedItem(item);
    }

    protected void applyEditorTo(@NotNull DartRemoteDebugConfiguration config) throws ConfigurationException {
        if (config == null) {
            DartRemoteDebugConfigurationEditor.$$$reportNull$$$0(5);
        }
        DartRemoteDebugParameters params = config.getParameters();
        params.setHost(this.myHostField.getText().trim());
        params.setPort(this.myPortField.getNumber());
        Object selectedItem = this.myDartProjectCombo.getComboBox().getSelectedItem();
        params.setDartProjectPath(selectedItem instanceof NameAndPath ? ((NameAndPath)selectedItem).myPath : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/ui/DartRemoteDebugConfigurationEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/ui/DartRemoteDebugConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initDartProjectsCombo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedProjectPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        JTextArea jTextArea;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        PortField portField;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Host:");
        jBLabel.setDisplayedMnemonic('H');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostField = jTextField = new JTextField();
        jTextField.setText("localhost");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Port:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = portField = new PortField();
        portField.setNumber(5858);
        jPanel.add((Component)portField, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Search sources in:");
        jBLabel3.setDisplayedMnemonic('E');
        jBLabel3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDartProjectCombo = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, new Dimension(100, -1), new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVerticalScrollBarPolicy(21);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(100, -1), null, null));
        this.myVMArgsArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText("--debug:5858 --break-at-isolate-spawn");
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myCopyButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setText("");
        fixedSizeButton.setToolTipText("Copy to Clipboard");
        jPanel2.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Use these command line arguments when starting the remote VM:");
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor((Component)portField);
        jBLabel3.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class NameAndPath
    implements Comparable<NameAndPath> {
        @Nullable
        private final String myName;
        @NotNull
        private final String myPath;

        public NameAndPath(@Nullable String name, @NotNull String path) {
            if (path == null) {
                NameAndPath.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myPath = path;
        }

        public String getPresentableText() {
            return this.myName == null ? FileUtil.toSystemDependentName((String)this.myPath) : this.myName + " (" + FileUtil.toSystemDependentName((String)this.myPath) + ")";
        }

        public String toString() {
            return this.getPresentableText();
        }

        public boolean equals(Object o) {
            return o instanceof NameAndPath && this.myPath.equals(((NameAndPath)o).myPath);
        }

        public int hashCode() {
            return this.myPath.hashCode();
        }

        @Override
        public int compareTo(NameAndPath o) {
            return this.myPath.compareTo(o.myPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/ide/runner/server/ui/DartRemoteDebugConfigurationEditor$NameAndPath", "<init>"));
        }
    }
}

