/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DartCommandLineConfigurationEditorForm
extends SettingsEditor<DartCommandLineRunConfiguration> {
    private JPanel myMainPanel;
    private JLabel myDartFileLabel;
    private TextFieldWithBrowseButton myFileField;
    private RawCommandLineEditor myVMOptions;
    private JBCheckBox myCheckedModeCheckBox;
    private RawCommandLineEditor myArguments;
    private TextFieldWithBrowseButton myWorkingDirectory;
    private EnvironmentVariablesComponent myEnvironmentVariables;

    public DartCommandLineConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse(project, this.myFileField);
        this.myWorkingDirectory.addBrowseFolderListener(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myVMOptions.setDialogCaption(DartBundle.message("config.vmoptions.caption", new Object[0]));
        this.myArguments.setDialogCaption(DartBundle.message("config.progargs.caption", new Object[0]));
        this.myDartFileLabel.setPreferredSize(this.myEnvironmentVariables.getLabel().getPreferredSize());
        this.myEnvironmentVariables.setAnchor((JComponent)this.myDartFileLabel);
    }

    public static void initDartFileTextWithBrowse(@NotNull Project project, @NotNull TextFieldWithBrowseButton textWithBrowse) {
        if (project == null) {
            DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        if (textWithBrowse == null) {
            DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        textWithBrowse.getButton().addActionListener(e -> {
            VirtualFile virtualFile;
            String initialPath;
            if (textWithBrowse == null) {
                DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(5);
            }
            if (project == null) {
                DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(6);
            }
            VirtualFile initialFile = (initialPath = FileUtil.toSystemIndependentName((String)textWithBrowse.getText().trim())).isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(initialPath);
            PsiFile initialPsiFile = initialFile == null ? null : PsiManager.getInstance((Project)project).findFile(initialFile);
            TreeFileChooser fileChooser = TreeFileChooserFactory.getInstance((Project)project).createFileChooser(DartBundle.message("choose.dart.main.file", new Object[0]), initialPsiFile, (FileType)DartFileType.INSTANCE, file -> !DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(file));
            fileChooser.showDialog();
            PsiFile selectedFile = fileChooser.getSelectedFile();
            VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
            if (virtualFile != null) {
                String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                textWithBrowse.setText(path);
            }
        });
    }

    protected void resetEditorFrom(@NotNull DartCommandLineRunConfiguration configuration) {
        if (configuration == null) {
            DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        DartCommandLineRunnerParameters parameters = configuration.getRunnerParameters();
        this.myFileField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)parameters.getFilePath())));
        this.myArguments.setText(StringUtil.notNullize((String)parameters.getArguments()));
        this.myVMOptions.setText(StringUtil.notNullize((String)parameters.getVMOptions()));
        this.myCheckedModeCheckBox.setSelected(parameters.isCheckedMode());
        this.myWorkingDirectory.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)parameters.getWorkingDirectory())));
        this.myEnvironmentVariables.setEnvs(parameters.getEnvs());
        this.myEnvironmentVariables.setPassParentEnvs(parameters.isIncludeParentEnvs());
    }

    protected void applyEditorTo(@NotNull DartCommandLineRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(3);
        }
        DartCommandLineRunnerParameters parameters = configuration.getRunnerParameters();
        parameters.setFilePath(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myFileField.getText().trim()), (boolean)true));
        parameters.setArguments(StringUtil.nullize((String)this.myArguments.getText(), (boolean)true));
        parameters.setVMOptions(StringUtil.nullize((String)this.myVMOptions.getText(), (boolean)true));
        parameters.setCheckedMode(this.myCheckedModeCheckBox.isSelected());
        parameters.setWorkingDirectory(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myWorkingDirectory.getText().trim()), (boolean)true));
        parameters.setEnvs(this.myEnvironmentVariables.getEnvs());
        parameters.setIncludeParentEnvs(this.myEnvironmentVariables.isPassParentEnvs());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DartCommandLineConfigurationEditorForm.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithBrowse";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initDartFileTextWithBrowse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initDartFileTextWithBrowse$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setFocusable(true);
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myDartFileLabel = jLabel = new JLabel();
        jLabel.setInheritsPopupMenu(true);
        jLabel.setText("Dart file:");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("VM options:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptions = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setInheritsPopupMenu(true);
        jLabel3.setText("Program arguments:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArguments = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Working directory:");
        jLabel4.setDisplayedMnemonic('W');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnvironmentVariables = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText("&Environment variables");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myCheckedModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jBCheckBox.setText("Checked mode");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel2.setLabelFor((Component)rawCommandLineEditor2);
        jLabel3.setLabelFor((Component)rawCommandLineEditor);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

