/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.jetbrains.lang.dart.DartBundle;
import icons.DartIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.jsonRpc.Client;

public class OpenDartObservatoryUrlAction
extends DumbAwareAction {
    @Nullable
    private String myUrl;
    private final Computable<Boolean> myIsApplicable;

    public OpenDartObservatoryUrlAction(@Nullable String url, @NotNull Computable<Boolean> isApplicable) {
        if (isApplicable == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(0);
        }
        super(DartBundle.message("open.observatory.action.text", new Object[0]), DartBundle.message("open.observatory.action.description", new Object[0]), DartIcons.Observatory);
        this.myUrl = url;
        this.myIsApplicable = isApplicable;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(1);
        }
        this.myUrl = url;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(this.myUrl != null && (Boolean)this.myIsApplicable.compute() != false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(3);
        }
        if (this.myUrl != null) {
            OpenDartObservatoryUrlAction.openUrlInChromeFamilyBrowser(this.myUrl);
        }
    }

    public static void openUrlInChromeFamilyBrowser(@NotNull String url) {
        if (url == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(4);
        }
        try {
            BrowserConnectionManager connectionManager = BrowserConnectionManager.getInstance();
            Client chromeClient = connectionManager.findClient(client -> {
                WebBrowser browser = connectionManager.getBrowser(client);
                return browser != null && browser.getFamily() == BrowserFamily.CHROME;
            });
            if (chromeClient != null) {
                BrowserConnectionManager.getInstance().openUrl(chromeClient, (CharSequence)url);
            } else {
                OpenDartObservatoryUrlAction.openInAnyChromeFamilyBrowser(url);
            }
        }
        catch (Throwable t) {
            OpenDartObservatoryUrlAction.openInAnyChromeFamilyBrowser(url);
        }
    }

    private static void openInAnyChromeFamilyBrowser(@NotNull String url) {
        if (url == null) {
            OpenDartObservatoryUrlAction.$$$reportNull$$$0(5);
        }
        List chromeBrowsers = WebBrowserManager.getInstance().getBrowsers(browser -> browser.getFamily() == BrowserFamily.CHROME, true);
        BrowserLauncher.getInstance().browse(url, chromeBrowsers.isEmpty() ? null : (WebBrowser)chromeBrowsers.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openUrlInChromeFamilyBrowser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openInAnyChromeFamilyBrowser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

