/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugParameters;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartRemoteDebugConfigurationEditor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRemoteDebugConfiguration
extends RunConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction {
    @NotNull
    DartRemoteDebugParameters myParameters;

    protected DartRemoteDebugConfiguration(@NotNull Project project, @NotNull DartRemoteDebugConfigurationType configType, @NotNull String name) {
        if (project == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (configType == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(2);
        }
        super(project, configType.getConfigurationFactories()[0], name);
        this.myParameters = new DartRemoteDebugParameters();
    }

    @NotNull
    public DartRemoteDebugParameters getParameters() {
        DartRemoteDebugParameters dartRemoteDebugParameters = this.myParameters;
        if (dartRemoteDebugParameters == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(3);
        }
        return dartRemoteDebugParameters;
    }

    public void checkConfiguration() throws RuntimeConfigurationError {
        String path = this.myParameters.getDartProjectPath();
        if (path.isEmpty()) {
            throw new RuntimeConfigurationError("Dart project path is not specified");
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir == null || !dir.isDirectory()) {
            throw new RuntimeConfigurationError("Folder not found: " + FileUtil.toSystemDependentName((String)path));
        }
        if (!ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(dir)) {
            throw new RuntimeConfigurationError("Folder is not in project content: " + FileUtil.toSystemDependentName((String)path));
        }
    }

    public DartRemoteDebugConfiguration clone() {
        DartRemoteDebugConfiguration clone = (DartRemoteDebugConfiguration)super.clone();
        clone.myParameters = this.myParameters.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<DartRemoteDebugConfiguration> getConfigurationEditor() {
        DartRemoteDebugConfigurationEditor dartRemoteDebugConfigurationEditor = new DartRemoteDebugConfigurationEditor(this.getProject());
        if (dartRemoteDebugConfigurationEditor == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(4);
        }
        return dartRemoteDebugConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            DartRemoteDebugConfiguration.$$$reportNull$$$0(6);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myParameters, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.myParameters, (Element)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

