/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfigurationProducer;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCommandLineRuntimeConfigurationProducer
extends RunConfigurationProducer<DartCommandLineRunConfiguration> {
    public DartCommandLineRuntimeConfigurationProducer() {
        super((ConfigurationType)DartCommandLineRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(@NotNull DartCommandLineRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile dartFile;
        if (configuration == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((dartFile = DartCommandLineRuntimeConfigurationProducer.getRunnableDartFileFromContext(context, true)) == null || DartTestRunConfigurationProducer.isFileInTestDirAndTestPackageExists(context.getProject(), dartFile)) {
            return false;
        }
        configuration.getRunnerParameters().setFilePath(dartFile.getPath());
        configuration.getRunnerParameters().setWorkingDirectory(DartCommandLineRunnerParameters.suggestDartWorkingDir(context.getProject(), dartFile));
        configuration.setGeneratedName();
        sourceElement.set(sourceElement.isNull() ? null : ((PsiElement)sourceElement.get()).getContainingFile());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull DartCommandLineRunConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile dartFile;
        if (configuration == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        return (dartFile = DartCommandLineRuntimeConfigurationProducer.getDartFileFromContext(context)) != null && dartFile.getPath().equals(configuration.getRunnerParameters().getFilePath());
    }

    @Nullable
    public static VirtualFile getRunnableDartFileFromContext(@NotNull ConfigurationContext context, boolean checkBrowserSpecificImports) {
        PsiElement psiLocation;
        if (context == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = (psiLocation = context.getPsiLocation()) == null ? null : psiLocation.getContainingFile();
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(psiFile);
        if (!(!(psiFile instanceof DartFile) || virtualFile == null || !ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex().isInContent(virtualFile) || DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(psiFile.getProject(), virtualFile) || DartResolveUtil.getMainFunction(psiFile) == null || checkBrowserSpecificImports && DartCommandLineRuntimeConfigurationProducer.hasImport((DartFile)psiFile, "dart:html", "dart:html_common", "dart:indexed_db", "dart:js", "dart:svg", "dart:web_audio", "dart:web_gl", "dart:web_sql"))) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getDartFileFromContext(@NotNull ConfigurationContext context) {
        PsiElement psiLocation;
        if (context == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(6);
        }
        PsiFile psiFile = (psiLocation = context.getPsiLocation()) == null ? null : psiLocation.getContainingFile();
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(psiFile);
        return psiFile instanceof DartFile && virtualFile != null ? virtualFile : null;
    }

    private static boolean hasImport(@NotNull DartFile psiFile, String ... importTexts) {
        DartImportStatement[] importStatements;
        if (psiFile == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (importTexts == null) {
            DartCommandLineRuntimeConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((importStatements = (DartImportStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, DartImportStatement.class)) == null) {
            return false;
        }
        for (DartImportStatement importStatement : importStatements) {
            if (!ArrayUtil.contains((String)importStatement.getUriString(), (String[])importTexts)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importTexts";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunnableDartFileFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDartFileFromContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

