/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.coverage.DartCoverageProgramRunner;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartExecutionHelper;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.server.OpenDartObservatoryUrlAction;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCommandLineRunningState
extends CommandLineState {
    @NotNull
    protected final DartCommandLineRunnerParameters myRunnerParameters;
    private int myObservatoryPort;
    private Collection<Consumer<String>> myObservatoryUrlConsumers;

    public DartCommandLineRunningState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(0);
        }
        super(env);
        this.myObservatoryPort = -1;
        this.myObservatoryUrlConsumers = new ArrayList<Consumer<String>>();
        this.myRunnerParameters = ((DartRunConfiguration)env.getRunProfile()).getRunnerParameters().clone();
        Project project = env.getProject();
        try {
            this.myRunnerParameters.check(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        TextConsoleBuilder builder = this.getConsoleBuilder();
        if (builder instanceof TextConsoleBuilderImpl) {
            ((TextConsoleBuilderImpl)builder).setUsePredefinedMessageFilter(false);
        }
        try {
            builder.addFilter((Filter)new DartConsoleFilter(project, this.myRunnerParameters.getDartFileOrDirectory()));
            builder.addFilter((Filter)new DartRelativePathsConsoleFilter(project, this.myRunnerParameters.computeProcessWorkingDirectory(project)));
            builder.addFilter((Filter)new UrlFilter());
        }
        catch (RuntimeConfigurationError runtimeConfigurationError) {
            // empty catch block
        }
    }

    public void addObservatoryUrlConsumer(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(1);
        }
        this.myObservatoryUrlConsumers.add(consumer);
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(Arrays.asList(super.createActions(console, processHandler, executor)));
        this.addObservatoryActions(actions, processHandler);
        AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    protected void addObservatoryActions(List<AnAction> actions, ProcessHandler processHandler) {
        actions.add((AnAction)new Separator());
        OpenDartObservatoryUrlAction openObservatoryAction = new OpenDartObservatoryUrlAction(null, (Computable<Boolean>)((Computable)() -> !processHandler.isProcessTerminated()));
        this.addObservatoryUrlConsumer((Consumer<String>)((Consumer)openObservatoryAction::setUrl));
        actions.add((AnAction)openObservatoryAction);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = this.doStartProcess(null);
        if (processHandler == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    protected ProcessHandler doStartProcess(@Nullable String overriddenMainFilePath) throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine(overriddenMainFilePath);
        ColoredProcessHandler processHandler = new ColoredProcessHandler(commandLine){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (text.startsWith("Observatory listening on ")) {
                    text = text + "\n";
                }
                super.coloredTextAvailable(text, attributes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunningState$1";
                objectArray[2] = "coloredTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter((OSProcessHandler)processHandler){
            final /* synthetic */ OSProcessHandler val$processHandler;
            {
                this.val$processHandler = oSProcessHandler;
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                String prefix = "Observatory listening on http://";
                String text = event.getText().trim();
                if (text.startsWith("Observatory listening on http://")) {
                    this.val$processHandler.removeProcessListener((ProcessListener)this);
                    String url = "http://" + text.substring("Observatory listening on http://".length());
                    for (Consumer consumer : DartCommandLineRunningState.this.myObservatoryUrlConsumers) {
                        consumer.consume((Object)url);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunningState$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Project project = this.getEnvironment().getProject();
        try {
            DartRunConfiguration dartRunConfiguration = (DartRunConfiguration)this.getEnvironment().getRunProfile();
            VirtualFile launchFile = dartRunConfiguration.getRunnerParameters().getDartFileOrDirectory();
            String message = "<a href='open.dart.analysis'>Analysis issues</a> may affect the execution of '" + dartRunConfiguration.getName() + "'.";
            DartExecutionHelper.displayIssues(project, launchFile, message, dartRunConfiguration.getIcon());
        }
        catch (RuntimeConfigurationError error) {
            DartExecutionHelper.clearIssueNotifications(project);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.getEnvironment().getProject());
        return processHandler;
    }

    private GeneralCommandLine createCommandLine(@Nullable String overriddenMainFilePath) throws ExecutionException {
        DartSdk sdk = DartSdk.getDartSdk(this.getEnvironment().getProject());
        if (sdk == null) {
            throw new ExecutionException(DartBundle.message("dart.sdk.is.not.configured", new Object[0]));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(this.myRunnerParameters.computeProcessWorkingDirectory(this.getEnvironment().getProject()));
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)DartSdkUtil.getDartExePath(sdk)));
        commandLine.getEnvironment().putAll(this.myRunnerParameters.getEnvs());
        commandLine.withParentEnvironmentType(this.myRunnerParameters.isIncludeParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        this.setupParameters(commandLine, overriddenMainFilePath);
        return commandLine;
    }

    private void setupParameters(@NotNull GeneralCommandLine commandLine, @Nullable String overriddenMainFilePath) throws ExecutionException {
        VirtualFile dartFile;
        if (commandLine == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(4);
        }
        int customObservatoryPort = -1;
        String vmOptions = this.myRunnerParameters.getVMOptions();
        if (vmOptions != null) {
            CommandLineTokenizer vmOptionsTokenizer = new CommandLineTokenizer(vmOptions);
            while (vmOptionsTokenizer.hasMoreTokens()) {
                String vmOption = vmOptionsTokenizer.nextToken();
                commandLine.addParameter(vmOption);
                try {
                    if (vmOption.equals("--enable-vm-service") || vmOption.equals("--observe")) {
                        customObservatoryPort = 8181;
                        continue;
                    }
                    if (vmOption.startsWith("--enable-vm-service:")) {
                        customObservatoryPort = DartCommandLineRunningState.parseIntBeforeSlash(vmOption.substring("--enable-vm-service:".length()));
                        continue;
                    }
                    if (!vmOption.startsWith("--observe:")) continue;
                    customObservatoryPort = DartCommandLineRunningState.parseIntBeforeSlash(vmOption.substring("--observe:".length()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (this.myRunnerParameters.isCheckedMode()) {
            commandLine.addParameter("--checked");
        }
        try {
            dartFile = this.myRunnerParameters.getDartFileOrDirectory();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        if (DefaultDebugExecutor.EXECUTOR_ID.equals(this.getEnvironment().getExecutor().getId())) {
            commandLine.addParameter("--pause_isolates_on_start");
        }
        if (customObservatoryPort > 0) {
            this.myObservatoryPort = customObservatoryPort;
        } else {
            try {
                this.myObservatoryPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            commandLine.addParameter("--enable-vm-service:" + this.myObservatoryPort);
            if (this.getEnvironment().getRunner() instanceof DartCoverageProgramRunner) {
                commandLine.addParameter("--pause-isolates-on-exit");
            }
        }
        commandLine.addParameter(FileUtil.toSystemDependentName((String)(overriddenMainFilePath == null ? dartFile.getPath() : overriddenMainFilePath)));
        String arguments = this.myRunnerParameters.getArguments();
        if (arguments != null) {
            CommandLineTokenizer argumentsTokenizer = new CommandLineTokenizer(arguments);
            while (argumentsTokenizer.hasMoreTokens()) {
                commandLine.addParameter(argumentsTokenizer.nextToken());
            }
        }
    }

    private static int parseIntBeforeSlash(@NotNull String s) throws NumberFormatException {
        int index;
        if (s == null) {
            DartCommandLineRunningState.$$$reportNull$$$0(5);
        }
        return Integer.parseInt((index = s.indexOf(47)) > 0 ? s.substring(0, index) : s);
    }

    public int getObservatoryPort() {
        return this.myObservatoryPort;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunningState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunningState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addObservatoryUrlConsumer";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseIntBeforeSlash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

