/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCommandLineRunnerParameters
implements Cloneable {
    @Nullable
    private String myFilePath = null;
    @Nullable
    private String myVMOptions = null;
    private boolean myCheckedMode = true;
    @Nullable
    private String myArguments = null;
    @Nullable
    private String myWorkingDirectory = null;
    @NotNull
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    private boolean myIncludeParentEnvs = true;

    public static String suggestDartWorkingDir(@NotNull Project project, @NotNull VirtualFile dartFileOrFolder) {
        VirtualFile parent;
        VirtualFile pubspec;
        if (project == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(0);
        }
        if (dartFileOrFolder == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(1);
        }
        if ((pubspec = PubspecYamlUtil.findPubspecYamlFile(project, dartFileOrFolder)) != null && (parent = pubspec.getParent()) != null) {
            return parent.getPath();
        }
        if (dartFileOrFolder.isDirectory()) {
            return dartFileOrFolder.getPath();
        }
        return dartFileOrFolder.getParent().getPath();
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.myFilePath = filePath;
    }

    @Nullable
    public String getVMOptions() {
        return this.myVMOptions;
    }

    public void setVMOptions(@Nullable String vmOptions) {
        this.myVMOptions = vmOptions;
    }

    public boolean isCheckedMode() {
        return this.myCheckedMode;
    }

    public void setCheckedMode(boolean checkedMode) {
        this.myCheckedMode = checkedMode;
    }

    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void setArguments(@Nullable String arguments) {
        this.myArguments = arguments;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(2);
        }
        return map;
    }

    public void setEnvs(Map<String, String> envs) {
        if (envs != null) {
            this.myEnvs = envs;
        }
    }

    public boolean isIncludeParentEnvs() {
        return this.myIncludeParentEnvs;
    }

    public void setIncludeParentEnvs(boolean includeParentEnvs) {
        this.myIncludeParentEnvs = includeParentEnvs;
    }

    @NotNull
    public String computeProcessWorkingDirectory(@NotNull Project project) {
        String string;
        if (project == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
            String string2 = this.myWorkingDirectory;
            if (string2 == null) {
                DartCommandLineRunnerParameters.$$$reportNull$$$0(4);
            }
            return string2;
        }
        try {
            string = DartCommandLineRunnerParameters.suggestDartWorkingDir(project, this.getDartFileOrDirectory());
        }
        catch (RuntimeConfigurationError error) {
            if ("" == null) {
                DartCommandLineRunnerParameters.$$$reportNull$$$0(6);
            }
            return "";
        }
        if (string == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public VirtualFile getDartFile() throws RuntimeConfigurationError {
        VirtualFile dartFile = this.getDartFileOrDirectory();
        if (dartFile.isDirectory()) {
            assert (this.myFilePath != null);
            throw new RuntimeConfigurationError(DartBundle.message("dart.file.not.found", FileUtil.toSystemDependentName((String)this.myFilePath)));
        }
        VirtualFile virtualFile = dartFile;
        if (virtualFile == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getDartFileOrDirectory() throws RuntimeConfigurationError {
        if (StringUtil.isEmptyOrSpaces((String)this.myFilePath)) {
            throw new RuntimeConfigurationError(DartBundle.message("path.to.dart.file.not.set", new Object[0]));
        }
        VirtualFile dartFile = LocalFileSystem.getInstance().findFileByPath(this.myFilePath);
        if (dartFile == null) {
            throw new RuntimeConfigurationError(DartBundle.message("dart.file.not.found", FileUtil.toSystemDependentName((String)this.myFilePath)));
        }
        if (dartFile.getFileType() != DartFileType.INSTANCE && !dartFile.isDirectory()) {
            throw new RuntimeConfigurationError(DartBundle.message("not.a.dart.file.or.directory", FileUtil.toSystemDependentName((String)this.myFilePath)));
        }
        VirtualFile virtualFile = dartFile;
        if (virtualFile == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public void check(@NotNull Project project) throws RuntimeConfigurationError {
        VirtualFile workDir;
        DartSdk sdk;
        if (project == null) {
            DartCommandLineRunnerParameters.$$$reportNull$$$0(9);
        }
        if ((sdk = DartSdk.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(DartBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> {
                if (project == null) {
                    DartCommandLineRunnerParameters.$$$reportNull$$$0(10);
                }
                DartConfigurable.openDartSettings(project);
            });
        }
        this.getDartFileOrDirectory();
        if (!(StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory) || (workDir = LocalFileSystem.getInstance().findFileByPath(this.myWorkingDirectory)) != null && workDir.isDirectory())) {
            throw new RuntimeConfigurationError(DartBundle.message("work.dir.does.not.exist", FileUtil.toSystemDependentName((String)this.myWorkingDirectory)));
        }
    }

    protected DartCommandLineRunnerParameters clone() {
        try {
            DartCommandLineRunnerParameters clone = (DartCommandLineRunnerParameters)super.clone();
            clone.myEnvs = new LinkedHashMap<String, String>();
            clone.myEnvs.putAll(this.myEnvs);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartFileOrFolder";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunnerParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunnerParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProcessWorkingDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDartFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDartFileOrDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestDartWorkingDir";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeProcessWorkingDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$check$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

