/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.client;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartiumUtil {
    private static final String DART_FLAGS_ENV_VAR = "DART_FLAGS";
    public static final String CHECKED_MODE_OPTION = "--checked";
    private static final String ENABLE_ASYNC_OPTION = "--enable-async";
    private static final UUID DARTIUM_ID = UUID.fromString("BFEE1B69-A97D-4338-8BA4-25170ADCBAA6");
    private static final String DARTIUM_NAME = "Dartium";

    @Nullable
    public static WebBrowser getDartiumBrowser() {
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(DARTIUM_ID.toString());
        if (browser == null) {
            browser = WebBrowserManager.getInstance().findBrowserById(DARTIUM_NAME);
        }
        return browser != null && browser.getFamily() == BrowserFamily.CHROME ? browser : null;
    }

    @Nullable
    public static String getDartiumPathForSdk(@NotNull String sdkHomePath) {
        File sdkDir;
        if (sdkHomePath == null) {
            DartiumUtil.$$$reportNull$$$0(0);
        }
        if (!(sdkDir = new File(sdkHomePath)).isDirectory()) {
            return null;
        }
        File dartDir = sdkDir.getParentFile();
        String relativePath = SystemInfo.isMac ? "chromium/Chromium.app" : (SystemInfo.isWindows ? "chromium/chrome.exe" : "chromium/chrome");
        File dartiumPath = new File(dartDir, relativePath);
        return dartiumPath.exists() ? FileUtil.toSystemIndependentName((String)dartiumPath.getPath()) : null;
    }

    @NotNull
    public static WebBrowser ensureDartiumBrowserConfigured(@Nullable String dartiumPath) {
        WebBrowser browser = DartiumUtil.getDartiumBrowser();
        if (browser == null) {
            WebBrowser webBrowser = WebBrowserManager.getInstance().addBrowser(DARTIUM_ID, BrowserFamily.CHROME, DARTIUM_NAME, dartiumPath, true, BrowserFamily.CHROME.createBrowserSpecificSettings());
            if (webBrowser == null) {
                DartiumUtil.$$$reportNull$$$0(1);
            }
            return webBrowser;
        }
        if (!Comparing.equal((String)dartiumPath, (String)browser.getPath())) {
            WebBrowserManager.getInstance().setBrowserPath(browser, dartiumPath, true);
        }
        WebBrowser webBrowser = browser;
        if (webBrowser == null) {
            DartiumUtil.$$$reportNull$$$0(2);
        }
        return webBrowser;
    }

    @Nullable
    public static String getErrorMessageIfWrongDartiumPath(@NotNull String dartiumPath) {
        if (dartiumPath == null) {
            DartiumUtil.$$$reportNull$$$0(3);
        }
        if (dartiumPath.isEmpty()) {
            return null;
        }
        File file = new File(dartiumPath);
        if (SystemInfo.isMac && !file.isDirectory() || !SystemInfo.isMac && !file.isFile()) {
            return DartBundle.message("warning.invalid.dartium.path", new Object[0]);
        }
        return null;
    }

    public static void applyDartiumSettings(@NotNull String dartiumPathFromUI, @NotNull ChromeSettings dartiumSettingsFromUI) {
        WebBrowser dartiumInitial;
        String dartiumPathInitial;
        if (dartiumPathFromUI == null) {
            DartiumUtil.$$$reportNull$$$0(4);
        }
        if (dartiumSettingsFromUI == null) {
            DartiumUtil.$$$reportNull$$$0(5);
        }
        String string = dartiumPathInitial = (dartiumInitial = DartiumUtil.getDartiumBrowser()) == null ? null : dartiumInitial.getPath();
        if (!dartiumPathFromUI.isEmpty() && new File(dartiumPathFromUI).exists() && !dartiumPathFromUI.equals(dartiumPathInitial)) {
            DartSdkUtil.updateKnownDartiumPaths(dartiumPathInitial, dartiumPathFromUI);
            WebBrowser browser = DartiumUtil.ensureDartiumBrowserConfigured(dartiumPathFromUI);
            if (!dartiumSettingsFromUI.equals((Object)browser.getSpecificSettings())) {
                WebBrowserManager.getInstance().setBrowserSpecificSettings(browser, (BrowserSpecificSettings)dartiumSettingsFromUI);
            }
            return;
        }
        if (dartiumInitial != null && !dartiumSettingsFromUI.equals((Object)dartiumInitial.getSpecificSettings())) {
            WebBrowserManager.getInstance().setBrowserSpecificSettings(dartiumInitial, (BrowserSpecificSettings)dartiumSettingsFromUI);
        }
    }

    private static boolean hasDartFlag(Map<String, String> envVars, String dartFlag) {
        String dartFlags = envVars.get(DART_FLAGS_ENV_VAR);
        return dartFlags != null && (dartFlags.trim().equals(dartFlag) || dartFlags.startsWith(dartFlag + " ") || dartFlags.endsWith(" " + dartFlag) || dartFlags.contains(" " + dartFlag + " "));
    }

    public static void setCheckedMode(@NotNull Map<String, String> envVars, boolean checkedMode) {
        if (envVars == null) {
            DartiumUtil.$$$reportNull$$$0(6);
        }
        DartiumUtil.setDartFlagState(envVars, CHECKED_MODE_OPTION, checkedMode);
    }

    private static void setDartFlagState(Map<String, String> envVars, String dartFlag, boolean flagState) {
        boolean oldFlagState = DartiumUtil.hasDartFlag(envVars, dartFlag);
        if (oldFlagState == flagState) {
            return;
        }
        String dartFlags = envVars.get(DART_FLAGS_ENV_VAR);
        if (flagState) {
            if (dartFlags == null) {
                envVars.put(DART_FLAGS_ENV_VAR, dartFlag);
            } else {
                envVars.put(DART_FLAGS_ENV_VAR, dartFlags + " " + dartFlag);
            }
        } else {
            String newFlags = dartFlags;
            if (newFlags.trim().equals(dartFlag)) {
                newFlags = "";
            }
            newFlags = StringUtil.trimStart((String)newFlags, (String)(dartFlag + " "));
            int index = (newFlags = StringUtil.trimEnd((String)newFlags, (String)(" " + dartFlag))).indexOf(" " + dartFlag + " ");
            if (index != -1) {
                newFlags = newFlags.substring(0, index) + newFlags.substring(index + dartFlag.length() + 1);
            }
            if (StringUtil.isEmptyOrSpaces((String)newFlags)) {
                envVars.remove(DART_FLAGS_ENV_VAR);
            } else {
                envVars.put(DART_FLAGS_ENV_VAR, newFlags);
            }
        }
    }

    public static void resetDartiumFlags() {
        BrowserSpecificSettings browserSpecificSettings;
        WebBrowser dartium = DartiumUtil.getDartiumBrowser();
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = dartium == null ? null : dartium.getSpecificSettings();
        if (!(browserSpecificSettings instanceof ChromeSettings)) {
            return;
        }
        Map envVars = browserSpecificSettings.getEnvironmentVariables();
        DartiumUtil.setDartFlagState(envVars, ENABLE_ASYNC_OPTION, false);
        DartiumUtil.setDartFlagState(envVars, CHECKED_MODE_OPTION, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartiumPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartiumPathFromUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartiumSettingsFromUI";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureDartiumBrowserConfigured";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDartiumPathForSdk";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfWrongDartiumPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyDartiumSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCheckedMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

