/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.client;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeLocalDebuggerEngine;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartiumDebuggerEngine
extends ChromeLocalDebuggerEngine {
    private static final Logger LOG = Logger.getInstance(DartiumDebuggerEngine.class);

    @NotNull
    public ChromeDebugProcess createDebugProcess(@NotNull XDebugSession session, @NotNull WebBrowser browser, @NotNull DebuggableFileFinder fileFinder, @Nullable Url initialUrl, @Nullable ExecutionResult executionResult, boolean usePreliminaryPage) {
        if (session == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(0);
        }
        if (browser == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(1);
        }
        if (fileFinder == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(2);
        }
        ChromeDebugProcess debugProcess = super.createDebugProcess(session, browser, fileFinder, initialUrl, executionResult, usePreliminaryPage);
        debugProcess.setProcessBreakpointConditionsAtIdeSide(true);
        debugProcess.setBreakpointLanguageHint((breakpoint, location) -> {
            String result;
            String string = result = StringUtil.endsWithIgnoreCase((String)(breakpoint == null ? location.getUrl().getPath() : breakpoint.getFileUrl()), (String)".dart") ? "dart" : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug(breakpoint + ", " + location.getUrl() + " " + result);
            }
            return result;
        });
        ChromeDebugProcess chromeDebugProcess = debugProcess;
        if (chromeDebugProcess == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(3);
        }
        return chromeDebugProcess;
    }

    @Nullable
    public WebBrowser getBrowser() {
        return DartiumUtil.getDartiumBrowser();
    }

    public void checkAvailability(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(4);
        }
        if (DartiumUtil.getDartiumBrowser() == null) {
            throw new RuntimeConfigurationError(DartBundle.message("dartium.not.configured", CommonBundle.settingsActionPath()), () -> {
                if (project == null) {
                    DartiumDebuggerEngine.$$$reportNull$$$0(6);
                }
                DartConfigurable.openDartSettings(project);
            });
        }
    }

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        if (browser == null) {
            DartiumDebuggerEngine.$$$reportNull$$$0(5);
        }
        return browser.equals(DartiumUtil.getDartiumBrowser());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailability";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBrowserSupported";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkAvailability$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

