/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfigurationBase;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfiguration;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance((String)DartRunner.class.getName());

    @NotNull
    public String getRunnerId() {
        if ("DartRunner" == null) {
            DartRunner.$$$reportNull$$$0(0);
        }
        return "DartRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            DartRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            DartRunner.$$$reportNull$$$0(2);
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && (profile instanceof DartCommandLineRunConfiguration || profile instanceof DartTestRunConfiguration || profile instanceof DartRemoteDebugConfiguration);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        String executorId;
        if (state == null) {
            DartRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            DartRunner.$$$reportNull$$$0(4);
        }
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId = env.getExecutor().getId())) {
            LOG.error("Unexpected executor id: " + executorId);
            return null;
        }
        try {
            String dasExecutionContextId;
            RunProfile runConfig = env.getRunProfile();
            if (runConfig instanceof DartRunConfigurationBase && DartAnalysisServerService.getInstance(env.getProject()).serverReadyForRequest(env.getProject())) {
                String path = ((DartRunConfigurationBase)runConfig).getRunnerParameters().getFilePath();
                assert (path != null);
                dasExecutionContextId = DartAnalysisServerService.getInstance(env.getProject()).execution_createContext(path);
            } else {
                dasExecutionContextId = null;
            }
            return this.doExecuteDartDebug(state, env, dasExecutionContextId);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected int getTimeout() {
        return 5000;
    }

    private RunContentDescriptor doExecuteDartDebug(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment env, final @Nullable String dasExecutionContextId) throws RuntimeConfigurationError, ExecutionException {
        int observatoryPort;
        String debuggingHost;
        ExecutionResult executionResult;
        VirtualFile currentWorkingDirectory;
        VirtualFile contextFileOrDir;
        if (state == null) {
            DartRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            DartRunner.$$$reportNull$$$0(6);
        }
        DartSdk sdk = DartSdk.getDartSdk(env.getProject());
        assert (sdk != null);
        final RunProfile runConfiguration = env.getRunProfile();
        if (runConfiguration instanceof DartRunConfigurationBase) {
            contextFileOrDir = ((DartRunConfigurationBase)runConfiguration).getRunnerParameters().getDartFileOrDirectory();
            String cwd = ((DartRunConfigurationBase)runConfiguration).getRunnerParameters().computeProcessWorkingDirectory(env.getProject());
            currentWorkingDirectory = LocalFileSystem.getInstance().findFileByPath(cwd);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (executionResult == null) {
                return null;
            }
            debuggingHost = null;
            observatoryPort = ((DartCommandLineRunningState)state).getObservatoryPort();
        } else if (runConfiguration instanceof DartRemoteDebugConfiguration) {
            String path = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getDartProjectPath();
            contextFileOrDir = LocalFileSystem.getInstance().findFileByPath(path);
            if (contextFileOrDir == null) {
                throw new RuntimeConfigurationError("Folder not found: " + FileUtil.toSystemDependentName((String)path));
            }
            currentWorkingDirectory = contextFileOrDir;
            executionResult = null;
            debuggingHost = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getHost();
            observatoryPort = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getPort();
        } else {
            LOG.error("Unexpected run configuration: " + runConfiguration.getClass().getName());
            return null;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession debugSession = debuggerManager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                DartUrlResolver dartUrlResolver = DartRunner.this.getDartUrlResolver(env.getProject(), contextFileOrDir);
                DartVmServiceDebugProcess dartVmServiceDebugProcess = new DartVmServiceDebugProcess(session, StringUtil.notNullize((String)debuggingHost, (String)"localhost"), observatoryPort, executionResult, dartUrlResolver, dasExecutionContextId, runConfiguration instanceof DartRemoteDebugConfiguration, DartRunner.this.getTimeout(), currentWorkingDirectory);
                if (dartVmServiceDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dartVmServiceDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/DartRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/DartRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    protected DartUrlResolver getDartUrlResolver(@NotNull Project project, @NotNull VirtualFile contextFileOrDir) {
        if (project == null) {
            DartRunner.$$$reportNull$$$0(7);
        }
        if (contextFileOrDir == null) {
            DartRunner.$$$reportNull$$$0(8);
        }
        return DartUrlResolver.getInstance(project, contextFileOrDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/DartRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFileOrDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/DartRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteDartDebug";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDartUrlResolver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

