/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.runner.DartPositionInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRelativePathsConsoleFilter
implements Filter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBaseDirPath;

    public DartRelativePathsConsoleFilter(@NotNull Project project, @NotNull String baseDirPath) {
        if (project == null) {
            DartRelativePathsConsoleFilter.$$$reportNull$$$0(0);
        }
        if (baseDirPath == null) {
            DartRelativePathsConsoleFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBaseDirPath = baseDirPath;
    }

    @Nullable
    public Filter.Result applyFilter(String text, int entireLength) {
        String trimmedText = StringUtil.trimLeading((String)text);
        Trinity<String, Integer, Integer> fileRelPathLineAndColumn = DartRelativePathsConsoleFilter.getFileRelPathLineAndColumn(trimmedText);
        if (fileRelPathLineAndColumn == null) {
            return null;
        }
        String fileRelPath = (String)fileRelPathLineAndColumn.first;
        int line = (Integer)fileRelPathLineAndColumn.second;
        int column = (Integer)fileRelPathLineAndColumn.third;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myBaseDirPath + "/" + trimmedText.substring(0, fileRelPath.length()));
        if (file == null || file.isDirectory()) {
            return null;
        }
        return new Filter.Result(entireLength - trimmedText.length(), entireLength - trimmedText.length() + fileRelPath.length(), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, line, column));
    }

    @Nullable
    public static Trinity<String, Integer, Integer> getFileRelPathLineAndColumn(@NotNull String text) {
        int column;
        int line;
        char ch;
        if (text == null) {
            DartRelativePathsConsoleFilter.$$$reportNull$$$0(2);
        }
        if (text.isEmpty()) {
            return null;
        }
        if (text.charAt(0) != '.' && !Character.isJavaIdentifierStart(text.charAt(0))) {
            return null;
        }
        int index = 0;
        while (text.length() > ++index && ((ch = text.charAt(index)) == '/' || ch == '\\' || ch == '.' || Character.isJavaIdentifierPart(ch))) {
        }
        if (text.length() <= index + 3) {
            return null;
        }
        String relPath = text.substring(0, index);
        if (!relPath.endsWith(".dart") || text.charAt(index) != ' ' && text.charAt(index) != ':') {
            return null;
        }
        Couple<Integer> lineAndColumn = DartPositionInfo.parseLineAndColumn(text.substring(index + 1));
        int n = lineAndColumn == null ? -1 : (line = (Integer)lineAndColumn.first >= 0 ? (Integer)lineAndColumn.first - 1 : (Integer)lineAndColumn.first);
        int n2 = lineAndColumn == null ? -1 : (column = (Integer)lineAndColumn.second >= 0 ? (Integer)lineAndColumn.second - 1 : (Integer)lineAndColumn.second);
        if (line < 0 || column < 0) {
            return null;
        }
        return Trinity.create((Object)relPath, (Object)line, (Object)column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/DartRelativePathsConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileRelPathLineAndColumn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

