/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPositionInfo {
    @NotNull
    public final Type type;
    @NotNull
    public final String path;
    public final int highlightingStartIndex;
    public final int highlightingEndIndex;
    public final int line;
    public final int column;

    public DartPositionInfo(@NotNull Type type, @NotNull String path, int highlightingStartIndex, int highlightingEndIndex, int line, int column) {
        if (type == null) {
            DartPositionInfo.$$$reportNull$$$0(0);
        }
        if (path == null) {
            DartPositionInfo.$$$reportNull$$$0(1);
        }
        this.type = type;
        this.path = path;
        this.highlightingStartIndex = highlightingStartIndex;
        this.highlightingEndIndex = highlightingEndIndex;
        this.line = line;
        this.column = column;
    }

    @Nullable
    public static DartPositionInfo parsePositionInfo(@NotNull String text) {
        int line;
        Couple<Integer> pathStartAndEnd;
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(2);
        }
        if ((pathStartAndEnd = DartPositionInfo.parseUrlStartAndEnd(text, "package:")) == null) {
            pathStartAndEnd = DartPositionInfo.parseUrlStartAndEnd(text, "dart:");
        }
        if (pathStartAndEnd == null) {
            pathStartAndEnd = DartPositionInfo.parseUrlStartAndEnd(text, "file:");
        }
        if (pathStartAndEnd == null) {
            pathStartAndEnd = DartPositionInfo.parseDartLibUrlStartAndEnd(text);
        }
        if (pathStartAndEnd == null) {
            return null;
        }
        Integer urlStartIndex = (Integer)pathStartAndEnd.first;
        Integer urlEndIndex = (Integer)pathStartAndEnd.second;
        String url = text.substring(urlStartIndex, urlEndIndex);
        String tail = text.length() == urlEndIndex.intValue() ? "" : text.substring(urlEndIndex).trim();
        Couple<Integer> lineAndColumn = DartPositionInfo.parseLineAndColumn(tail);
        int colonIndexInUrl = url.indexOf(58);
        assert (colonIndexInUrl > 0) : text;
        Type type = Type.getType(url.substring(0, colonIndexInUrl));
        assert (type != null) : text;
        int pathStartIndexInUrl = type == Type.FILE ? colonIndexInUrl + 1 + DartPositionInfo.getPathStartIndex(url.substring(colonIndexInUrl + 1)) : colonIndexInUrl + 1;
        String path = url.substring(pathStartIndexInUrl, url.length());
        int n = lineAndColumn == null ? -1 : (line = (Integer)lineAndColumn.first >= 0 ? (Integer)lineAndColumn.first - 1 : (Integer)lineAndColumn.first);
        int column = lineAndColumn == null ? -1 : ((Integer)lineAndColumn.second >= 0 ? (Integer)lineAndColumn.second - 1 : (Integer)lineAndColumn.second);
        return new DartPositionInfo(type, FileUtil.toSystemIndependentName((String)path), urlStartIndex, urlEndIndex, line, column);
    }

    @Nullable
    public static Couple<Integer> parseLineAndColumn(@NotNull String text) {
        Couple<Integer> result;
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(3);
        }
        return (result = DartPositionInfo.parseLineAndColumnInColonFormat(text)) != null ? result : DartPositionInfo.parseLineAndColumnInTextFormat(text);
    }

    @Nullable
    private static Couple<Integer> parseUrlStartAndEnd(String text, String prefix) {
        int pathEndIndex;
        int pathStartIndex = text.indexOf(prefix);
        if (pathStartIndex < 0 || pathStartIndex > 0 && !DartPositionInfo.isCharAllowedBeforePath(text.charAt(pathStartIndex - 1))) {
            return null;
        }
        String lowercased = text.toLowerCase(Locale.US);
        int dotDartIndex = pathStartIndex;
        do {
            dotDartIndex = lowercased.indexOf(".dart", dotDartIndex + 1);
            pathEndIndex = dotDartIndex + ".dart".length();
        } while (dotDartIndex > 0 && text.length() > pathEndIndex && !DartPositionInfo.isCharAllowedAfterPath(text.charAt(pathEndIndex)));
        if (dotDartIndex <= pathStartIndex || text.length() > pathEndIndex && !DartPositionInfo.isCharAllowedAfterPath(text.charAt(pathEndIndex))) {
            return null;
        }
        return Couple.of((Object)pathStartIndex, (Object)pathEndIndex);
    }

    @Nullable
    private static Couple<Integer> parseDartLibUrlStartAndEnd(String text) {
        int libNameStartIndex;
        int index;
        int pathStartIndex = text.indexOf("dart:");
        if (pathStartIndex < 0 || pathStartIndex > 0 && !DartPositionInfo.isCharAllowedBeforePath(text.charAt(pathStartIndex - 1))) {
            return null;
        }
        for (index = libNameStartIndex = pathStartIndex + "dart:".length(); text.length() > index && ('_' == text.charAt(index) || Character.isLetter(text.charAt(index))); ++index) {
        }
        if (index == libNameStartIndex) {
            return null;
        }
        return Couple.of((Object)pathStartIndex, (Object)index);
    }

    private static boolean isCharAllowedBeforePath(char ch) {
        return !Character.isLetterOrDigit(ch);
    }

    private static boolean isCharAllowedAfterPath(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '/' && ch != '.' && ch != '_';
    }

    @Nullable
    private static Couple<Integer> parseLineAndColumnInColonFormat(@NotNull String text) {
        Pair<Integer, String> lineAndRemainingText;
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(4);
        }
        if ((lineAndRemainingText = DartPositionInfo.parseNextIntSkippingColon(text)) == null) {
            return null;
        }
        Pair<Integer, String> colonAndRemainingText = DartPositionInfo.parseNextIntSkippingColon(((String)lineAndRemainingText.second).trim());
        if (colonAndRemainingText == null) {
            return Couple.of((Object)lineAndRemainingText.first, (Object)-1);
        }
        return Couple.of((Object)lineAndRemainingText.first, (Object)colonAndRemainingText.first);
    }

    @Nullable
    private static Couple<Integer> parseLineAndColumnInTextFormat(@NotNull String text) {
        int index;
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(5);
        }
        if ((index = text.indexOf("line ")) == -1) {
            return null;
        }
        Pair<Integer, String> lineAndRemainingText = DartPositionInfo.parseNextIntSkippingColon(text.substring(index += "line ".length()));
        if (lineAndRemainingText == null) {
            return null;
        }
        Pair<Integer, String> colonAndRemainingText = null;
        String trimmedTail = ((String)lineAndRemainingText.second).trim();
        if (trimmedTail.startsWith("pos ")) {
            colonAndRemainingText = DartPositionInfo.parseNextIntSkippingColon(trimmedTail.substring("pos ".length()));
        }
        if (colonAndRemainingText == null) {
            return Couple.of((Object)lineAndRemainingText.first, (Object)-1);
        }
        return Couple.of((Object)lineAndRemainingText.first, (Object)colonAndRemainingText.first);
    }

    @Nullable
    private static Pair<Integer, String> parseNextIntSkippingColon(@NotNull String text) {
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(6);
        }
        int index = 0;
        if (text.length() > index && text.charAt(index) == ':') {
            ++index;
        }
        while (text.length() > index && Character.isWhitespace(text.charAt(index))) {
            ++index;
        }
        int numberStartIndex = index;
        while (text.length() > index && text.charAt(index) >= '0' && text.charAt(index) <= '9') {
            ++index;
        }
        int numberEndIndex = index;
        if (numberStartIndex == numberEndIndex) {
            return null;
        }
        try {
            int line = Integer.parseInt(text.substring(numberStartIndex, numberEndIndex));
            String remainingText = text.substring(numberEndIndex);
            return Pair.create((Object)line, (Object)remainingText);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int getPathStartIndex(@NotNull String text) {
        int index;
        if (text == null) {
            DartPositionInfo.$$$reportNull$$$0(7);
        }
        if (text.isEmpty() || text.charAt(0) != '/') {
            return 0;
        }
        for (index = 0; index < text.length() && text.charAt(index) == '/'; ++index) {
        }
        return SystemInfo.isWindows ? index : index - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/DartPositionInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePositionInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLineAndColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLineAndColumnInColonFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLineAndColumnInTextFormat";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseNextIntSkippingColon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathStartIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        FILE,
        DART,
        PACKAGE;


        @Nullable
        public static Type getType(String type) {
            if ("file".equals(type)) {
                return FILE;
            }
            if ("dart".equals(type)) {
                return DART;
            }
            if ("package".equals(type)) {
                return PACKAGE;
            }
            return null;
        }
    }
}

