/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import com.jetbrains.lang.dart.resolve.DartResolveScopeProvider;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartExecutionHelper {
    private DartExecutionHelper() {
    }

    public static boolean hasIssues(@NotNull Project project, @NotNull VirtualFile launchFile) {
        if (project == null) {
            DartExecutionHelper.$$$reportNull$$$0(0);
        }
        if (launchFile == null) {
            DartExecutionHelper.$$$reportNull$$$0(1);
        }
        return !DartExecutionHelper.getIssues(project, launchFile).isEmpty();
    }

    @NotNull
    public static List<DartServerData.DartError> getIssues(@NotNull Project project, @NotNull VirtualFile launchFile) {
        if (project == null) {
            DartExecutionHelper.$$$reportNull$$$0(2);
        }
        if (launchFile == null) {
            DartExecutionHelper.$$$reportNull$$$0(3);
        }
        List<DartServerData.DartError> list = DartExecutionHelper.getIssues(project, launchFile, true);
        if (list == null) {
            DartExecutionHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<DartServerData.DartError> getIssues(@NotNull Project project, @NotNull VirtualFile launchFile, boolean onlyErrors) {
        GlobalSearchScope scope;
        if (project == null) {
            DartExecutionHelper.$$$reportNull$$$0(5);
        }
        if (launchFile == null) {
            DartExecutionHelper.$$$reportNull$$$0(6);
        }
        if ((scope = DartResolveScopeProvider.getDartScope(project, launchFile, true)) == null) {
            List<DartServerData.DartError> list = Collections.emptyList();
            if (list == null) {
                DartExecutionHelper.$$$reportNull$$$0(7);
            }
            return list;
        }
        DartAnalysisServerService analysisServerService = DartAnalysisServerService.getInstance(project);
        List<DartServerData.DartError> errors = analysisServerService.getErrors((SearchScope)scope);
        if (onlyErrors) {
            errors = errors.stream().filter(DartServerData.DartError::isError).collect(Collectors.toList());
        }
        List<DartServerData.DartError> list = errors;
        if (list == null) {
            DartExecutionHelper.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static void displayIssues(@NotNull Project project, @NotNull VirtualFile launchFile, @NotNull String message, @Nullable Icon icon) {
        if (project == null) {
            DartExecutionHelper.$$$reportNull$$$0(9);
        }
        if (launchFile == null) {
            DartExecutionHelper.$$$reportNull$$$0(10);
        }
        if (message == null) {
            DartExecutionHelper.$$$reportNull$$$0(11);
        }
        DartExecutionHelper.clearIssueNotifications(project);
        List<DartServerData.DartError> errors = DartExecutionHelper.getIssues(project, launchFile);
        if (errors.isEmpty()) {
            return;
        }
        DartProblemsView problemsView = DartProblemsView.getInstance(project);
        problemsView.showErrorNotification("", message, icon);
    }

    public static void clearIssueNotifications(@NotNull Project project) {
        if (project == null) {
            DartExecutionHelper.$$$reportNull$$$0(12);
        }
        DartProblemsView problemsView = DartProblemsView.getInstance(project);
        problemsView.clearNotifications();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchFile";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/runner/DartExecutionHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/runner/DartExecutionHelper";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasIssues";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "displayIssues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearIssueNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

