/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import com.jetbrains.lang.dart.ide.runner.DartPositionInfo;
import com.jetbrains.lang.dart.ide.runner.server.OpenDartObservatoryUrlAction;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartConsoleFilter
implements Filter {
    @NotNull
    private final Project myProject;
    @Nullable
    private final DartSdk mySdk;
    @Nullable
    private final DartUrlResolver myDartUrlResolver;
    private Collection<VirtualFile> myAllPubspecYamlFiles;
    public static final String OBSERVATORY_LISTENING_ON = "Observatory listening on ";

    public DartConsoleFilter(@NotNull Project project) {
        if (project == null) {
            DartConsoleFilter.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public DartConsoleFilter(@NotNull Project project, @Nullable VirtualFile contextFile) {
        if (project == null) {
            DartConsoleFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySdk = DartSdk.getDartSdk(project);
        this.myDartUrlResolver = contextFile == null ? null : DartUrlResolver.getInstance(project, contextFile);
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        VirtualFile file;
        if (line.startsWith("Observatory listening on http://")) {
            return DartConsoleFilter.getObservatoryUrlResult(line, entireLength - line.length());
        }
        DartPositionInfo info = DartPositionInfo.parsePositionInfo(line);
        if (info == null) {
            return null;
        }
        switch (info.type) {
            case FILE: {
                String path = URLUtil.unescapePercentSequences((String)info.path);
                if (SystemInfo.isWindows) {
                    path = StringUtil.trimLeading((String)path, (char)'/');
                }
                file = LocalFileSystem.getInstance().findFileByPath(path);
                break;
            }
            case DART: {
                file = DartUrlResolver.findFileInDartSdkLibFolder(this.myProject, this.mySdk, "dart:" + info.path);
                break;
            }
            case PACKAGE: {
                VirtualFile yamlFile;
                if (this.myDartUrlResolver != null) {
                    file = this.myDartUrlResolver.findFileByDartUrl("package:" + info.path);
                    break;
                }
                if (this.myAllPubspecYamlFiles == null) {
                    this.myAllPubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
                }
                VirtualFile inPackage = null;
                Iterator<VirtualFile> iterator = this.myAllPubspecYamlFiles.iterator();
                while (iterator.hasNext() && (inPackage = DartUrlResolver.getInstance(this.myProject, yamlFile = iterator.next()).findFileByDartUrl("package:" + info.path)) == null) {
                }
                file = inPackage;
                break;
            }
            default: {
                file = null;
            }
        }
        if (file != null && !file.isDirectory()) {
            int highlightStartOffset = entireLength - line.length() + info.highlightingStartIndex;
            int highlightEndOffset = entireLength - line.length() + info.highlightingEndIndex;
            return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, info.line, info.column));
        }
        return null;
    }

    @Nullable
    private static Filter.Result getObservatoryUrlResult(String line, int lineStartOffset) {
        assert (line.startsWith("Observatory listening on http://")) : line;
        String url = line.trim().substring(OBSERVATORY_LISTENING_ON.length());
        int colonIndex = url.indexOf(":", "http://".length());
        if (colonIndex <= 0) {
            return null;
        }
        String port = url.substring(colonIndex + 1);
        try {
            Integer.parseInt(port);
            int startOffset = lineStartOffset + OBSERVATORY_LISTENING_ON.length();
            return new Filter.Result(startOffset, startOffset + url.length(), (HyperlinkInfo)new ObservatoryHyperlinkInfo(url));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/DartConsoleFilter", "<init>"));
    }

    private static class ObservatoryHyperlinkInfo
    implements HyperlinkInfo {
        private final String myUrl;

        public ObservatoryHyperlinkInfo(@NotNull String url) {
            if (url == null) {
                ObservatoryHyperlinkInfo.$$$reportNull$$$0(0);
            }
            this.myUrl = StringUtil.replace((String)url, (String)"http://0.0.0.0:", (String)"http://localhost:");
        }

        public void navigate(Project project) {
            OpenDartObservatoryUrlAction.openUrlInChromeFamilyBrowser(this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/DartConsoleFilter$ObservatoryHyperlinkInfo", "<init>"));
        }
    }
}

