/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.status;

import com.google.common.collect.Lists;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusContext;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusEntry;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusSeverity;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringStatus {
    @NotNull
    private final List<RefactoringStatusEntry> entries = Lists.newArrayList();
    @NotNull
    private RefactoringStatusSeverity severity = RefactoringStatusSeverity.OK;

    public void addEntry(@NotNull RefactoringStatusEntry entry) {
        if (entry == null) {
            RefactoringStatus.$$$reportNull$$$0(0);
        }
        this.entries.add(entry);
        this.severity = RefactoringStatus.max(this.severity, entry.getSeverity());
    }

    public void addError(@NotNull String msg) {
        if (msg == null) {
            RefactoringStatus.$$$reportNull$$$0(1);
        }
        this.addError(msg, null);
    }

    public void addError(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            RefactoringStatus.$$$reportNull$$$0(2);
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.ERROR, msg, context));
    }

    public void addFatalError(@NotNull String msg) {
        if (msg == null) {
            RefactoringStatus.$$$reportNull$$$0(3);
        }
        this.addFatalError(msg, null);
    }

    public void addFatalError(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            RefactoringStatus.$$$reportNull$$$0(4);
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.FATAL, msg, context));
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addWarning(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            RefactoringStatus.$$$reportNull$$$0(5);
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.WARNING, msg, context));
    }

    @NotNull
    public RefactoringStatus escalateErrorToFatal() {
        RefactoringStatus result = new RefactoringStatus();
        for (RefactoringStatusEntry entry : this.entries) {
            RefactoringStatusSeverity severity = entry.getSeverity();
            if (severity == RefactoringStatusSeverity.ERROR) {
                severity = RefactoringStatusSeverity.FATAL;
            }
            result.addEntry(new RefactoringStatusEntry(severity, entry.getMessage(), entry.getContext()));
        }
        RefactoringStatus refactoringStatus = result;
        if (refactoringStatus == null) {
            RefactoringStatus.$$$reportNull$$$0(6);
        }
        return refactoringStatus;
    }

    @NotNull
    public List<RefactoringStatusEntry> getEntries() {
        List<RefactoringStatusEntry> list = this.entries;
        if (list == null) {
            RefactoringStatus.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public RefactoringStatusEntry getEntryWithHighestSeverity() {
        if (this.entries.isEmpty()) {
            return null;
        }
        RefactoringStatusEntry result = this.entries.get(0);
        for (RefactoringStatusEntry entry : this.entries) {
            if (result.getSeverity().ordinal() >= entry.getSeverity().ordinal()) continue;
            result = entry;
        }
        return result;
    }

    @Nullable
    public String getMessage() {
        RefactoringStatusEntry entry = this.getEntryWithHighestSeverity();
        if (entry == null) {
            return null;
        }
        return entry.getMessage();
    }

    @NotNull
    public RefactoringStatusSeverity getSeverity() {
        RefactoringStatusSeverity refactoringStatusSeverity = this.severity;
        if (refactoringStatusSeverity == null) {
            RefactoringStatus.$$$reportNull$$$0(8);
        }
        return refactoringStatusSeverity;
    }

    public boolean hasError() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR;
    }

    public boolean hasFatalError() {
        return this.severity == RefactoringStatusSeverity.FATAL;
    }

    public boolean hasInfo() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR || this.severity == RefactoringStatusSeverity.WARNING || this.severity == RefactoringStatusSeverity.INFO;
    }

    public boolean hasWarning() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR || this.severity == RefactoringStatusSeverity.WARNING;
    }

    public boolean isOK() {
        return this.severity == RefactoringStatusSeverity.OK;
    }

    public void merge(@Nullable RefactoringStatus other) {
        if (other == null) {
            return;
        }
        this.entries.addAll(other.entries);
        this.severity = RefactoringStatus.max(this.severity, other.getSeverity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.severity.name());
        if (!this.isOK()) {
            sb.append("\n");
            for (RefactoringStatusEntry entry : this.entries) {
                sb.append("\t").append(entry).append("\n");
            }
        }
        sb.append(">");
        return sb.toString();
    }

    @NotNull
    public static RefactoringStatus createErrorStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addError(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            RefactoringStatus.$$$reportNull$$$0(9);
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createFatalErrorStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addFatalError(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            RefactoringStatus.$$$reportNull$$$0(10);
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createFatalErrorStatus(String msg, RefactoringStatusContext context) {
        RefactoringStatus status = new RefactoringStatus();
        status.addFatalError(msg, context);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            RefactoringStatus.$$$reportNull$$$0(11);
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createWarningStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addWarning(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            RefactoringStatus.$$$reportNull$$$0(12);
        }
        return refactoringStatus;
    }

    @NotNull
    private static <T extends Enum<T>> T max(@NotNull T a, @NotNull T b) {
        if (a == null) {
            RefactoringStatus.$$$reportNull$$$0(13);
        }
        if (b == null) {
            RefactoringStatus.$$$reportNull$$$0(14);
        }
        if (b.ordinal() > a.ordinal()) {
            T t = b;
            if (t == null) {
                RefactoringStatus.$$$reportNull$$$0(15);
            }
            return t;
        }
        T t = a;
        if (t == null) {
            RefactoringStatus.$$$reportNull$$$0(16);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escalateErrorToFatal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorStatus";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFatalErrorStatus";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarningStatus";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "max";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEntry";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFatalError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWarning";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

