/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.introduce;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.ide.refactoring.introduce.DartIntroduceDialog;
import com.jetbrains.lang.dart.ide.refactoring.introduce.DartIntroduceOperation;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import com.jetbrains.lang.dart.util.DartNameSuggesterUtil;
import com.jetbrains.lang.dart.util.DartRefactoringUtil;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartIntroduceHandler
implements RefactoringActionHandler {
    protected final String myDialogTitle;

    @Nullable
    protected static PsiElement findAnchor(PsiElement occurrence) {
        return DartIntroduceHandler.findAnchor(Collections.singletonList(occurrence));
    }

    @Nullable
    protected static PsiElement findAnchor(List<PsiElement> occurrences) {
        PsiElement aChildren;
        PsiElement[] children;
        int minOffset = Integer.MAX_VALUE;
        for (PsiElement element : occurrences) {
            minOffset = Math.min(minOffset, element.getTextRange().getStartOffset());
        }
        DartStatements statements = DartIntroduceHandler.findContainingStatements(occurrences);
        if (statements == null) {
            return null;
        }
        PsiElement child = null;
        PsiElement[] psiElementArray = children = statements.getChildren();
        int n = psiElementArray.length;
        for (int i = 0; i < n && !(child = (aChildren = psiElementArray[i])).getTextRange().contains(minOffset); ++i) {
        }
        return child;
    }

    @Nullable
    private static DartStatements findContainingStatements(List<PsiElement> occurrences) {
        DartStatements result = (DartStatements)PsiTreeUtil.getParentOfType((PsiElement)occurrences.get(0), DartStatements.class, (boolean)true);
        while (result != null && !UsefulPsiTreeUtil.isAncestor((PsiElement)result, occurrences, true)) {
            result = (DartStatements)PsiTreeUtil.getParentOfType((PsiElement)result, DartStatements.class, (boolean)true);
        }
        return result;
    }

    public DartIntroduceHandler(@NotNull String dialogTitle) {
        if (dialogTitle == null) {
            DartIntroduceHandler.$$$reportNull$$$0(0);
        }
        this.myDialogTitle = dialogTitle;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            DartIntroduceHandler.$$$reportNull$$$0(1);
        }
        this.performAction(new DartIntroduceOperation(project, editor, file, null));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            DartIntroduceHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DartIntroduceHandler.$$$reportNull$$$0(3);
        }
    }

    public void performAction(DartIntroduceOperation operation) {
        TemplateState templateState;
        PsiFile file = operation.getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled() && (templateState = TemplateManagerImpl.getTemplateState((Editor)operation.getEditor())) != null && !templateState.isFinished()) {
            return;
        }
        Object element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = element1.getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = element2.getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
        } else {
            if (this.smartIntroduce(operation)) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        Project project = operation.getProject();
        if (element1 == null || element2 == null) {
            this.showCannotPerformError(project, editor);
            return;
        }
        if ((element1 = DartRefactoringUtil.getSelectedExpression(project, file, element1, element2)) == null) {
            this.showCannotPerformError(project, editor);
            return;
        }
        if (!this.checkIntroduceContext(file, editor, (PsiElement)element1)) {
            return;
        }
        operation.setElement((PsiElement)element1);
        this.performActionOnElement(operation);
    }

    protected boolean checkIntroduceContext(PsiFile file, Editor editor, PsiElement element) {
        if (!this.isValidIntroduceContext(element)) {
            this.showCannotPerformError(file.getProject(), editor);
            return false;
        }
        return true;
    }

    private void showCannotPerformError(Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)DartBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.myDialogTitle, (String)"refactoring.extractMethod");
    }

    protected boolean isValidIntroduceContext(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, DartFormalParameterList.class) == null;
    }

    private boolean smartIntroduce(final DartIntroduceOperation operation) {
        int offset;
        PsiElement elementAtCaret;
        Editor editor = operation.getEditor();
        PsiFile file = operation.getFile();
        if (!this.checkIntroduceContext(file, editor, elementAtCaret = file.findElementAt(offset = editor.getCaretModel().getOffset()))) {
            return true;
        }
        ArrayList<DartExpression> expressions = new ArrayList<DartExpression>();
        while (elementAtCaret != null && !(elementAtCaret instanceof DartFile)) {
            if (elementAtCaret instanceof DartExpression) {
                expressions.add((DartExpression)elementAtCaret);
            }
            elementAtCaret = elementAtCaret.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            operation.setElement((PsiElement)expressions.get(0));
            this.performActionOnElement(operation);
            return true;
        }
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<DartExpression>(){

                public void pass(DartExpression expression) {
                    operation.setElement((PsiElement)expression);
                    DartIntroduceHandler.this.performActionOnElement(operation);
                }
            }, PsiElement::getText);
            return true;
        }
        return false;
    }

    private void performActionOnElement(DartIntroduceOperation operation) {
        if (!this.checkEnabled(operation)) {
            return;
        }
        PsiElement element = operation.getElement();
        DartExpression initializer = (DartExpression)element;
        operation.setInitializer(initializer);
        operation.setOccurrences(this.getOccurrences(element, initializer));
        operation.setSuggestedNames(DartNameSuggesterUtil.getSuggestedNames(initializer));
        if (operation.getOccurrences().size() == 0) {
            operation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(operation);
    }

    protected void performActionOnElementOccurrences(final DartIntroduceOperation operation) {
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            DartIntroduceHandler.ensureName(operation);
            if (operation.isReplaceAll()) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        DartIntroduceHandler.this.performInplaceIntroduce(operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    protected boolean checkEnabled(DartIntroduceOperation operation) {
        return true;
    }

    protected static void ensureName(DartIntroduceOperation operation) {
        if (operation.getName() == null) {
            Collection<String> suggestedNames = operation.getSuggestedNames();
            if (suggestedNames.size() > 0) {
                operation.setName(suggestedNames.iterator().next());
            } else {
                operation.setName("x");
            }
        }
    }

    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull DartExpression expression) {
        DartComponentType type;
        if (expression == null) {
            DartIntroduceHandler.$$$reportNull$$$0(4);
        }
        PsiElement context = element;
        while ((type = DartComponentType.typeOf(context = PsiTreeUtil.getParentOfType((PsiElement)context, DartComponent.class, (boolean)true))) != null && DartIntroduceHandler.notFunctionMethodClass(type)) {
        }
        if (context == null) {
            context = expression.getContainingFile();
        }
        return DartRefactoringUtil.getOccurrences((PsiElement)expression, context);
    }

    private static boolean notFunctionMethodClass(DartComponentType type) {
        boolean isFunctionMethodClass = type == DartComponentType.METHOD || type == DartComponentType.FUNCTION || type == DartComponentType.CLASS;
        return !isFunctionMethodClass;
    }

    protected void performIntroduceWithDialog(DartIntroduceOperation operation) {
        PsiElement declaration;
        Project project = operation.getProject();
        if (operation.getName() == null) {
            DartIntroduceDialog dialog = new DartIntroduceDialog(project, this.myDialogTitle, operation);
            if (!dialog.showAndGet()) {
                return;
            }
            operation.setName(dialog.getName());
            operation.setReplaceAll(dialog.doReplaceAllOccurrences());
        }
        if ((declaration = this.performRefactoring(operation)) == null) {
            return;
        }
        Editor editor = operation.getEditor();
        editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
        editor.getSelectionModel().removeSelection();
    }

    protected void performInplaceIntroduce(DartIntroduceOperation operation) {
        DartComponentName componentName;
        List<PsiElement> occurrences = operation.getOccurrences();
        ArrayList<SmartPsiElementPointer> pointers = new ArrayList<SmartPsiElementPointer>(occurrences.size());
        for (PsiElement occurrence : occurrences) {
            pointers.add(SmartPointerManager.getInstance((Project)operation.getProject()).createSmartPsiElementPointer(occurrence));
        }
        PsiElement statement = this.performRefactoring(operation);
        DartComponent target = (DartComponent)PsiTreeUtil.findChildOfType((PsiElement)statement, DartComponent.class);
        DartComponentName dartComponentName = componentName = target != null ? target.getComponentName() : null;
        if (componentName == null) {
            return;
        }
        operation.getEditor().getCaretModel().moveToOffset(componentName.getTextOffset());
        occurrences.clear();
        for (SmartPsiElementPointer pointer : pointers) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            occurrences.add(element);
        }
        DartInplaceVariableIntroducer introducer = new DartInplaceVariableIntroducer(componentName, operation, occurrences);
        introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
    }

    @Nullable
    protected PsiElement performRefactoring(@NotNull DartIntroduceOperation operation) {
        PsiElement element;
        PsiElement anchor;
        if (operation == null) {
            DartIntroduceHandler.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = anchor = operation.isReplaceAll() ? DartIntroduceHandler.findAnchor(operation.getOccurrences()) : DartIntroduceHandler.findAnchor((PsiElement)operation.getInitializer());
        if (anchor == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)RefactoringBundle.getCannotRefactorMessage((String)DartBundle.message("dart.refactoring.introduce.anchor.error", new Object[0])), (String)DartBundle.message("dart.refactoring.introduce.error", new Object[0]), null);
            return null;
        }
        PsiElement declaration = this.createDeclaration(operation);
        if (declaration == null) {
            this.showCannotPerformError(operation.getProject(), operation.getEditor());
            return null;
        }
        SmartPsiElementPointer<PsiElement> pointer = this.performReplace(declaration, operation);
        PsiElement psiElement2 = element = pointer == null ? null : pointer.getElement();
        if (element != null) {
            declaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)element);
        }
        return declaration;
    }

    @Nullable
    public PsiElement createDeclaration(DartIntroduceOperation operation) {
        Project project = operation.getProject();
        DartExpression initializer = operation.getInitializer();
        InitializerTextBuilder builder = new InitializerTextBuilder();
        initializer.accept((PsiElementVisitor)builder);
        String assignmentText = this.getDeclarationString(operation, builder.result());
        return DartElementGenerator.createStatementFromText(project, assignmentText);
    }

    protected abstract String getDeclarationString(DartIntroduceOperation var1, String var2);

    @Nullable
    private SmartPsiElementPointer<PsiElement> performReplace(final @NotNull PsiElement declaration, final DartIntroduceOperation operation) {
        if (declaration == null) {
            DartIntroduceHandler.$$$reportNull$$$0(6);
        }
        final DartExpression expression = operation.getInitializer();
        final Project project = operation.getProject();
        return (SmartPsiElementPointer)new WriteCommandAction<SmartPsiElementPointer<PsiElement>>(project, new PsiFile[]{expression.getContainingFile()}){

            protected void run(@NotNull Result<SmartPsiElementPointer<PsiElement>> result) throws Throwable {
                PsiElement createdDeclaration;
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((createdDeclaration = DartIntroduceHandler.this.addDeclaration(operation, declaration)) != null) {
                    result.setResult((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(createdDeclaration));
                    DartIntroduceHandler.this.modifyDeclaration(createdDeclaration);
                }
                DartReference newExpression = DartIntroduceHandler.this.createExpression(project, operation.getName());
                if (operation.isReplaceAll()) {
                    ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
                    for (PsiElement occurrence : operation.getOccurrences()) {
                        PsiElement replaced = DartIntroduceHandler.this.replaceExpression(occurrence, (PsiElement)newExpression, operation);
                        if (replaced == null) continue;
                        newOccurrences.add(replaced);
                    }
                    operation.setOccurrences(newOccurrences);
                } else {
                    PsiElement replaced = DartIntroduceHandler.this.replaceExpression((PsiElement)expression, (PsiElement)newExpression, operation);
                    operation.setOccurrences(Collections.singletonList(replaced));
                }
                DartIntroduceHandler.this.postRefactoring(operation.getElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartIntroduceHandler$3", "run"));
            }
        }.execute().getResultObject();
    }

    protected void modifyDeclaration(@NotNull PsiElement declaration) {
        if (declaration == null) {
            DartIntroduceHandler.$$$reportNull$$$0(7);
        }
        PsiElement parent = declaration.getParent();
        PsiElement newLineNode = PsiParserFacade.SERVICE.getInstance((Project)declaration.getProject()).createWhiteSpaceFromText("\n");
        parent.addAfter(newLineNode, declaration);
        ASTNode nextChild = declaration.getNode().getTreeNext();
        parent.getNode().addLeaf(DartTokenTypes.SEMICOLON, (CharSequence)";", nextChild);
    }

    @Nullable
    protected DartReference createExpression(Project project, String name) {
        return DartElementGenerator.createReferenceFromText(project, name);
    }

    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PsiElement newExpression, DartIntroduceOperation operation) {
        return expression.replace(newExpression);
    }

    protected void postRefactoring(PsiElement element) {
    }

    @Nullable
    public PsiElement addDeclaration(DartIntroduceOperation operation, PsiElement declaration) {
        PsiElement anchor;
        PsiElement psiElement = anchor = operation.isReplaceAll() ? DartIntroduceHandler.findAnchor(operation.getOccurrences()) : DartIntroduceHandler.findAnchor((PsiElement)operation.getInitializer());
        if (anchor == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)RefactoringBundle.getCannotRefactorMessage((String)DartBundle.message("dart.refactoring.introduce.anchor.error", new Object[0])), (String)DartBundle.message("dart.refactoring.introduce.error", new Object[0]), null);
            return null;
        }
        PsiElement parent = anchor.getParent();
        return parent.addBefore(declaration, anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/refactoring/introduce/DartIntroduceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performReplace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InitializerTextBuilder
    extends PsiRecursiveElementVisitor {
        private final StringBuilder myResult = new StringBuilder();

        private InitializerTextBuilder() {
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
            this.myResult.append(space.getText().replace('\n', ' '));
        }

        public void visitElement(PsiElement element) {
            if (element.getChildren().length == 0) {
                this.myResult.append(element.getText());
            } else {
                super.visitElement(element);
            }
        }

        public String result() {
            return this.myResult.toString();
        }
    }

    private static class DartInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final DartComponentName myTarget;

        public DartInplaceVariableIntroducer(DartComponentName target, DartIntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Variable", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
            if (stringUsages == null) {
                DartInplaceVariableIntroducer.$$$reportNull$$$0(0);
            }
            for (PsiElement expression : this.getOccurrences()) {
                LOG.assertTrue(expression.isValid(), (Object)expression.getText());
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression, (Object)new TextRange(0, expression.getTextLength())));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringUsages", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartIntroduceHandler$DartInplaceVariableIntroducer", "collectAdditionalElementsToRename"));
        }
    }
}

