/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.extract;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.refactoring.ServerExtractMethodRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.extract.DartServerExtractMethodDialog;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerExtractMethodHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            DartServerExtractMethodHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            DartServerExtractMethodHandler.$$$reportNull$$$0(1);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            DartServerExtractMethodHandler.$$$reportNull$$$0(2);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int offset = selectionModel.getSelectionStart();
        int length = selectionModel.getSelectionEnd() - offset;
        ServerExtractMethodRefactoring refactoring = new ServerExtractMethodRefactoring(project, file.getVirtualFile(), offset, length);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions();
        if (initialStatus == null) {
            return;
        }
        if (initialStatus.hasError()) {
            String title = DartBundle.message("dart.refactoring.extract.method.error", new Object[0]);
            String message = initialStatus.getMessage();
            assert (message != null);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)title, null);
            return;
        }
        TextRange range = DartServerExtractMethodHandler.findRangeContainingCaret(offset, refactoring.getOccurrencesOffsets(), refactoring.getOccurrencesLengths());
        if (range != null) {
            selectionModel.setSelection(range.getStartOffset(), range.getEndOffset());
        }
        new DartServerExtractMethodDialog(project, editor, refactoring).show();
    }

    @Nullable
    private static TextRange findRangeContainingCaret(int caretOffset, int[] offsets, int[] lengths) {
        for (int i = 0; i < offsets.length; ++i) {
            int offset1 = offsets[i];
            int length1 = lengths[i];
            if (caretOffset < offset1 || caretOffset > offset1 + length1) continue;
            return TextRange.create((int)offset1, (int)(offset1 + length1));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

