/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.util.DartControlFlow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class DartExtractDialog
extends DialogWrapper {
    private final DartControlFlow myScope;
    private JLabel mySignatureLabel;
    private JPanel myMainPanel;
    private JTextField myFunctionNameField;

    protected DartExtractDialog(@Nullable Project project, String functionName, DartControlFlow scope) {
        super(project);
        this.myScope = scope;
        this.$$$setupUI$$$();
        this.myFunctionNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                DartExtractDialog.this.mySignatureLabel.setText(DartExtractDialog.this.myScope.getSignature(DartExtractDialog.this.getFunctionName()));
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DartExtractDialog.this.doOKAction();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.setTitle(DartBundle.message("dart.extract.method", new Object[0]));
        this.init();
        this.mySignatureLabel.setText(this.myScope.getSignature(functionName));
        this.myFunctionNameField.setText(functionName);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFunctionNameField;
    }

    public String getFunctionName() {
        return this.myFunctionNameField.getText();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!StringUtil.isJavaIdentifier((String)this.getFunctionName())) {
            return new ValidationInfo("Not a valid name!", (JComponent)this.myFunctionNameField);
        }
        return super.doValidate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Function name:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFunctionNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Signature:");
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySignatureLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

