/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import java.awt.Component;
import java.util.Set;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerRefactoringDialog<T extends ServerRefactoring>
extends RefactoringDialog {
    @Nullable
    protected final Editor myEditor;
    @NotNull
    protected final T myRefactoring;
    private boolean myHasPendingRequests;
    private RefactoringStatus myOptionsStatus;

    public ServerRefactoringDialog(@NotNull Project project, @Nullable Editor editor, @NotNull T refactoring) {
        if (project == null) {
            ServerRefactoringDialog.$$$reportNull$$$0(0);
        }
        if (refactoring == null) {
            ServerRefactoringDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myEditor = editor;
        this.myRefactoring = refactoring;
        ((ServerRefactoring)this.myRefactoring).setListener((hasPendingRequests, optionsStatus) -> {
            Runnable runnable = () -> {
                this.myHasPendingRequests = hasPendingRequests;
                this.myOptionsStatus = optionsStatus;
                this.validateButtons();
            };
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.getWindow());
            Condition expired = o -> !this.isShowing();
            ApplicationManager.getApplication().invokeLater(runnable, modalityState, expired);
        });
    }

    protected void canRun() throws ConfigurationException {
        if (this.myHasPendingRequests || this.myOptionsStatus == null) {
            throw new ConfigurationException(null);
        }
        if (this.myOptionsStatus.hasFatalError()) {
            throw new ConfigurationException(this.myOptionsStatus.getMessage());
        }
    }

    protected void doAction() {
        RefactoringStatus finalStatus = ((ServerRefactoring)this.myRefactoring).checkFinalConditions();
        if (finalStatus == null) {
            return;
        }
        if (finalStatus.hasError()) {
            Messages.showErrorDialog((Project)this.myProject, (String)finalStatus.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (this.hasPreviewButton() && this.isPreviewUsages() || this.isForcePreview()) {
            this.previewRefactoring();
        } else {
            this.doRefactoring(((ServerRefactoring)this.myRefactoring).getPotentialEdits());
        }
        this.close(0);
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected boolean isForcePreview() {
        return false;
    }

    protected void previewRefactoring() {
    }

    protected final void doRefactoring(@NotNull Set<String> excludedIds) {
        String error;
        if (excludedIds == null) {
            ServerRefactoringDialog.$$$reportNull$$$0(2);
        }
        if ((error = (String)WriteAction.compute(() -> {
            if (excludedIds == null) {
                ServerRefactoringDialog.$$$reportNull$$$0(3);
            }
            SourceChange change = ((ServerRefactoring)this.myRefactoring).getChange();
            assert (change != null);
            try {
                AssistUtils.applySourceChange(this.myProject, change, false, excludedIds);
            }
            catch (DartSourceEditException e) {
                return e.getMessage();
            }
            return null;
        })) == null) {
            this.close(0);
        } else {
            Messages.showErrorDialog((Project)this.myProject, (String)error, (String)CommonBundle.getErrorTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoring";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedIds";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/refactoring/ServerRefactoringDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRefactoring$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

