/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.server.GetRefactoringConsumer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusEntry;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusSeverity;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.dartlang.analysis.server.protocol.RefactoringProblem;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerRefactoring {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String refactoringName;
    @NotNull
    private final String kind;
    @NotNull
    private final VirtualFile file;
    private final int offset;
    private final int length;
    private final Set<Integer> pendingRequestIds;
    @Nullable
    private RefactoringStatus serverErrorStatus;
    @Nullable
    private RefactoringStatus initialStatus;
    @Nullable
    private RefactoringStatus optionsStatus;
    @Nullable
    private RefactoringStatus finalStatus;
    @Nullable
    private SourceChange change;
    @NotNull
    private final Set<String> potentialEdits;
    private int lastId;
    @Nullable
    private ServerRefactoringListener listener;

    public ServerRefactoring(@NotNull Project project, @NotNull String refactoringName, @NotNull String kind, @NotNull VirtualFile file, int offset, int length) {
        if (project == null) {
            ServerRefactoring.$$$reportNull$$$0(0);
        }
        if (refactoringName == null) {
            ServerRefactoring.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            ServerRefactoring.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ServerRefactoring.$$$reportNull$$$0(3);
        }
        this.pendingRequestIds = Sets.newHashSet();
        this.potentialEdits = Sets.newHashSet();
        this.lastId = 0;
        this.myProject = project;
        this.refactoringName = refactoringName;
        this.kind = kind;
        this.file = file;
        this.offset = offset;
        this.length = length;
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ServerRefactoring.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    protected VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            ServerRefactoring.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Nullable
    public RefactoringStatus checkFinalConditions() {
        ProgressManager.getInstance().run((Task)new Task.Modal(null, this.refactoringName, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Validating the specified parameters.");
                indicator.setIndeterminate(true);
                ServerRefactoring.this.setOptions(false, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/lang/dart/ide/refactoring/ServerRefactoring$1", "run"));
            }
        });
        if (this.serverErrorStatus != null) {
            return this.serverErrorStatus;
        }
        if (this.finalStatus == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.optionsStatus);
        result.merge(this.finalStatus);
        return result;
    }

    @Nullable
    public RefactoringStatus checkInitialConditions() {
        ProgressManager.getInstance().run((Task)new Task.Modal(null, this.refactoringName, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText("Checking availability at the selection.");
                indicator.setIndeterminate(true);
                ServerRefactoring.this.setOptions(true, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/lang/dart/ide/refactoring/ServerRefactoring$2", "run"));
            }
        });
        if (this.serverErrorStatus != null) {
            return this.serverErrorStatus;
        }
        return this.initialStatus;
    }

    @Nullable
    public SourceChange getChange() {
        return this.change;
    }

    @Nullable
    protected abstract RefactoringOptions getOptions();

    @NotNull
    public Set<String> getPotentialEdits() {
        Set<String> set = this.potentialEdits;
        if (set == null) {
            ServerRefactoring.$$$reportNull$$$0(6);
        }
        return set;
    }

    protected abstract void setFeedback(@NotNull RefactoringFeedback var1);

    public void setListener(@Nullable ServerRefactoringListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOptions(boolean validateOnly, @Nullable ProgressIndicator indicator) {
        int id;
        Set<Integer> set = this.pendingRequestIds;
        synchronized (set) {
            id = ++this.lastId;
            this.pendingRequestIds.add(id);
        }
        this.serverErrorStatus = null;
        final CountDownLatch latch = new CountDownLatch(1);
        RefactoringOptions options = this.getOptions();
        DartAnalysisServerService.getInstance(this.myProject).updateFilesContent();
        boolean success = DartAnalysisServerService.getInstance(this.myProject).edit_getRefactoring(this.kind, this.file, this.offset, this.length, validateOnly, options, new GetRefactoringConsumer(){

            @Override
            public void computedRefactorings(List<RefactoringProblem> initialProblems, List<RefactoringProblem> optionsProblems, List<RefactoringProblem> finalProblems, RefactoringFeedback feedback, SourceChange _change, List<String> _potentialEdits) {
                if (feedback != null) {
                    ServerRefactoring.this.setFeedback(feedback);
                }
                ServerRefactoring.this.initialStatus = ServerRefactoring.toRefactoringStatus(initialProblems);
                ServerRefactoring.this.optionsStatus = ServerRefactoring.toRefactoringStatus(optionsProblems);
                ServerRefactoring.this.finalStatus = ServerRefactoring.toRefactoringStatus(finalProblems);
                ServerRefactoring.this.change = _change;
                ServerRefactoring.this.potentialEdits.clear();
                if (_potentialEdits != null) {
                    ServerRefactoring.this.potentialEdits.addAll(_potentialEdits);
                }
                latch.countDown();
                this.requestDone(id);
            }

            @Override
            public void onError(RequestError requestError) {
                String message = "Server error: " + requestError.getMessage();
                ServerRefactoring.this.serverErrorStatus = RefactoringStatus.createFatalErrorStatus(message);
                latch.countDown();
                this.requestDone(id);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void requestDone(int id2) {
                Set set = ServerRefactoring.this.pendingRequestIds;
                synchronized (set) {
                    ServerRefactoring.this.pendingRequestIds.remove(id2);
                    ServerRefactoring.this.notifyListener();
                }
            }
        });
        if (!success) {
            return;
        }
        if (indicator != null) {
            boolean done;
            do {
                if (!indicator.isCanceled()) continue;
                throw new ProcessCanceledException();
            } while (!(done = Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS)));
            return;
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            boolean hasPendingRequests = !this.pendingRequestIds.isEmpty();
            RefactoringStatus status = this.optionsStatus != null ? this.optionsStatus : new RefactoringStatus();
            this.listener.requestStateChanged(hasPendingRequests, status);
        }
    }

    private static RefactoringStatusSeverity toProblemSeverity(@NotNull String severity) {
        if (severity == null) {
            ServerRefactoring.$$$reportNull$$$0(7);
        }
        if ("FATAL".equals(severity)) {
            return RefactoringStatusSeverity.FATAL;
        }
        if ("ERROR".equals(severity)) {
            return RefactoringStatusSeverity.ERROR;
        }
        if ("WARNING".equals(severity)) {
            return RefactoringStatusSeverity.WARNING;
        }
        return RefactoringStatusSeverity.OK;
    }

    private static RefactoringStatus toRefactoringStatus(@NotNull List<RefactoringProblem> problems) {
        if (problems == null) {
            ServerRefactoring.$$$reportNull$$$0(8);
        }
        RefactoringStatus status = new RefactoringStatus();
        for (RefactoringProblem problem : problems) {
            String serverSeverity = problem.getSeverity();
            RefactoringStatusSeverity problemSeverity = ServerRefactoring.toProblemSeverity(serverSeverity);
            String message = problem.getMessage();
            status.addEntry(new RefactoringStatusEntry(problemSeverity, message));
        }
        return status;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/refactoring/ServerRefactoring";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/refactoring/ServerRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialEdits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toProblemSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toRefactoringStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ServerRefactoringListener {
        public void requestStateChanged(boolean var1, @NotNull RefactoringStatus var2);
    }
}

